/*
**	ssh_debug.h	-- debug header for ssh core stuff
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#ifndef __SSH_DEBUG_H
#define __SSH_DEBUG_H

/*
#ifdef WIN32
#include <afxwin.h>
#endif
*/

#include <stdio.h>

#include "ssh_types.h"

#define SSH_YES_DEBUG		1	/* do debugging */
#define SSH_NO_DEBUG		0	/* don't do debugging */

#ifdef __cplusplus
extern "C" {
#endif

/*
**	activate/deactivate debugging for connection
*/
void ssh_debug_activate_new(struct ssh_struct * ssh_info, int mode);

/*
**	set the debugging function for a connection
*/
void ssh_debug_setfunc_new(struct ssh_debug_struct * debug_info,
	SSHDebugPrinter debug_func);

/*
**	log debugging for connection
*/
void ssh_debugger_new(struct ssh_debug_struct * debug_info,
	const char * msg, const char * head);
void ssh_debug_int_new(struct ssh_debug_struct * debug_info,
	const char * msg, int param1, const char * header);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_DEBUG_H */

