/*********************************************************************
**
**     File name:               ssh_misc.c
**                                  
**                              Copyright 1997 Tadayoshi Kohno.
**				All rights reserved.
**                              See the LICENSE file.
**
**     Purpose:                 handles misc. ssh-level "stuff"
**
**     Author/Date:             Tadayoshi Kohno, 16 December 1997
**
**     Notes:
**
**     Functions:
**	ssh_resize_window	client calls to resize server's window size
**
*********************************************************************/

#ifndef lint
static char *RCSid="$Header: /home/kohno/LibSSH/libssh.0.0.1beta/libssh/RCS/ssh_misc.c,v 3.0 1998/02/24 00:10:44 kohno Exp $";
#endif

#include "ssh.h"
#include "ssh_cmsg.h"
#include "ssh_comm.h"
#include "ssh_misc.h"

/*********************************************************************
**
**     Function:                ssh_resize_window
**
**     Purpose:                 tell the server of our new terminal size
**
**     Entry (pre) conditions:  connected to server over sockfd
**
**     Parameters:              sockfd		socket to server
*				ssh_info	connection-specific information
**				columns		our terminal width
**				rows		our terminal height
**
**     Return value:            S_GOOD
**
**     Error codes:             S_BAD		ssh_errno set accordingly
**
**     Side effects:            server knows current terminal size
**
**     Author/Date:             Tadayoshi Kohno, 16 December 1997
**
**     Notes:
**	The calling program can, of course, do this itself if it wants
**	to.
**
*********************************************************************/

int ssh_resize_window
(
	socket_type sockfd,		/* socket to server */
	struct ssh_struct * ssh_info,	/* connection-specific information */
	uint32_t columns,		/* new columns units */
	uint32_t rows			/* new row units */
)
{
	uint8_t data[SSH_MAX_PACKET];	/* data for packet */
	uint32_t data_len;		/* length of data in packet */
	
	if (ssh_cmsg_window_size_encode(data, &data_len, rows, columns, 0, 0)
		== S_BAD)
	{
		return(S_BAD);
	}

	if (ssh_send(sockfd, ssh_info, data, data_len, SSH_CMSG_WINDOW_SIZE)
		== S_BAD)
	{
		return(S_BAD);
	}

	return(S_GOOD);
}

