import java.io.*;

public class PGPBignumIO {

/**
 * Read a Bignum from a stream in PGP format
 * @param is InputStream to read Bignum from
 * @return Bignum read from stream
 */
public static Bignum fromStream(InputStream is) throws IOException
{
    int bits = is.read()<<8 | is.read();
    byte barr[] = new byte[(bits+7)/8];
    is.read(barr);
    return new Bignum(barr);
}

/**
 * Output a Bignum to a stream in PGP format
 * @param bn Bignum to output
 * @param os OutputStream to output on
 */
public static void toStream(Bignum bn, OutputStream os) throws IOException
{
    int bits = bn.countbits();
    os.write(bits>>8); os.write(bits&0xff);
    byte barr[] = new byte[(bits+7)/8];
    bn.getBytes(barr);
    os.write(barr);
}

/**
 * Tell how many bytes will be needed to output a Bignum
 * @param bn Bignum to output
 * @return number of bytes needed to output
 */
public static int nbytes(Bignum bn)
{
    int bits = bn.countbits();
    return 2 + (bits+7)/8;
}

}
