import java.awt.*;
import java.io.*;
import java.net.*;

/**
 * @(#)javamail.java    1.0     19 Feb 1996     Gavin Aiken
 *                                              <gavin@newsquest.co.uk>
 *
 * Copyright (c) 1996 Gavin Aiken. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL or COMMERCIAL purposes and
 * without fee is hereby granted.
 *
 * Simple smtp implementation, for applets
 * to send mail from a web page
 * 
 */

public class SMTPStream {

// Communication variables
private Socket s;
private DataInputStream in;
private DataOutputStream out;

// User name and version info
private String userName;
private String strVersion;

// Temporary storage for reply packets
private String strReply;
private String lastline;

// TCP port
private static final int smtpPort = 25;

// Constructor
public SMTPStream() {
}

public void expect(String expected, String msg) throws Exception {
    lastline = in.readLine();

    if (!lastline.startsWith(expected))
        throw new Exception(msg + ": " + lastline);

    while (lastline.startsWith(expected + "-"))
        lastline = in.readLine();
}

public void Connect(String smtpHost) throws Exception {
    try {
        s = new Socket(smtpHost, smtpPort);

        // Get Streams
        in = new DataInputStream(s.getInputStream());
        out = new DataOutputStream(s.getOutputStream());

    } catch(SecurityException se) {
        throw new Exception("smtpStream.Connect: security exception trying to connect to port " + smtpPort + " on host " + smtpHost);
    } catch(IOException ioe) {
        throw new Exception("smtpStream.Connect: IO exception trying to connect to port " + smtpPort + " on host " + smtpHost);
    }
}

public void Meet() throws Exception {
    expect("220", "smtpStream.Meet: greeting");

    out.writeBytes("HELO .\r\n");
    expect("250", "smtpStream.Meet: HELO");
}

public void SendMessage(String sender, String recipient, String subject, String message) throws Exception {
    try {
        int i = 0, j;
        StringBuffer messBuf = new StringBuffer();
        while((j = (message.indexOf("\n.\n", i))) != -1) {
            messBuf.append(message.substring(i, j) + "\n..\n");
            i = j + 3;
        }
        if( i > 0 ) {
            messBuf.append(message.substring(i));
            message = messBuf.toString();
        }

        out.writeBytes("MAIL FROM: <" + sender + ">\r\n");
        expect("250", "smtpStream.SendMessage: MAIL FROM");

        out.writeBytes("RCPT to: <" + recipient + ">\r\n");
        expect("250", "smtpStream.SendMessage: RCPT TO");

        out.writeBytes("DATA\r\n");
        expect("354", "smtpStream.SendMessage: DATA");

        out.writeBytes("Subject: " + subject + "\r\n");
        out.writeBytes("To: " + recipient + "\r\n");
        out.writeBytes("X-Comment: Sender is not authenticated\r\n");
        out.writeBytes("X-Comment: Report unwanted mail to hal@rain.org\r\n");
        out.writeBytes("\r\n");
        out.writeBytes(message+"\r\n");
        out.writeBytes("\r\n.\r\n");
        expect("250", "smtpStream.SendMessage: EOM");

    } catch(IOException e) {
        throw new Exception("smtpStream.SendMessage: IO exception");
    }
}

public void Disconnect() throws Exception {
    try {
        out.writeBytes("QUIT\r\n");
        expect("221", "smtpStream.Disconnect: QUIT");

        // Close Streams
        in.close();
        out.close();

        // Close socket
        s.close();
    } catch(IOException e) {
        throw new Exception("smtpStream.Disconnect: IO exception");
    }
}

}


