-----BEGIN PGP SIGNED MESSAGE-----

		     Phil's Pretty Good Software
			       presenta

				 ===
				 PGP
				 ===

			 Pretty Good Privacy
			Intimidad Bastante Buena
		 Cifrado de clave pblica para todos


		      --------------------------
			Gua del Usuario de PGP
		      Volumen I: Temas esenciales
		      ---------------------------
			 por Philip Zimmermann
		     Revisada el 14 de junio de 1993


		      PGP Versin 2.3 - 13 junio 93
			  Programa escrito por
			    Philip Zimmermann
				   con
	      Branko Lankester, Hal Finney y Peter Gutmann




Sinopsis:  PGP utiliza criptografa de clave pblica para proteger el 
correo electrnico y los ficheros de datos. Comunquese con seguridad 
con personas a las que nunca ha visto, sin necesidad de canales seguros 
para intercambiar claves. PGP es rpido y tiene muchas prestaciones, 
entre las que se incluyen una completa gestin de claves, firmas 
digitales, compresin de datos y un buen diseo ergonmico.


Programa y documentacin (c) Copyright 1990-1992 Philip Zimmermann.
Para obtener ms informacin sobre licencias, distribucin, copyright, 
patentes, marcas registradas, limitaciones de responsabilidad y 
controles de exportacin de PGP, vase la seccin "Consideraciones 
legales" en la "Gua del usuario de PGP, volumen II: Temas especiales".

( indica que hay una nota del traductor en el fichero NOTAS.ES)


Indice
======

Descripcin general
Por qu puede necesitar PGP
Cmo funciona
Instalacin de PGP
Cmo utilizar PGP
  Para ver un resumen de las instrucciones
  Encriptacin de un mensaje
  Encriptacin de un mensaje para mltiples destinatarios
  Firma de un mensaje
  Firma y posterior encriptacin
  Utilizacin de encriptacin convencional exclusivamente
  Gestin de claves
    Generacin de claves RSA
    Adicin de una clave al fichero
    Supresin de una clave o identificador del fichero
    Extraccin (copia) de una clave del fichero
    Visualizacin del contenido del fichero
    Cmo proteger las claves pblicas contra manipulacin
    Cmo controla PGP la validez de las claves
    Cmo proteger las claves secretas contra revelacin
    Revocacin de una clave pblica
    Qu pasa si pierde la clave secreta?
Temas avanzados
  Envo de texto cifrado por canales de correo-E: formato Radix-64
  Variable de entorno para la trayectoria
  Establecimiento de parmetros de configuracin: CONFIG.TXT
Puntos vulnerables
Cuidado con los elixires mgicos
Referencia rpida para PGP
Consideraciones legales
Agradecimientos
Acerca del autor


Descripcin general
===================

Pretty Good(mr) Privacy (PGP), "intimidad bastante buena", de Phil's 
Pretty Good Software, es una aplicacin informtica de criptografa de 
alta seguridad para MSDOS, Unix, VAX/VMS y otros ordenadores. PGP 
permite intercambiar ficheros y mensajes con intimidad, autenticacin y 
comodidad. Intimidad quiere decir que slo pueden leer el mensaje 
aquellos a quienes va dirigido. Autenticacin quiere decir que los 
mensajes que parecen ser de una persona slo pueden venir de esa persona 
en particular. Comodidad quiere decir que la intimidad y la 
autenticacin se logran sin los problemas de gestin de claves asociados 
a otros programas de criptografa convencional. No se necesitan canales 
seguros para intercambiar claves entre usuarios, por lo que PGP resulta 
mucho ms fcil de utilizar. Esto se debe a que PGP est basado en una 
potente tecnologa nueva llamada criptografa de "clave pblica".

PGP combina la comodidad del criptosistema de clave pblica de 
Rivest-Shamir-Adleman (RSA) con la velocidad de la criptografa 
convencional, resmenes de mensajes para firmas digitales, compresin de 
datos antes de encriptar, un buen diseo ergonmico y una completa 
gestin de claves. Por otra parte, PGP realiza las funciones de clave 
pblica ms rpido que la mayora de las otras implementaciones 
informticas. PGP es criptografa de clave pblica para todos.

PGP no lleva incorporada comunicacin por modem. Para ello debe 
utilizarse otro programa distinto.

Este documento, "Volumen I: Temas esenciales", slo explica los 
conceptos esenciales sobre la utilizacin de PGP, y deberan leerlo 
todos los usuarios. El "Volumen II: Temas especiales" trata las 
caractersticas avanzadas y otros temas especiales, y est orientado a 
aquellos usuarios que vayan a utilizar PGP ms en serio. Ninguno de los 
documentos ofrece detalles sobre la tecnologa en la que se basan los 
algoritmos criptogrficos y las estructuras de datos.


Por qu puede necesitar PGP
===========================

Es personal. Es privado. Y no le concierne a nadie ms que a usted. 
Puede estar planificando una campaa poltica, tratando sobre sus 
impuestos o teniendo una relacin ilcita. O puede estar haciendo algo 
que segn usted no debera ser ilegal, pero que lo es. Sea lo que fuere, 
no quiere que nadie ms lea su correo electrnico (correo-E) privado ni 
sus documentos confidenciales. No hay nada malo en afirmar su derecho a 
la intimidad. El derecho a la intimidad es tan bsico como la 
Constitucin.

Quiz piense que su correo-E es lo bastante legtimo como para no 
necesitar encriptacin. Si usted es en realidad un ciudadano respetuoso 
con la ley, sin nada que ocultar, por qu no enva siempre el correo 
habitual en postales? Por qu no se somete voluntariamente a pruebas de 
deteccin de drogas? Por qu exige un mandamiento judicial para que la 
polica registre su casa? Est intentando esconder algo? Debe de ser un 
subversor, o un traficante de drogas, si oculta el correo en sobres. O 
quiz un excntrico paranoico. Tienen los ciudadanos que cumplen la ley 
alguna necesidad de encriptar su correo-E?

Qu pasara si todo el mundo creyese que los ciudadanos observantes de 
la ley deberan utilizar postales para enviar el correo?  Si algn 
espritu valiente intentase afirmar su intimidad utilizando un sobre, 
levantara sospechas. Quiz las autoridades abriran su correo para ver 
qu est ocultando. Afortunadamente no vivimos en un mundo as, y todos 
protegen la mayor parte del correo con sobres. Nadie levanta sospechas 
por afirmar su intimidad con un sobre. Hay seguridad en los grandes 
nmeros. De forma anloga, sera interesante que todo el mundo utilizase 
habitualmente el cifrado en el correo-E, fuese inocente o no, para que 
nadie levantase sospechas por afirmar de esa manera su derecho a la 
intimidad. Piense en ello como una forma de solidaridad.

Hoy en da, si el gobierno quiere invadir la intimidad de los ciudadanos 
corrientes tiene que emplear una cierta cantidad de esfuerzo y dinero en 
interceptar y abrir al vapor el correo normal, y en escuchar, y quiz 
transcribir, las conversaciones telefnicas. Este tipo de control, muy 
laborioso, no resulta prctico a gran escala. Slo se realiza en casos 
importantes, donde parece que va a merecer la pena.

Cada vez una mayor parte de nuestra comunicacin privada se dirige por 
canales electrnicos. El correo electrnico reemplazar gradualmente al 
correo convencional. Los mensajes por correo-E son, sencillamente, 
demasiado fciles de interceptar y de explorar para buscar palabras 
interesantes. Puede hacerse a gran escala, fcilmente, habitualmente, 
automticamente y de una forma imposible de detectar. La NSA explora ya 
de esta manera los cablegramas internacionales.

Nos dirigimos hacia un futuro en el que los pases estarn cruzados de 
lado a lado por redes de datos basadas en fibra ptica de alta 
capacidad, conectando todos nuestros ordenadores personales, cada vez 
ms ubicuos. El correo-E ser la norma para todos, no la novedad que 
resulta hoy en da. Puede que el gobierno proteja nuestro correo-E con 
algoritmos de cifrado diseados por ellos mismos. Y puede que la mayora 
de la gente confe en ellos. Pero algunas personas preferirn tomar sus 
propias medidas de proteccin.

La propuesta de ley 266 del Senado de los Estados Unidos, una propuesta 
conjunta contra el delito, tena oculta una medida inquietante. Si esta 
resolucin no vinculante hubiese llegado a ser ley, habra obligado a 
los fabricantes de equipos de comunicaciones seguras a incluir 
"escotillas" en sus productos, para que el Gobierno pudiese leer 
cualquier mensaje cifrado. {Su traduccin al castellano} es la 
siguiente:  "Es la opinin del Congreso que los proveedores de servicios 
de comunicacin electrnica y los fabricantes de equipos para servicios 
de comunicacin electrnica deben garantizar que los sistemas de 
comunicacin permitan al Gobierno obtener el contenido en texto normal 
de las comunicaciones de voz, datos y otras comunicaciones, cuando estn 
adecuadamente autorizados por la ley". Esta medida fue desestimada tras 
una rigurosa protesta por parte de defensores de la libertad civil y de 
grupos empresariales.

En 1992, la propuesta del FBI sobre intervencin de telefona digital se 
present en el Congreso norteamericano. Obligara a todos los 
fabricantes de equipos de comunicaciones a integrar unos puertos 
especiales para la intervencin a distancia, que permitira al FBI 
intervenir todo tipo de comunicacin electrnica desde sus oficinas. 
Aunque nunca ha conseguido ningn apoyo en el Congreso gracias a la 
oposicin ciudadana, se volver a presentar en 1993.

Lo ms alarmante es la nueva enrgica iniciativa de la Casa Blanca sobre 
poltica criptogrfica, desarrollada en la NSA durante cuatro aos, y 
presentada el 16 de Abril de 1993. La parte principal de esta iniciativa 
es un dispositivo criptogrfico construido por el Gobierno, llamado el 
"chip Clipper", que contiene un nuevo algoritmo criptogrfico secreto de 
la NSA. El Gobierno est animando a las empresas privadas a que lo 
incluyan en todos sus productos de comunicaciones seguras, como 
telfonos, FAX, etc. AT&T est poniendo Clipper en todos sus productos 
seguros para voz. La trampa:  en la fbrica, cada chip Clipper se 
cargar con su propia clave nica, y el Gobierno mantiene una copia en 
depsito. Pero no hay que preocuparse-- el Gobierno promete que slo 
utilizar esas claves para leer las comunicaciones cuando est 
autorizado por la ley. Naturalmente, para que Clipper sea efectivo, el 
siguiente paso lgico sera proscribir otras formas de criptografa.

Si la intimidad se proscribe, slo los proscritos tendrn intimidad. Los 
servicios de inteligencia tienen acceso a tecnologa criptogrfica de 
calidad. Lo mismo ocurre con los grandes traficantes de armas y de 
drogas. Tambin disponen de ellos los contratistas del ejrcito, las 
compaas de petrleo y otros gigantes empresariales. Pero la mayora de 
la gente normal y de las organizaciones polticas de base no han tenido 
nunca a su alcance una tecnologa asequible para utilizar criptologa de 
clave pblica de "grado militar". Hasta ahora.

PGP da a la gente la capacidad de dejar su intimidad en sus propias 
manos. Hay una creciente demanda social para ello. Por eso lo escrib.


Cmo funciona
=============

Sera de ayuda que usted estuviese familiarizado con el concepto de 
criptografa en general, y con el de criptografa de clave pblica en 
particular. En cualquier caso, he aqu unas cuantas observaciones como 
introduccin.

En primer lugar, algo de vocabulario bsico. Supongamos que quiero 
enviarle un mensaje que nadie excepto usted pueda leer. Podra 
"encriptar" o "cifrar" el mensaje, que significa revolverlo de una forma 
tremendamente complicada, hacindolo ilegible para cualquiera que no sea 
usted, el destinatario original del mensaje. Yo pongo una "clave" 
criptogrfica para encriptar el mensaje, y usted tiene que utilizar la 
misma clave para descifrarlo o "desencriptarlo". Por lo menos as 
funciona en los criptosistemas convencionales de "clave nica".

En los criptosistemas convencionales, como el US Federal Data Encryption 
Standard (DES) {Norma Federal para Cifrado de Datos en EEUU}, se utiliza 
una sola clave para encriptar y desencriptar. Por lo tanto, hay que 
transmitir primero la clave por medio de un canal seguro, para que ambas 
partes la sepan antes de enviar mensajes cifrados por canales inseguros. 
Este proceso puede resultar incmodo. Si se tiene un canal seguro para 
intercambiar claves, para qu se necesita entonces criptografa?

En criptosistemas de clave pblica, todo el mundo tiene dos claves 
complementarias, una revelada pblicamente y otra secreta. Cada clave 
abre el cdigo que produce la otra. Saber la clave pblica no sirve para 
deducir la clave secreta correspondiente. La clave pblica puede 
publicarse y distribuirse ampliamente por una red de comunicaciones. 
Este protocolo proporciona intimidad sin necesidad de ese tipo de canal 
seguro que requieren los criptosistemas convencionales.

Cualquiera puede utilizar la clave pblica de un destinatario para 
encriptar un mensaje, y  emplear su propia clave secreta 
correspondiente para desencriptarlo. Slo l podr hacerlo, porque nadie 
ms tiene acceso a esa clave secreta. Ni siquiera la persona que lo 
encript podra desencriptarlo.

Tambin se proporciona autenticacin para mensajes. La clave secreta del 
remitente puede emplearse para encriptar un mensaje, "firmndolo". As 
se crea una firma digital, que el destinatario (o cualquier otra 
persona) puede comprobar utilizando la clave pblica del remitente para 
desencriptarla. De esta forma se prueba el verdadero origen del mensaje, 
y que no ha sido alterado por nadie, ya que slo el remitente posee la 
clave secreta que ha producido esa firma. No es posible falsificar un 
mensaje firmado, y el remitente no podr desautorizar su firma ms 
adelante.

Estos dos procesos pueden combinarse para obtener intimidad y 
autenticacin al mismo tiempo, si se firma primero el mensaje con la 
clave secreta y se encripta despus el mensaje firmado con la clave 
pblica del destinatario. El destinatario sigue estos pasos en sentido 
contrario, al desencriptar primero el mensaje con su propia clave 
secreta y comprobar despus la firma con la clave pblica del remitente. 
El programa lo hace automticamente.

Como el algoritmo de cifrado en clave pblica es mucho ms lento que el 
cifrado convencional de clave nica, el proceso se realiza ms 
eficazmente con un algoritmo convencional rpido y de calidad, de clave 
nica, para encriptar el mensaje. El mensaje original sin encriptar se 
denomina "texto normal". Sin intervencin del usuario, se utiliza una 
clave aleatoria temporal, generada slo para esa "sesin", para 
encriptar convencionalmente el fichero normal. Despus se encripta esa 
clave aleatoria convencional con la clave pblica del destinatario. La 
clave de la "sesin" convencional, encriptada con esa clave pblica, se 
enva al destinatario junto al texto cifrado. El destinatario recupera 
esa clave temporal con su propia clave secreta, y ejecuta con ella el 
algoritmo convencional de clave nica, que es ms rpido, para 
desencriptar el mensaje cifrado.

Las claves pblicas se guardan en "certificados de clave" individuales, 
que incluyen el identificador de usuario del propietario (el nombre de 
esa persona {y algun dato nico, como la direccin de correo-E}), un 
sello de hora del momento en el que se gener el par y el material 
propio de la clave. Cada clave secreta est encriptada con su propia 
contrasea, por si alguien la roba. Cada fichero de claves contiene uno 
o ms de esos certificados.

Las claves se identifican internamente mediante "identificador de 
clave", que es una "abreviatura" de la clave pblica (sus 64 bits menos 
significativos). Cuando se muestra este identificador, slo aparecen los 
24 bits inferiores, para mayor brevedad. Aunque muchas claves pueden 
compartir el mismo identificador de usuario, a efectos prcticos no hay 
dos claves que compartan el mismo identificador de clave.

PGP utiliza "resmenes de mensaje" para elaborar las firmas. Un resumen 
de mensaje es una funcin "distribucin" ("hash") unidireccional de 128 
bits, criptogrficamente resistente, de ese mensaje. Es anlogo en 
cierta manera a una "suma de verificacin" o cdigo CRC de comprobacin 
de errores en que "representa" el mensaje de forma compacta y se utiliza 
para detectar cambios en l. A diferencia de un CRC, sin embargo, le 
resultar computacionalmente impracticable a un atacante idear un 
mensaje sustitutivo que produzca un resumen idntico. El resumen del 
mensaje se encripta con la clave secreta para elaborar la firma.

Los documentos se firman aadindoles como prefijo un certificado de 
firma, con el identificador de la clave que se utiliz para realizarla, 
un resumen de mensaje del documento (firmado con la clave secreta) y un 
sello de hora del momento de la firma. El destinatario utiliza el 
identificador de la clave para buscar la clave pblica del remitente y 
comprobar la firma. El programa busca automticamente la clave pblica y 
el identificador usuario en el fichero de claves correspondiente.

Los ficheros cifrados llevan como prefijo el identificador de la clave 
pblica con la que se han encriptado. El destinatario utiliza este 
prefijo de identificacin para encontrar la clave secreta y poder 
desencriptar el mensaje. Su programa busca automticamente la clave 
secreta en el fichero de claves correspondiente.

Estos dos tipos de fichero constituyen el mtodo principal para 
almacenar y gestionar las claves pblicas y secretas. En lugar de 
mantener las claves individuales en ficheros separados, se renen en 
ficheros para facilitar la bsqueda automtica, ya sea por identificador 
de clave o por identificador de usuario. Cada usuario mantiene su propio 
par de ficheros. Las claves pblicas individuales se mantienen en 
ficheros aparte durante el tiempo necesario para enviarlas a algn 
amigo, que las aadir entonces a su propio fichero de claves.


Instalacin de PGP
==================

El lanzamiento para MSDOS de PGP 2.3 va en un archivo comprimido llamado 
PGP23.ZIP (cada nuevo lanzamiento tendr un nombre como "PGPxy.ZIP", 
indicando la versin de PGP nmero x.y). El archivo puede descomprimirse 
con la utilidad compartida de descompresin PKUNZIP, o con la utilidad 
"unzip" de Unix. El lanzamiento de PGP contiene un fichero llamado 
LEAME.DOC que debera leer antes de instalar PGP. Este fichero LEAME.DOC 
contiene las ltimas noticias acerca de las novedades en el lanzamiento 
de PGP, adems de informacin sobre qu hay en los otros ficheros 
incluidos.

Si tiene todava la versin 1.0 de PGP para MSDOS, casi debera 
borrarla, porque ya nadie la utiliza. Si no quiere hacerlo, renombre el 
antiguo fichero ejecutable como pgp1.exe, para evitar conflictos con el 
nuevo PGP.

Para instalar PGP en su sistema MSDOS, slo tiene que copiar el archivo 
comprimido PGPxx.ZIP en un directorio apropiado del disco duro (como 
C:\PGP), y descomprimirlo con PKUNZIP. Para obtener un resultado ptimo, 
tiene tambin que modificar el fichero AUTOEXEC.BAT, tal como se 
describe en otra parte del manual; pero eso puede esperar a que haya 
jugado un poco con PGP y haya ledo algo ms. Si no ha ejecutado PGP 
antes, el primer paso despus de instalarlo (y leer este manual) es 
ejecutar la orden de generacin de claves de PGP "pgp -kg".

La instalacin en Unix y VAX/VMS es parecida a la instalacin en MSDOS, 
pero tendr que compilar antes el cdigo fuente. Para ello se incluye un 
"makefile" de Unix con ese cdigo.

Para obtener ms informacin sobre este tema, consulte la Gua de 
instalacin de PGP en el fichero INSTALAR.DOC incluido con esta versin. 
Describe en detalle cmo configurar el directorio PGP y el fichero 
AUTOEXEC.BAT, y cmo utilizar PKUNZIP para instalarlo.


Cmo utilizar PGP
=================

Para ver un resumen de las instrucciones
=---------------------------------------

Para ver un resumen rpido de las instrucciones de PGP, escriba:

     pgp -h


Encriptacin de un mensaje
=-------------------------

Para encriptar un fichero de texto normal con la clave pblica del 
destinatario, escriba:

     pgp -e ftexto identificador_des

Esta orden produce un texto cifrado llamado ftexto.pgp. Un ejemplo 
podra ser:

     pgp -e carta.txt Alice
o:
     pgp -e carta.txt "Alice S"

El primer ejemplo busca en el fichero de claves pblicas "pubring.pgp" 
algn certificado que contenga la cadena de caracteres "Alice" en el 
campo del identificador de usuario. El segundo ejemplo encontrar 
cualquier identificador que contenga "Alice S". No se pueden incluir 
espacios en la cadena dentro de la lnea de rdenes, a menos que sea 
entre comillas. La bsqueda no tiene en cuenta el tipo de letra 
(maysculas o minsculas). Si se encuentra una clave pblica que 
coincide, PGP la utiliza para encriptar el fichero normal "carta.txt", 
produciendo un fichero cifrado llamado "carta.pgp".

PGP intenta comprimir el texto normal antes de encriptarlo, mejorando 
considerablemente su resistencia al criptoanlisis. Por esta razn, el 
fichero cifrado ser probablemente menor que el fichero normal.

Si quiere enviar el mensaje cifrado por canales de correo-E, convirtalo 
al formato ASCII imprimible "radix-64" aadiendo la opcin -a, tal como 
se describe ms adelante.


Encriptacin de un mensaje para mltiples destinatarios
=------------------------------------------------------

Si quiere enviar el mismo mensaje a ms de una persona, puede hacer que 
se encripte para varios destinatarios, cualquiera de los cuales podra 
desencriptar el mismo fichero. Para indicar mltiples destinatarios, 
slo tiene que aadir ms identificadores en la lnea de rdenes, como:

     pgp -e carta.txt Alice Bob Carol

As se creara un fichero cifrado llamado carta.pgp que podra 
desencriptar Alice, Bob o Carol. Puede indicarse cualquier nmero de 
destinatarios.


Firma de un mensaje
=------------------

Para firmar un fichero normal con su clave secreta, escriba:

     pgp -s ftexto [-u su_identificador]

Ntese que los [corchetes] indican un campo opcional, por lo que no 
deben escribirse.

Esta orden produce un fichero firmado llamado ftexto.pgp. Un ejemplo 
podra ser:

     pgp -s carta.txt -u Bob

Esta orden buscara en su fichero de claves secretas "secring.pgp" 
cualquier certificado que contenga la cadena "Bob" en el campo del 
identificador de usuario. La bsqueda no tiene en cuenta el tipo de 
letra. Si se encuentra una clave secreta que coincida, PGP la utiliza 
para firmar el fichero normal "carta.txt", produciendo un fichero 
firmado "carta.pgp".

Si no se incluye el campo de identificador de usuario, se utiliza para 
la firma la clave ms reciente del fichero de claves secretas como 
eleccin por omisin.


Firma y posterior encriptacin
=-----------------------------

Para firmar un fichero normal con su clave secreta, y despus 
encriptarlo con la clave pblica del destinatario:

     pgp -es ftexto identificador_des [-u su_identificador]

Ntese que los [corchetes] indican un campo opcional, por lo que no 
deben escribirse.

Este ejemplo produce un fichero cifrado anidado, ftexto.pgp. La clave 
secreta para firmar se busca automticamente en el fichero 
correspondiente por medio de su_identificador. La clave pblica de 
encriptacin para el destinatario se busca automticamente en el fichero 
de claves pblicas por medio de identificador_des. Si no incluye el 
identificador de usuario del destinatario, se le pedir que lo haga.

Si no indica su propio campo de identificador de usuario, se utiliza la 
clave ms reciente del fichero de claves secretas como eleccin por 
omisin para la firma.

Ntese que PGP intentar comprimir el texto normal antes de encriptarlo.

Si quiere enviar este mensaje cifrado por medio de canales de correo-E, 
convirtalo al formato ASCII imprimible "radix-64" aadiendo la opcin 
- -a, tal como se describe ms adelante.

Pueden indicarse mltiples destinatarios aadiendo ms identificadores 
en la lnea de rdenes.


Utilizacin de encriptacin convencional exclusivamente
=------------------------------------------------------

Algunas veces slo hace falta encriptar un fichero al estilo antiguo, 
con criptografa convencional de clave nica. Este sistema resulta 
conveniente para proteger aquellos ficheros de archivo que se vayan a 
almacenar, sin enviar a nadie. Dado que va a desencriptar el fichero la 
misma persona que lo ha encriptado, no se necesita realmente 
criptografa de clave pblica.

Para encriptar un fichero normal slo con criptografa convencional, 
escriba:

     pgp -c ftexto

Este ejemplo encripta el fichero normal ftexto, produciendo un fichero 
cifrado ftexto.pgp, sin criptografa de clave pblica, ficheros de 
claves, identificadores de usuario ni nada de eso. Pedir una frase de 
contrasea como clave convencional para encriptar el fichero. Esta 
frase no tiene por qu ser (de hecho, NO DEBERIA ser) la misma que 
utiliza para proteger su propia clave secreta. Ntese que PGP intentar 
comprimir el fichero antes de encriptarlo.

PGP nunca encripta el mismo texto normal dos veces de la misma forma, 
incluso con la misma frase de contrasea.


Desencriptacin y comprobacin de firmas
=---------------------------------------

Para desencriptar un fichero cifrado, o para comprobar la integridad de 
un fichero firmado:

     pgp fcifrado [-o fnormal]

Ntese que los [corchetes] indican un campo opcional, por lo que no 
deben escribirse.

Se asume que, por omisin, el nombre del fichero cifrado tiene una 
extensin ".pgp". El nombre opcional de salida para el texto normal 
indica dnde hay que poner el texto procesado. Si no se indica ningn 
nombre, se utiliza el mismo del fichero cifrado, sin extensin. Si se 
anida una firma dentro de un fichero cifrado, esta se desencripta 
automticamente y se comprueba su integridad. Se mostrar el 
identificador completo del firmante.

Ntese que el "desembalaje" del fichero cifrado es completamente 
automtico, sin importar si est firmado, cifrado o ambas cosas. PGP 
utiliza el prefijo del identificador de clave en el fichero cifrado para 
encontrar automticamente la clave secreta en el fichero. Si hay una 
firma anidada, PGP usa el prefijo de identificador de esa clave para 
encontrar automticamente la clave pblica en el fichero correspondiente 
y comprobarla. Si las claves adecuadas estn en los ficheros de claves 
no se requiere ms intervencin, excepto para dar la contrasea de la 
clave secreta, en su caso. Si el fichero haba sido encriptado sin 
criptografa de clave pblica, PGP lo reconoce y pide la contrasea para 
desencriptarlo convencionalmente.



Gestin de claves
=================

Desde los tiempos de Julio Csar, la gestin de claves ha sido el 
aspecto ms difcil de la criptografa. Una de las caractersticas que 
distinguen a PGP es su completa gestin de claves.


Generacin de claves RSA
=-----------------------

Para generar su propio par nico de claves pblica/secreta de un tamao 
determinado, escriba:

     pgp -kg

PGP le mostrar un men de tamaos recomendados para la clave (nivel 
aficionado, nivel comercial y nivel militar), y le pedir qu indique 
qu tamao de clave quiere, hasta aproximadamente mil bits. Cuanto ms 
grande es la clave, mayor es la seguridad que se obtiene, pero el precio 
es una disminucin de la velocidad.

Tambin se pide un identificador de usuario, esto es, su nombre. Resulta 
conveniente poner como identificador un nombre completo, porque as hay 
menor probabilidad de que otras personas elijan una clave pblica 
equivocada para encriptar los mensajes dirigidos a usted. En el 
identificador de usuario se permiten espacios y signos de puntuacin. 
Tambin conviene poner su direccin de correo-E entre <ngulos> despus 
del nombre, como en:

     Juan Espannol <juan@basa.org>

Si no tiene direccin de correo-E, ponga su nmero de telfono u otra 
informacin que ayude a garantizar la unicidad de su identificador.

PGP tambin pedir una "frase de contrasea" para proteger su clave 
secreta en caso de que caiga en otras manos. Nadie podr utilizar su 
clave secreta sin esta frase. La frase de contrasea es como una 
contrasea habitual, excepto en que puede ser una expresin o frase con 
varias palabras, espacios, signos de puntuacin o cualquier otra cosa 
que quiera poner. No la pierda, porque no hay forma de recuperarla. La 
frase de contrasea le har falta ms adelante, cada vez que utilice su 
clave secreta. Se tiene en cuenta el tipo de letra (mayscula o 
minscula), y la frase no debe ser ni demasiado corta ni fcil de 
adivinar. Nunca aparece en la pantalla. No la deje escrita donde alguien 
pueda verla, ni la almacene en su ordenador. Si no quiere tener frase de 
contrasea (no sea tonto!), simplemente pulse retorno (enter) en el 
indicador correspondiente.

El par de claves pblica/secreta se deriva de grandes nmeros 
verdaderamente aleatorios, obtenidos al medir intervalos de tiempo entre 
pulsaciones de tecla, con un temporizador rpido. El programa le pedir 
que introduzca un texto al azar para poder acumular algunos bits 
aleatorios para las claves. Cuando se le pida, debe pulsar algunas 
teclas razonablemente al azar, y no vendra mal que tambin su contenido 
fuera irregular. Parte de la aleatoriedad se deriva de la 
impredictibilidad del contenido de lo que escribe. Por lo tanto, no 
escriba secuencias repetidas de caracteres.

Tenga en cuenta que la generacin de claves RSA es un proceso MUY lento. 
Puede llevar unos segundos para una clave pequea en un procesador 
rpido, o varios minutos para una clave larga en un viejo IBM PC/XT.

El par de claves generado se colocar en sus ficheros de claves pblicas 
y secretas. Puede utilizar ms adelante la orden -kx y extraer (copiar) 
su nueva clave pblica desde el fichero correspondiente, para ponerla en 
un fichero de clave separado, listo para distribuir entre sus amigos. 
Podr enviar este fichero para que lo incluyan en sus ficheros de claves 
pblicas. Naturalmente, la clave secreta es para usted, y debera 
incluirlo en su fichero de claves secretas. Cada clave secreta est 
protegida individualmente por su propia contrasea.

Nunca d su clave secreta a nadie. Por la misma razn, no haga pares de 
claves para sus amigos. Cada uno debe hacer el suyo. Mantenga siempre 
control fsico sobre su clave secreta, y no se arriesgue a exponerla 
almacenndola en un ordenador remoto compartido. Consrvela en su propio 
ordenador personal.


Adicin de una clave al fichero
=------------------------------

Para aadir el contenido de un fichero de claves pblicas o secretas al 
fichero de claves correspondiente (ntese que los [corchetes] indican un 
campo opcional):

     pgp -ka fdclaves [fichero]

La extensin por omisin del fichero es ".pgp". El nombre opcional del 
fichero es, por omisin, "pubring.pgp" o "secring.pgp", segn se refiera 
a claves pblicas o secretas. Puede indicarse un nombre diferente para 
el fichero, y tambin su extensin por omisin ser ".pgp".

Si la clave ya est en el fichero, PGP no la aade otra vez. Se incluyen 
todas las claves del fichero, excepto las duplicadas. Si la clave para 
aadir incluye firmas que la certifican, se incorporan junto con ella. 
Si ya se encontraba en el fichero, PGP solamente aadir las firmas que 
no estuviesen.


Supresin de una clave del fichero
=---------------------------------

Para suprimir una clave del fichero de claves pblicas:

     pgp -kr identificador [fichero]

Este proceso busca en el fichero el identificador indicado, y lo suprime 
si encuentra una coincidencia. Recuerde que cualquier fragmento del 
identificador basta para que haya esa coincidencia. Se asume que 
"pubring.pgp" es literalmente ese nombre opcional del fichero. Puede 
omitirlo, o puede indicar "secring.pgp" si quiere suprimir una clave 
secreta. Puede dar tambin un nombre distinto para el fichero de claves. 
La extensin por omisin es ".pgp".

Si hay ms de un identificador de usuario para esa clave, se le 
preguntar si slo quiere eliminar el identificador indicado, dejando la 
clave y los otros identificadores intactos.


Extraccin (copia) de una clave del fichero
=-----------------------------------------

Para extraer (copiar) una clave del fichero de claves pblicas o 
secretas:

     pgp -kx identificador fdclaves [fichero]

Este proceso copia (sin borrar) la clave especificada por el 
identificador desde el fichero al fichero indicado. Resulta 
especialmente til para dar a alguien una copia de su clave pblica.

Si la clave tiene alguna firma de certificacin, tambin se copia.

Si quiere que la clave extrada se represente en caracteres ASCII 
imprimibles, para correo-E, ponga las opciones -kxa.


Visualizacin del contenido del fichero
=--------------------------------------

Para ver el contenido del fichero de claves pblicas:

     pgp -kv[v] [identificador] [fichero]

Muestra la lista con aquellas claves del fichero que coinciden con la 
subcadena especificada como identificador. Si omite el identificador, se 
muestran todas las claves. Se asume que "pubring.pgp" es ese nombre 
opcional de fichero. Puede omitirlo, o indicar "secring.pgp" si quiere 
ver la lista de claves secretas. Tambin puede, si lo desea, especificar 
otro nombre distinto para el fichero de claves. La extensin por omisin 
es ".pgp".

Para ver las firmas de certificacin de cada clave, utilice la opcin 
- -kvv:

     pgp -kvv [identificador] [fichero]

Si quiere especificar un nombre concreto de fichero, viendo todas las 
claves en l, pruebe esta forma alternativa:

     pgp fdclaves

Sin indicar ninguna opcin, PGP muestra la lista de todas las claves en 
fdclaves.pgp, intentando adems aadirlas al fichero de claves si no 
estuviesen.


Cmo proteger las claves pblicas contra manipulacin
=----------------------------------------------------

En un sistema de clave pblica no hay que proteger las claves pblicas 
contra exposicin. De hecho, es mejor que estn ampliamente difundidas. 
Sin embargo, es importante protegerlas contra manipulacin, para 
asegurar que una clave pertenece realmente a quien parece pertenecer. 
Este quiz sea el punto ms vulnerable de un criptosistema de clave 
pblica. Veamos primero un posible desastre, y despus cmo evitarlo con 
PGP.

Supongamos que usted quiere enviar a Alice un mensaje privado. Recibe 
la clave pblica de Alice desde una BBS (Bulletin Board System: tabln 
electrnico de anuncios). Encripta la carta para Alice con esa clave, y 
se la enva por medio del correo-E de la BBS.

Desafortunadamente, sin saberlo Alice ni usted, otro usuario llamado 
Charlie se ha infiltrado en la BBS, y ha generado una clave pblica 
propia que lleva el identificador de usuario de Alicia. Pone 
secretamente esa clave falsa en lugar de la verdadera. Usted, sin 
saberlo, utiliza esa clave en lugar de la autntica. Todo parece normal, 
porque la clave falsa tiene el identificador de usuario de Alice. 
Entonces, Charlie puede descifrar el mensaje dirigido a Alice, porque 
tiene la clave secreta correspondiente. Puede incluso volver a encriptar 
el mensaje con la verdadera clave pblica de Alice, y envirselo a ella 
para que nadie sospeche nada. An ms, puede incluso hacer firmas en 
nombre de Alice con esa clave secreta, porque todo el mundo utiliza la 
clave pblica falsa para comprobar las firmas de Alice.

La nica forma de evitar este desastre es impedir que alguien pueda 
manipular las claves pblicas. Si la clave pblica de Alice se ha 
obtenido directamente de ella, no hay problema. Sin embargo, esto puede 
resultar difcil si la persona se encuentra a mil kilmetros, o no es 
localizable en ese momento.

Podra conseguir la clave pblica de Alice de un amigo en el que confen 
ambos, David, que sabe que su copia de la clave pblica de Alice es 
buena. David podra firmar la clave pblica de Alice, respondiendo de la 
integridad de la clave. David realizara esta firma con su propia clave 
secreta.

De esta forma se creara un certificado firmado de clave pblica, que 
demostrara que la clave de Alice no ha sido manipulada. Este mecanismo 
requiere que usted tenga una copia buena de la clave pblica de David, 
para poder comprobar la firma. David podra tambin proporcionar a Alice 
una copia firmada de la clave pblica de usted. David hace, por tanto, 
de referencia entre usted y Alice.

David o Alice podran enviar a la BBS ese certificado firmado de clave 
pblica de parte de Alice, y usted podra recibirlo ms adelante. 
Entonces podra comprobar la firma con la clave pblica de David, y 
asegurarse de que es la verdadera clave de Alice. Ningn impostor podra 
hacer que aceptase una clave falsa como si fuera de Alice, porque nadie 
puede falsificar la firma de David.

Una persona de amplia confianza podra incluso especializarse en ofrecer 
este servicio de "referencia" entre usuarios, proporcionando firmas para 
esos certificados de clave pblica. Esta persona de confianza podra 
considerarse un "organizador de claves", o "autoridad de certificacin". 
Podra confiarse en que cualquier certificado de clave pblica con la 
firma del organizador pertenecera verdaderamente a quien pareca 
pertenecer. Los usuarios que quisieran participar slo necesitaran una 
copia buena de la clave pblica del organizador para poder verificar sus 
firmas.

Un organizador centralizado de claves, o autoridad de certificacin, 
est especialmente indicado en grandes instituciones gubernativas o 
empresariales con control centralizado. Algunos entornos institucionales 
ya utilizan jerarquas de autoridades de certificacin.

Para entornos de base ms descentralizados, estilo "guerrilla", 
probablemente funcionar mejor que un organizador centralizado el 
permitir a cualquier usuario actuar como referencia de confianza de sus 
amigos. PGP tiende a enfatizar este enfoque orgnico descentralizado, no 
institucional. Refleja mejor la forma natural que tienen los humanos de 
interaccionar personalmente a nivel social, y permite a la gente elegir 
mejor en quin confiar para la gestin de claves.

Todo este tema de proteger las claves pblicas contra manipulacin es el 
problema individual ms difcil con que se encuentra la aplicacin 
prctica de la clave pblica. Es el "taln de Aquiles" de la 
criptografa de clave pblica, y solamente en resolver este problema hay 
invertida una gran complejidad de programacin.

Slo debera utilizar una clave pblica despus de comprobar que es una 
clave autntica no manipulada, y que pertenece a la persona a la que 
dice pertenecer. Puede estar seguro de ello si obtiene el certificado de 
clave pblica directamente de su propietario, o si lleva la firma de 
alguien en quien confa, y del que ya se tiene una clave pblica 
autntica. Por otra parte, el identificador de usuario debera llevar el 
nombre completo del propietario, no slo su nombre de pila.

Por mucho que tenga la tentacin-- y la tendr--, nunca, NUNCA, ceda a 
la comodidad y se fe de una clave pblica que haya recibido de una BBS, 
a menos que vaya firmada por alguien en quien usted confa. Esa clave 
pblica sin certificar puede haber sido manipulada por cualquiera, quiz 
incluso el mismo administrador de la BBS.

Si le piden que firme el certificado de la clave pblica de alguien, 
compruebe que realmente pertenece a la persona mencionada en el 
identificador de usuario. Su firma en ese certificado de clave pblica 
es una promesa que usted hace de que la clave pertenece realmente a esa 
persona. La gente que confe en usted aceptar esa clave pblica porque 
lleva su firma. No es recomendable fiarse de rumores-- no firme la clave 
a menos que tenga conocimiento independiente y de primera mano de que 
realmente pertenece a esa persona. Preferiblemente, solamente debera 
firmarla si la ha recibido directamente de ella.

Debe estar mucho ms seguro de quin es el propietario de una clave 
pblica para firmarla que para encriptar un mensaje. Para estar lo 
bastante convencido de la validez de una firma como para utilizarla, 
deberan valer las firmas de certificacin de las referencias de 
confianza. Sin embargo, para firmar una clave usted mismo, debe tener 
conocimiento independiente y de primera mano de quin es el propietario 
de esa clave. Podra llamar al propietario por telfono y leerle el 
fichero de clave, para que confirme que la clave es verdaderamente 
suya-- compruebe que est hablando con la persona indicada. Consulte la 
seccin llamada "Verificacin de una clave pblica por telfono" en el 
volumen de Temas especiales para obtener ms informacin.

Tenga en cuenta que la firma en un certificado de clave pblica no 
responde de la integridad de esa persona, solamente de la integridad (la 
pertenencia) de la clave pblica de esa persona. Usted no arriesga su 
propia credibilidad firmando la clave pblica de un socipata, siempre 
que est completamente seguro de que la clave le pertenece a l. Otra 
gente aceptar que le pertenece porque usted la ha firmado (asumiendo 
que confen en usted), pero no se fiarn del propietario de esa clave. 
Confiar en una clave no es lo mismo que confiar en su propietario.

La confianza no es necesariamente transferible; tengo un amigo del que 
s que no miente. Es un crdulo que cree que el presidente no miente. 
Eso no quiere decir que yo crea que el presidente no miente. Es slo 
sentido comn. Si me fo de la firma de Alicia en una clave, y Alicia se 
fa de la firma de Charlie, eso no implica que yo me tenga que fiar de 
la firma de Charlie.

Resulta conveniente mantener su propia clave pblica a mano, con una 
coleccin de firmas de certificacin de diversas "referencias", para que 
la mayora de la gente confe al menos en una de las que responden de la 
validez de su clave. Puede enviar la clave con su coleccin de firmas de 
certificacin a varias BBSs. Si firma la clave pblica de alguien, 
devulvasela con la firma, para que pueda aadirla a la coleccin de 
credenciales de su clave.

PGP controla qu claves del fichero de claves pblicas han sido 
certificadas adecuadamente con firmas de referencias en las que usted 
confa. Todo lo que tiene que hacer es decir a PGP en qu personas 
confa como referencias, y certificar esas claves con la suya propia, 
que es fundamentalmente fiable. PGP puede continuar desde ah, validando 
cualquier clave firmada por esas referencias designadas. Adems, por 
supuesto, puede firmar ms claves usted mismo. Seguiremos con esto ms 
adelante.

Asegrese de que nadie pueda manipular su fichero de claves pblicas. La 
comprobacin de cualquier nuevo certificado firmado de clave pblica 
depende en ltima instancia de la integridad de las claves de confianza 
que ya hay en el fichero de claves. Mantenga control fsico sobre el 
fichero de claves pblicas, preferiblemente en su propio ordenador 
personal, en lugar de hacerlo en un sistema remoto multiusuario, como lo 
hara con su clave secreta. El objetivo es protegerlo contra 
manipulacin, no contra exposicin. Conserve una copia de seguridad 
fiable de los ficheros de claves pblicas y secretas en un material 
protegido contra escritura. 

Como su propia clave es la mxima autoridad para certificar directa o 
indirectamente las claves de su fichero, es la que ms tiene que 
proteger contra manipulacin. Para detectar cualquier manipulacin de su 
propia clave pblica, fundamentalmente fiable, PGP puede configurarse 
para que la compare automticamente con una copia de seguridad en 
material protegido contra escritura. Para obtener ms informacin, 
consulte la descripcin de la orden "-kc" de comprobacin de ficheros en 
el volumen sobre Temas especiales.

PGP generalmente asume que usted va a mantener seguridad fsica sobre el 
sistema y los ficheros de claves, y sobre la copia misma de PGP. Si un 
intruso pudiese manipular su disco, entonces podra en teora manipular 
el mismo PGP, dejando en entredicho cualquier sistema de seguridad que 
pueda tener PGP para detectar la manipulacin de claves.

Una forma algo complicada de proteger el fichero completo de claves 
pblicas contra manipulacin es firmarlo con su propia clave secreta. 
Puede hacerlo elaborando un certificado separado de firma para el 
fichero, con las opciones "-sb" (vase la seccin llamada "Separacin de 
firmas de los mensajes" en la Gua del usuario de PGP, volumen de Temas 
especiales). Desafortunadamente, sigue siendo necesario mantener una 
copia aparte de su propia clave pblica, para comprobar la firma que ha 
hecho. No puede fiarse para comprobar la firma de la clave almacenada en 
el fichero de claves pblicas, ya que es precisamente parte de lo que 
intenta comprobar.


Cmo controla PGP la validez de las claves?
=-------------------------------------------

Antes de empezar esta seccin, lea la anterior sobre "Cmo proteger las 
claves pblicas contra manipulacin".

PGP controla qu claves en el fichero de claves pblicas han sido 
certificadas adecuadamente con firmas de referencias de confianza. Todo 
lo que tiene que hacer usted es decir a PGP en qu personas confa como 
referencia, y certificar esas claves con la suya propia, que es 
fundamentalmente fiable. PGP puede continuar desde ah, validando 
cualquier otra clave que haya sido firmada por esas referencias 
elegidas. Por supuesto, usted mismo puede firmar ms claves.

Hay dos criterios completamente distintos por los que PGP juzga la 
utilidad de una clave pblica-- no los confunda:

  1) Pertenece la clave realmente a quien parece pertenecer?
     En otras palabras, ha sido certificada con una firma de confianza?
  2) Pertenece a alguien en quien podemos confiar para certificar otras
     claves?

PGP puede calcular la respuesta a la primera pregunta. Para responder a 
la segunda, usted, el usuario, debe informar a PGP explcitamente. 
Cuando se da la respuesta a la pregunta 2, PGP puede calcular la 
respuesta a la pregunta 1 para otras claves que hayan sido firmadas por 
esa referencia designada como fiable.

Las claves que han sido certificadas por una referencia de confianza ya 
se consideran vlidas en PGP. Las claves de esas referencias deben estar 
certificadas por usted u otra referencia de confianza.

PGP tambin permite tener distintos mrgenes de confianza para las 
personas que van a actuar como referencia. La confianza en el 
propietario de una clave para servir de referencia no refleja 
simplemente la estimacin de su integridad personal-- tambin debera 
reflejar cul cree usted que es su nivel de comprensin de la gestin de 
claves, y de su buen juicio en la firma de estas. Puede usted designar 
una persona en PGP como desconocida, no fiable, de relativa confianza, o 
de completa confianza para certificar otras claves pblicas. Esta 
informacin se almacena en el fichero junto con la clave de esa persona, 
pero, al indicar a PGP que copie una clave, no se incluye con ella, ya 
que esas opiniones privadas sobre confianza se consideran 
confidenciales.

Cuando PGP est calculando la validez de una clave pblica, examina el 
nivel de confianza de todas las firmas incluidas. Elabora una puntuacin 
proporcional de validez-- dos firmas relativamente fiables se consideran 
tan crebles como una completamente fiable. El escepticismo de PGP es 
ajustable-- por ejemplo, puede establecerse que hagan falta dos firmas 
completamente fiables, o tres relativamente fiables, para dar una clave 
por vlida.

Su propia clave es "axiomticamente" vlida para PGP, y no necesita 
ninguna firma de referencia para probar su validez. PGP sabe qu claves 
pblicas son de usted buscando las claves secretas correspondientes en 
el otro fichero. PGP tambin asume que usted confa completamente en s 
mismo para certificar otras claves.

Segn pase el tiempo, ir acumulando claves de otras personas, a las que 
puede designar como referencias de confianza. Cada uno ir eligiendo sus 
propias referencias. Y cada uno ir gradualmente acumulando y 
distribuyendo con su clave una coleccin de firmas de certificacin, 
esperando as que cualquiera que la reciba confe al menos en una o dos 
de ellas. Se producir as la aparicin de una red descentralizada de 
confianza para las claves pblicas, resistente a fallos.

Este enfoque de base, nico, contrasta claramente con los esquemas 
habituales del Gobierno para gestionar claves pblicas, como el Internet 
Privacy Enhanced Mail (PEM) {Correo mejorado en intimidad para 
Internet}, que se fundamentan en un control centralizado y una confianza 
centralizada y obligatoria. Los esquemas habituales confan en una 
jerarqua de Autoridades de certificacin que dictan en quin debe usted 
confiar. El mtodo probabilstico y descentralizado de PGP para 
determinar la legitimidad de las claves pblicas es la piedra angular de 
su arquitectura de gestin de claves. PGP le permite que elija usted 
mismo en quin confiar, y le pone en el vrtice de su propia pirmide 
personal de certificacin. PGP es para personas que prefieren preparar 
sus propios paracadas.


Cmo proteger las claves secretas contra revelacin
=--------------------------------------------------

Proteja con cuidado su propia clave y su frase de contrasea. Con mucho, 
mucho cuidado. Si su clave secreta se ve alguna vez comprometida, es 
mejor que corra la voz rpidamente y se lo diga a todas las partes 
interesadas (buena suerte...) antes de que alguien la utilice para hacer 
firmas en su nombre. Por ejemplo, podran firmar certificados falsos de 
clave pblica, lo que podra causar problemas a muchas personas, 
especialmente si su firma tiene amplio reconocimiento. Por supuesto, el 
compromiso de su propia clave secreta podra poner al descubierto todos 
los mensajes dirigidos a usted.

Para proteger su clave secreta, puede empezar por mantener siempre 
control fsico sobre ella. Es suficiente con tenerla en el ordenador 
personal en casa, o en un porttil que pueda llevar con usted. Si tiene 
que utilizar un ordenador de la oficina, sobre el que no siempre tiene 
control fsico, lleve sus ficheros de claves pblicas y secretas en un 
disco extrable, y nunca se lo deje. No es conveniente permitir que la 
clave secreta se encuentre en un ordenador remoto multiusuario, como por 
ejemplo un sistema Unix con acceso telefnico. Alguien podra fisgonear 
en la lnea del modem y conseguir la frase de contrasea, y despus 
conseguir la clave secreta del sistema. Slo debera utilizar la clave 
secreta en una mquina sobre la que tenga control fsico.

No guarde su contrasea dentro del mismo ordenador que tiene el fichero 
con las claves secretas. Guardar la clave secreta y la contrasea en el 
mismo ordenador es tan peligroso como guardar su nmero secreto en la 
misma cartera que la tarjeta del cajero automtico. Usted no querr que 
alguien ponga sus manos en el disco que contiene la frase de contrasea 
y el fichero de claves secretas. Sera ms seguro que memorizase la 
frase, y que no la guardase en ningn sitio excepto en su cerebro. Si 
cree que debe escribirla, mantngala protegida, quiz incluso mejor que 
el fichero de las claves secretas.

Mantenga copias de seguridad del fichero de claves secretas-- recuerde, 
usted tiene la nica copia de su clave secreta, y perderla inutilizara 
todas las copias de su clave pblica que haya por el mundo.

El enfoque descentralizado y no institucional que utiliza PGP para 
gestionar las claves pblicas tiene sus ventajas, pero, 
desafortunadamente, tambin implica que no se puede confiar en una lista 
nica de las claves comprometidas. Por lo tanto, resulta ms difcil 
controlar el dao que puede causar el compromiso de una clave. Slo 
puede divulgar la noticia y confiar en que todo el mundo se entere.

Si ocurre lo peor-- tanto su clave secreta como la frase de contrasea 
se ven comprometidos (esperemos que llegue a enterarse por algn medio) 
- --, tendr que emitir un certificado de "compromiso de clave". Este tipo 
de certificado se utiliza para advertir a los dems de que dejen de 
utilizar su clave pblica. Puede hacer que PGP elabore ese certificado 
mediante la orden "-kd". Despus tiene que enviarlo al resto de los 
habitantes del planeta, o al menos a todos sus amigos y los amigos de 
sus amigos, etctera. Sus propios programas PGP instalarn ese 
certificado de compromiso en sus ficheros de claves pblicas, y evitar 
que utilicen la clave por error. Puede entonces generar un nuevo par de 
claves secreta/pblica, y distribuir la nueva clave pblica. Puede 
enviar en un solo lote la nueva clave con el certificado de compromiso 
de la antigua.


Revocacin de una clave pblica
=------------------------------

Suponga que, por algn motivo, tanto su clave secreta como su contrasea 
se ven comprometidas. Tendr que decrselo al resto del mundo, para que 
dejen de utilizar su clave pblica. Para ello, tiene que emitir un 
certificado de "compromiso de clave" y revocar la clave pblica.

Para generar ese certificado, utilice la orden -kd:

     pgp -kd su_identificador

Este certificado lleva su firma, hecha con la misma clave que est 
revocando. Debera distribuirlo ampliamente cuanto antes. Las personas 
que lo reciban podrn aadirlo a sus ficheros de claves pblicas, y sus 
programas PGP evitarn automticamente que vuelvan a utilizar la clave 
antigua por error. Puede generar un nuevo par de claves secreta/pblica, 
y publicar la nueva clave pblica.

Puede tambin querer revocar la clave por algn otro motivo. Se emplea 
el mismo mecanismo.


Qu pasa si pierde la clave secreta?
- -------------------------------------

Normalmente, si quiere revocar la clave secreta puede utilizar la orden 
"-kd" para emitir un certificado de revocacin, firmado con su propia 
clave secreta (vase "Revocacin de una clave pblica").

Pero qu puede hacer si pierde la clave secreta, o si se destruye?  No 
puede revocarla usted mismo, porque debe utilizar la clave secreta para 
hacerlo, y ya no la tiene. Una versin posterior de PGP ofrecer una 
forma ms segura de revocar clave bajo esas circunstancias, permitiendo 
que referencias de confianza certifiquen que una clave pblica ha sido 
revocada. Por ahora, tendr que correr la voz por los medios informales 
que pueda, pidiendo a los usuarios que "desactiven" la clave pblica en 
sus ficheros.

Otros usuarios pueden desactivar la clave pblica en sus propios 
ficheros con la orden "-kd". Si se indica un identificador que no 
corresponde a una clave secreta del fichero correspondiente, la orden 
- -kd lo busca en el fichero de claves pblicas, y marca esa clave como 
desactivada. Una clave desactivada no puede utilizarse para encriptar 
mensajes, no se puede extraer del fichero con la orden -kx. Puede 
utilizarse para comprobar firmas, pero se muestra una advertencia. 
Adems, si el usuario intenta aadir otra vez la misma clave al fichero, 
no podr, ya que la clave desactivada ya se encuentra en l. Estas 
caractersticas combinadas ayudarn a atajar la difusin de una clave 
desactivada.

Si la clave pblica indicada ya est desactivada, la orden -kd le pedir 
si quiere volver a activarla.



Temas avanzados
===============

La mayora de los "Temas avanzados" se recogen en la "Gua del Usuario 
de PGP, Volumen II: Temas especiales". Sin embargo, hay algunos que 
merecen mencionarse aqu.


Envo de texto cifrado por canales de correo-E: formato Radix-64
=---------------------------------------------------------------

Muchos sistemas de correo electrnico slo permiten utilizar mensajes en 
texto ASCII, no con esos datos bsicos binarios de 8 bits que forman el 
texto cifrado. Para solucionar este problema, PGP admite el formato 
ASCII radix-64 para mensajes de texto cifrado, parecido al formato 
Privacy-Enhanced Mail (PEM). Este formato especial representa los datos 
binarios slo con caracteres ASCII imprimibles, por lo que sirve para 
transmitir datos binarios por canales de 7 bits, y para enviar datos 
cifrados como texto normal de correo-E. Este formato hace de "armadura 
de transporte", protegiendo el mensaje mientras viaja por distintas 
pasarelas entre sistemas dentro de Internet. Tambin aade un CRC para 
detectar errores de transmisin.

El formato Radix-64 convierte el texto cifrado expandiendo grupos de 3 
bytes binarios de 8 bits en 4 caracteres ASCII imprimibles, por lo que 
el fichero crece un 33%. Esta expansin no es tan grave cuando se 
considera que PGP probablemente ya haba comprimido el fichero ms que 
eso antes de encriptarlo.

Para producir un fichero cifrado en formato ASCII radix-64, aada la 
opcin "a" cuando encripte o firme un mensaje, de la siguiente manera:

     pgp -esa mensaje.txt identificador_des

Este ejemplo producir un fichero cifrado llamado "mensaje.asc", con los 
datos en un formato ASCII radix-64 parecido al de PEM. Puede cargarse 
entonces en un editor de textos por canales de 7 bits para transmitirlo 
como correo-E normal por Internet o cualquier otra red. 

La desencriptacin del mensaje con armadura de transporte radix-64 es 
idntica a cualquier desencriptacin normal. Por ejemplo:

     pgp mensaje

PGP busca automticamente el fichero ASCII "mensaje.asc" antes de buscar 
el binario "mensaje.pgp". Reconoce que el fichero est en formato 
radix-64, y lo convierte en binario antes de procesarlo normalmente, 
creando el fichero ".pgp" como producto secundario. El fichero final de 
salida ser de texto normal, precisamente como era el "mensaje.txt" 
original.

La mayora de los servicios de correo-E de Internet no permite enviar 
mensajes de ms de 50.000 bytes. Los ms largos deben dividirse en 
partes, para enviarlas por separado. Si el mensaje cifrado es muy 
grande, y se pide el formato radix-64, PGP lo divide automticamente en 
partes ms pequeas para poder enviarlas por correo-E. Las partes se 
convierten en ficheros con extensiones ".as1", ".as2", ".as3", etc. El 
destinatario debe concatenar por orden estos ficheros en un solo fichero 
grande antes de desencriptar. Durante este proceso, PGP ignora cualquier 
texto extrao en las cabeceras del correo, fuera de los bloques radix-64 
del mensaje.

Si quiere enviar una clave pblica a alguien en formato radix-64, aada 
la opcin -a al extraer la clave del fichero.

Si ha olvidado indicar la opcin -a cuando al crear un fichero cifrado o 
al extraer una clave, puede convertir el binario al formato radix-64 
poniendo solamente la opcin -a, sin encriptar. PGP lo convertir en un 
fichero ".asc".

Si quiere enviar por correo-E un fichero en texto normal firmado pero no 
cifrado, PGP lo convertir normalmente en una armadura radix-64, 
hacindolo ilegible para el observador humano habitual. Si el mensaje 
original en texto normal no es binario, hay una forma de enviarlo por 
correo-E de manera que la armadura se aplique slo al certificado de 
firma y no al mensaje. As el destinatario podr leer el mensaje firmado 
con sus propios ojos, sin ayuda de PGP. Por supuesto, PGP har falta 
para comprobar la firma. Para obtener ms informacin sobre esta 
caracterstica, consulte la explicacin del parmetro CLEARSIG en la 
seccin "Establecimiento de parmetros de configuracin: CONFIG.TXT" en 
el volumen de Temas especiales.


Variable de entorno para la trayectoria
=--------------------------------------

PGP utiliza varios ficheros especiales, tales como los ficheros de 
claves "pubring.pgp" y "secring.pgp", el fichero "ranseed.bin" de 
semilla para nmeros aleatorios, el fichero "config.txt" de 
configuracin y el fichero "language.txt" de traducciones a otros 
idiomas. Estos ficheros especiales pueden colocarse en cualquier 
directorio, siempre que se establezca la variable de entorno "PGPPATH" 
con la trayectoria. Por ejemplo, en MSDOS, la orden:

     SET PGPPATH=C:\PGP

hara que PGP asumiese que el nombre del fichero de claves pblicas es 
"C:\PGP\pubring.pgp"... contando, desde luego, con que ese directorio 
exista. Utilice su editor de textos favorito para modificar el fichero 
AUTOEXEC.BAT, de forma que establezca esta variable al arrancar el 
sistema. Si PGPPATH no se ha definido, se asume que esos ficheros 
especiales estn en el directorio actual.


Establecimiento de los parmetros de configuracin: CONFIG.TXT
=-------------------------------------------------------------

PGP tiene ciertos parmetros que pueden definirse en un fichero especial 
de configuracin llamado "config.txt" (de texto), que se encuentra en el 
directorio apuntado por la variable de entorno PGPPATH. La existencia de 
un fichero de configuracin permite definir diversas banderas y 
parmetros de PGP, y evita la molestia de tener que indicarlas cada vez 
en la lnea de rdenes.

Con estos parmetros de configuracin puede, por ejemplo, controlarse 
dnde va a almacenar PGP sus ficheros temporales, puede elegirse el 
idioma en el que PGP muestra los mensajes de diagnstico y los 
indicadores, y puede ajustarse el nivel de escepticismo de PGP para 
determinar la validez de una clave segn el nmero de firmas que la 
certifiquen.

Para obtener ms informacin sobre cmo establecer estos parmetros de 
configuracin, consulte la seccin correspondiente de la Gua del 
Usuario de PGP, volumen de Temas especiales.


Puntos vulnerables
=-----------------

Ningn sistema de seguridad de datos es impenetrable. PGP puede burlarse 
de diversas maneras. Los posibles puntos vulnerables que hay que tener 
en cuenta son, entre otros, el compromiso de la contrasea o de la clave 
secreta, la manipulacin de las claves pblicas, los ficheros que se han 
borrado pero que siguen todava en el disco, los virus y caballos de 
Troya, los fallos en la seguridad fsica, las emisiones 
electromagnticas, la exposicin en sistemas multiusuario, el anlisis 
de trfico, y quiz incluso el criptoanlisis directo.

Para encontrar un anlisis ms detallado de estos temas, consulte la 
seccin "Puntos vulnerables" en la Gua del Usuario de PGP, volumen de 
Temas especiales.


Cuidado con los elixires mgicos
================================

Al examinar un programa criptogrfico, uno siempre se pregunta por qu 
debera fiarme de este producto? Incluso si ha estudiado el cdigo 
fuente usted mismo, no todo el mundo tiene la experiencia necesaria en 
criptografa para juzgar esa seguridad. Hasta siendo un criptgrafo 
experimentado pueden escaparse debilidades sutiles en los algoritmos.

Cuando estaba en la universidad a principios de los aos setenta, dise 
lo que crea un excelente esquema de cifrado. Una sencilla corriente de 
nmeros pseudoaleatorios se sumaba a la corriente de texto normal para 
crear el texto cifrado. As pareca frustrarse cualquier anlisis de 
frecuencia del texto cifrado, resultando imposible de romper incluso 
para los servicios de informacin con mayores recursos. Me senta muy 
orgulloso de m mismo por la proeza. Muy presuntuoso.

Aos despus, descubr ese mismo esquema en varios textos introductorios 
y otros artculos sobre criptografa. Qu bien. Otros criptgrafos 
haban pensado el mismo esquema. Desafortunadamente, se presentaba como 
un sencillo ejercicio sobre cmo emplear tcnicas criptoanalticas 
elementales para romperlo de forma trivial. Nada ms que decir sobre mi 
excelente esquema.

De esta humillante experiencia aprend qu fcil es caer en un falso 
sentimiento de seguridad cuando se disea un algoritmo de cifrado. La 
mayora de la gente no se da cuenta de lo diablicamente difcil que 
resulta disear un algoritmo que pueda soportar un ataque prolongado y 
porfiado por parte de un oponente con recursos. Muchos ingenieros de 
programacin sin especializar han desarrollado esquemas igualmente 
ingenuos (a menudo exactamente el mismo), y algunos de ellos lo han 
incorporado en programas comerciales de cifrado, vendidos por una buena 
cantidad de dinero a miles de usuarios confiados.

Es algo parecido a vender cinturones de seguridad que tienen buen 
aspecto y parecen buenos, pero que saltan incluso en la prueba de choque 
ms lenta. Dependiendo del caso, pueden resultar incluso peor que no 
llevar ningn cinturn de seguridad en absoluto. Nadie sospecha que son 
malos hasta que hay un choque real. Depender de programas criptogrficos 
dbiles puede hacer que usted ponga en peligro informacin confidencial 
sin saberlo. Podra no haber llegado a ocurrir nunca si no hubiese 
tenido ningn programa criptogrfico. Quiz usted nunca llegue a 
descubrir que esos datos se han visto comprometidos.

Algunas veces, los programas comerciales utilizan el Federal Data 
Encryption Standard (DES) {Estndar Federal de Encriptacin de Datos}, 
un buen algoritmo convencional recomendado por el gobierno para uso 
comercial (pero no para informacin clasificada, extraamente-- ejem). 
DES puede utilizar varios "modos de funcionamiento", unos mejores que 
otros. El Gobierno recomienda especficamente no utilizar para los 
mensajes el modo ms simple y dbil, Electronic Codebook (ECB) {Libro 
electrnico de cdigos}. Pero s recomienda los modos ms complejos y 
resistentes, Cipher Feedback (CFB) {Retroalimentacin de cifrado} y 
Cipher Block Chaining (CBC) {Encadenamiento de bloques de cifrado}.

Desafortunadamente, la mayora de los programas comerciales de 
encriptacin que he visto utiliza el modo ECB. Cuando he hablado con los 
autores de algunas de esas implementaciones, me han dicho que no haban 
odo nunca hablar de los modos CBC o CFB, y que no saban nada de las 
debilidades del modo ECB. El solo hecho de que no hayan aprendido 
suficiente criptografa para conocer esos conceptos elementales no es 
precisamente tranquilizador. Estos mismos programas incluyen a menudo un 
segundo algoritmo exclusivo, ms rpido, que puede utilizarse en lugar 
del DES, que es ms lento. El autor del programa suele pensar que su 
propio algoritmo, ms rpido, es tan seguro como DES, pero despus de 
preguntar suelo descubrir que es slo una variacin de mi propio gran 
esquema de los tiempos de universidad. Puede que ni siquiera est 
dispuesto a revelar cmo funciona ese esquema propio, pero me asegura 
que es excelente y que debera confiar en l. Estoy seguro de que cree 
que su algoritmo es excelente, pero cmo puedo saberlo sin verlo?

Para ser justo, debo sealar que en la mayora de los casos esos 
productos no eran de empresas especializadas en tecnologa 
criptogrfica.

Hay una empresa llamada AccessData (87 East 600 South, Orem, Utah 84058, 
telfono 1-800-658-5199, USA) que vende un programa por $185 que rompe 
los esquemas de cifrado incorporados en WordPerfect, Lotus 1-2-3, MS 
Excel, Symphony, Quattro Pro, Paradox y MS Word 2.0. No slo adivina 
contraseas-- hace verdadero criptoanlisis. Algunas personas lo compran 
cuando olvidan la contrasea de sus propios ficheros. Las agencias de la 
ley tambin lo compran para poder leer los ficheros que interceptan. 
Habl con Eric Thompson, su autor; me dijo que el programa tarda una 
fraccin de segundo en romperlos, y que puso algunos bucles internos 
para retrasarlo y que a sus clientes no les pareciese que resultaba tan 
fcil. Tambin me dijo que el cifrado por contrasea de los ficheros 
PKZIP es fcil de romper, y que sus clientes oficiales a menudo 
solicitan ese servicio a otra empresa.

En cierta manera, la criptografa es como los productos farmacuticos. 
Su integridad puede ser absolutamente crucial. La mala penicilina tiene 
el mismo aspecto que la buena. Usted puede saber que su hoja de clculo 
se equivoca, pero cmo puede saber si su programa de criptografa es 
dbil? El texto cifrado que produce un algoritmo dbil tiene tan buen 
aspecto como el texto producido por un algoritmo resistente. Hay mucho 
elixir mgico por ah. Muchos remedios de curandero. Al contrario que 
los palmarios buhoneros de medicinas de antao, estos tcnicos de 
programacin ni siquiera suelen saber que su producto es un elixir 
mgico. Pueden ser buenos ingenieros de programacin, pero en general no 
han ledo ninguna publicacin acadmica sobre criptografa. Pero creen 
que pueden escribir buenos programas criptogrficos. Por qu no?  
Despus de todo, parece fcil a primera vista. Y su programa parece 
funcionar bien.

Cualquiera que crea que ha diseado un esquema de encriptacin 
invulnerable puede ser un genio muy poco comn, o un ingenuo y un 
inexperto.

Recuerdo una conversacin con Brian Snow, criptgrafo senior de alto 
nivel en la NSA {National Security Agency - Agencia Nacional de 
Seguridad}. Dijo que nunca se fiara de un algoritmo de cifrado diseado 
por alguien que no se hubiese "ganado sus galones" pasando mucho tiempo 
rompiendo cdigos. Tiene mucho sentido. Pude comprobar que prcticamente 
nadie en el mundo de la criptografa comercial estaba cualificado segn 
ese criterio. "S", dijo con una sonrisa de seguridad, "Eso hace nuestro 
trabajo en NSA mucho ms fcil". Un pensamiento escalofriante. Yo 
tampoco estoy cualificado.

El Gobierno tambin ha ido vendiendo elixires mgicos. Despus de la 
Segunda Guerra Mundial, los EEUU vendieron mquinas de cifrado Enigma 
alemanas a gobiernos del tercer mundo. Pero no les dijeron que los 
aliados haban roto el cdigo de Enigma durante la guerra, un hecho que 
permaneci clasificado durante muchos aos. Hasta hoy en da, muchos 
sistemas Unix en todo el mundo utilizan el cifrado Enigma para encriptar 
ficheros, en parte porque el Gobierno ha creado obstculos legales 
contra la utilizacin de algoritmos mejores. Incluso intent evitar la 
publicacin inicial del algoritmo RSA en 1977. Adems, ha machacado 
bsicamente todos los esfuerzos comerciales para desarrollar telfonos 
seguros y efectivos para el pblico en general.

El trabajo principal de la National Security Agency del Gobierno de los 
EEUU es recoger informacin, especialmente interviniendo encubiertamente 
las comunicaciones privadas de las personas (vase el libro de James 
Bamford "The Puzzle Palace"). La NSA ha acumulado una considerable 
cantidad de habilidad y de medios para romper cdigos. Si la gente no 
puede conseguir criptografa de calidad para protegerse, el trabajo de 
la NSA se vuelve mucho ms fcil. La NSA tambin tiene la 
responsabilidad de aprobar y recomendar algoritmos de cifrado. Algunos 
crticos alegan que eso constituye un conflicto de intereses, como poner 
a la zorra a cuidar las gallinas. La NSA ha estado promocionando un 
algoritmo de cifrado convencional diseado por ellos mismos, pero no 
dice a nadie cmo funciona porque eso es informacin clasificada. Quiere 
que los dems se fen y lo utilicen. Pero cualquier criptgrafo puede 
decirle que un algoritmo de cifrado bien diseado no tiene que 
permanecer clasificado para ser seguro. Slo las claves deberan 
necesitar proteccin. Cmo puede alguien saber realmente si el 
algoritmo clasificado de la NSA es seguro?  No resultara tan difcil 
para la NSA disear un algoritmo que slo ellos pudiesen romper, si 
nadie ms pudiese revisarlo. Estn vendiendo un elixir mgico 
deliberadamente?

No estoy tan seguro de la seguridad de PGP como lo estaba de mi 
excelente programa de la universidad. Si lo estuviese, sera mala seal. 
Sin embargo, estoy bastante seguro de que PGP no contiene ninguna 
debilidad manifiesta. Los criptoalgoritmos fueron desarrollados por 
personas de alto nivel en crculos acadmicos criptogrficos civiles, y 
han soportado revisin individualizada por parte de otros expertos. El 
cdigo fuente de PGP est disponible para facilitar ese tipo de 
revisin, y para ayudar a disipar los temores de algunos usuarios. Se ha 
investigado razonablemente bien, y ha llevado aos escribirlo. Adems, 
yo no trabajo para la NSA. Espero que no haga falta demasiada "fe" para 
confiar en la seguridad de PGP.



Referencia rpida para PGP
==========================

He aqu un rpido resumen de las rdenes de PGP.

Para encriptar un fichero normal con la clave pblica del destinatario:
     pgp -e fnormal identificador_des

Para firmar un fichero normal con su clave secreta:
     pgp -s fnormal [-u su_identificador]

Para firmar un fichero normal con su clave secreta y despus encriptarlo 
con la clave pblica del destinatario:
     pgp -es fnormal identificador_des [-u su_identificador]

Para encriptar un fichero normal slo con criptografa convencional, 
escriba:
     pgp -c fnormal

Para desencriptar un fichero, o comprobar la integridad de la firma en 
un fichero firmado:
     pgp fcifrado [-o fnormal]

Para encriptar un mensaje para cualquier nmero de mltiples 
destinatarios:
     pgp -e ftexto identificador1 identificador2 ...

- --- Funciones para la gestin de claves:

Para generar su propio par nico de claves pblica/secreta:
     pgp -kg

Para aadir el contenido de un fichero de claves pblicas o secretas 
al anillo correspondiente:
     pgp -ka fdclaves [anillo]

Para extraer (copiar) una clave del anillo de claves pblicas o 
secretas:
     pgp -kx identificador fdclaves [anillo]
o:   pgp -kxa identificador fdclaves [anillo]

Para ver el contenido del anillo de claves pblicas:
     pgp -kv[v] [identificador] [anillo]

Para ver la "huella dactilar" de una clave pblica, y poder 
verificarla por telfono con su dueo:
     pgp -kvc [identificador] [anillo]

Para ver el contenido y comprobar las firmas de certificacin en el 
anillo de claves pblicas:
     pgp -kc [identificador] [anillo]

Para modificar el identificador o la frase de contrasea de la clave 
secreta:
     pgp -ke identificador [anillo]

Para modificar los parmetros de confianza de una clave pblica:
     pgp -ke identificador [anillo]

Para suprimir una clave, o slo un identificador, del anillo de claves 
pblicas:
     pgp -kr identificador [anillo]

Para firmar la clave pblica de alguien en el anillo de claves pblicas:
     pgp -ks identificador_des [-u su_identificador] [anillo]

Para suprimir de un anillo ciertas firmas de un usuario:
     pgp -krs identificador [anillo]

Para revocar permanentemente su propia clave, emitiendo un certificado 
de compromiso de clave:
     pgp -kd su_identificador

Para desactivar o volver a activar una clave pblica en el anillo de 
claves pblicas:
     pgp -kd su_identificador


- --- Ordenes esotricas:

Para desencriptar un mensaje y dejar su firma intacta:
     pgp -d fcifrado

Para crear un certificado de firma separado del documento:
     pgp -sb fnormal [-u su_identificador]

Para separar un certificado de firma del mensaje firmado:
     pgp -b fcifrado

- --- Opciones que pueden utilizarse en combinacin con otras rdenes 
(formando a veces curiosas palabras):

Para producir un fichero cifrado en formato ASCII radix-64, aada 
simplemente la opcin -a cuando encripte o firme un mensaje, o 
cuando extraiga una clave:
     pgp -sea fnormal identificador_des
o:   pgp -kax identificador fdclave [anillo]

Para eliminar automticamente el fichero normal despus de crear el 
fichero cifrado, aada simplemente la opcin -w (wipe {limpiar}) cuando 
encripte o firme un mensaje:
     pgp -wes mensaje.txt identificador_des

Para indicar que un fichero normal contiene texto ASCII, no binario, y 
que debe ajustarse a los convenios de lnea del destinatario, aada la 
opcin -t (texto) a las otras:
     pgp -seta mensaje.txt identificador_des

Para ver el texto descifrado en la pantalla (como con la orden "more" 
{ms} de Unix), sin grabarlo en un fichero, utilice la opcin -m (more) 
al desencriptar:
     pgp -m fcifrado

Para indicar que el texto descifrado para el destinatario SOLO puede 
mostrarse en su pantalla de esta, sin grabarse en el disco, aada la 
opcin -m:
     pgp -metas mensaje.txt identificador_des

Para recuperar el nombre original del fichero normal al desencriptar, 
aada la opcin -p:
     pgp -p fcifrado

Para utilizar en modo filtro, como en Unix, leyendo de la entrada 
estndar y escribiendo en la salida estndar, aada la opcin -f:
     pgp -festa identificador_des <fentrada >fsalida



Consideraciones legales
=======================

Para mayor informacin sobre licencias, distribucin, copyrights, 
patentes, marcas registradas, limitaciones de responsabilidad y 
controles de exportacin de PGP, vase la seccin "Consideraciones 
legales" de la "Gua del usuario de PGP, volumen II: Temas especiales".

PGP utiliza un algoritmo de clave pblica reclamado por la patente de 
EEUU n 4.405.829. Los derechos exclusivos sobre esta patente estn en 
poder de una compaa de California llamada Public Key Partners, y usted 
puede estar infringiendo esta patente si utiliza PGP en EEUU. Todo esto 
se explica en el volumen II.

PGP es un programa libre, estilo "guerrilla", gratuito, y no me importa 
que se distribuya ampliamente. Simplemente, no me pida que le enve una 
copia. En lugar de eso, puede obtenerla usted mismo en muchas BBS y en 
algunos establecimientos FTP de Internet.


Agradecimientos
===============

Me gustara agradecer a las siguientes personas su contribucin a la 
creacin de Pretty Good Privacy ("intimidad bastante buena"). Aunque fui 
el autor de la versin 1.0 de PGP, grandes partes de las versiones 
siguientes se implementaron gracias a un esfuerzo de colaboracin 
internacional que incluye a un gran nmero de personas, bajo mi gua en 
el diseo.

Branko Lankester, Hal Finney y Peter Gutmann contribuyeron con una 
enorme cantidad de tiempo a aadir opciones para PGP 2.0, y lo adaptaron 
a diversas variaciones de Unix. Hal y Branko hicieron esfuerzos 
hercleos para implementar los nuevos protocolos de gestin de claves. 
Branko le ha dedicado ms tiempo que ningn otro a PGP.

Hugh Kennedy lo adapt al VAX/VMS, Lutz Frank al Atari ST, y Cor Bosman 
y Colin Plumb al Commodore Amiga.

La traduccin de PGP a otros idiomas ha sido realizada por Jean-loup 
Gailly en Francia, Armando Ramos en Espaa, Felipe Rodriquez Svensson y 
Branko Lankester en los Pases Bajos, Miguel Gallardo en Espaa (PGP 
1.0), Hugh Kennedy y Lutz Frank en Alemania, David Vincenzetti en 
Italia, Harry Bush y Maris Gabalins en Letonia, Zygimantas Cepaitis en 
Lituania, Peter Suchkow y Andrew Chernov en Rusia, y Alexander 
Smishlajev en Esperantujo. Peter Gutmann se ofreci para traducirlo al 
ingls de Nueva Zelanda, pero finalmente decidimos que PGP podra 
arreglrselas con el ingls de EEUU.

Jean-loup Gailly, Mark Adler y Richard B. Wales publicaron el cdigo 
para la compresin ZIP, y han dado permiso para incluirlo en PGP. Las 
rutinas MD5 fueron desarrolladas y puestas en el dominio pblico por Ron 
Rivest. El cifrado IDEA(mr) fue desarrollado por Xuejia Lai y James L. 
Massey en ETH, Zurich, y se utiliza en PGP con permiso de Ascom-Tech AG.

Charlie Merritt fue el primero en ensearme cmo hacer aritmtica 
decente de precisin mltiple para la criptografa de clave pblica, y 
Jimmy Upton contribuy con un algoritmo ms rpido de 
multiplicacin/mdulo. Thad Smith implement un algoritmo modmult an 
ms rpido. Zhahai Stewart contribuy con muchas ideas tiles sobre los 
formatos de fichero de PGP y otras cosas, incluyendo el tener ms de un 
identificador de usuario por clave. O de Whit Diffie la idea de tener 
referencias. Kelly Goen hizo la mayor parte del trabajo para la 
publicacin electrnica de PGP 1.0.

Ha habido diversas contribuciones de programacin por parte de Colin 
Plumb, Derek Atkins y Castor Fu. Otras contribuciones de esfuerzo, ya 
sean programando o de otra manera, han venido de Hugh Miller, Eric 
Hughes, Tim May, Stephan Neuhaus y muchos otros, demasiados para 
acordarme ahora mismo. Se han iniciado dos proyectos para transportar el 
programa a Macintosh, dirigidos por Zbigniew Fiedorwicz y Blair Weiss.

Desde el lanzamiento de PGP 2.0, muchos otros programadores han enviado 
modificaciones y correcciones de errores, as como ajustes para 
transportar a otros ordenadores. Son demasiados para darles las gracias 
individualmente en este momento.

El desarrollo de PGP se ha convertido en un fenmeno social notable, 
cuyo atractivo poltico nico ha inspirado el esfuerzo colectivo de un 
nmero creciente de programadores voluntarios. En ingls hay un cuento 
para nios llamado "Stone Soup" {Sopa de piedra}. Cada vez es ms 
difcil mirar a travs de la sopa para encontrar la piedra en el fondo 
de la olla, la que dej caer para empezar todo esto.


Acerca del autor
================

Philip Zimmermann es un asesor en ingeniera de programacin con 19 aos 
de experiencia, especializado en sistemas incorporados en tiempo real, 
criptografa, autenticacin y comunicaciones de datos. Su experiencia 
incluye el diseo y la implementacin de sistemas de autenticacin para 
redes de informacin financiera, seguridad en redes de datos, protocolos 
de gestin de claves, ejecutivos multitarea en tiempo real incorporados, 
sistemas operativos y redes de rea local.

Zimmermann tiene versiones a medida de productos de criptografa y 
autenticacin, e implementaciones de clave pblica como el NIST DSS, 
adems de servicios de desarrollo de productos a medida. La direccin de 
su asesora es:

Boulder Software Engineering
3021 Eleventh Street
Boulder, Colorado 80304  USA
Telfono 1-303-541-0140 (voz o FAX)  (10:00am - 7:00pm Mountain Time)
Internet:  prz@acm.org



-----BEGIN PGP SIGNATURE-----
Version: 2.3a

iQCVAgUBLRYHhnAkxuOrd59xAQGPVgQAyjjVmmGXFLzExRXMdw6inqPR4MtwL8zW
7EsGzL6SFnt35wW1i5wZDnvPWm2GC3JHuUzIWkAxmbzx2IIcwTEwYRAmzkA9QNn0
W/TbyLOs86a+n6XjbUkhwHP5u0UcvlOyA7aqQamsXUhJ8sU8TKgeSk48e1T5sGwh
QW51+8Hfgk0=
=1sDs
-----END PGP SIGNATURE-----
