/*
 *      A helper routine for MD5BC.C
 *
 * This file contains a routine which attempts to detect whether
 * the CPU is 386 or better.
 *
 * checkCPU        - function name
 * tcpu_CPUchecked - external int variable; 0 initially; 1 after checkCPU call
 * tcpu_CPU386     - external int variable; 0 initially; 1 if 386+ detected
 *
 * If an environment variable named MD5NO386 is defined (with any value),
 * then the CPU detection code is skipped, and it is assumed that 386
 * instructions are not supported (or should not be used for any other reason).
 *
 * Note: You can compile this with -DTESTCPU_TESTDRIVE
 *    to obtaine a test executable, which would detect (if not disabled
 *    via MD5NO386 environment variable) whether the CPU is 386 or better,
 *    and display appropriate message.
 * Comments: Please send to: <wpilorz@priam.umcs.lublin.pl>
 * Code status: public domain
 * Release date: 1996/10/18
 */


#include <stdlib.h>

#pragma inline

int tcpu_CPUchecked = 0;
int tcpu_CPU386 = 0;
char NO386ENV[] = "MD5NO386";  /* if environment variable with this name
                                  and any value is defined, 386 detection
                                                                                         is not attempted */

//-----( checkCPU )--------------------------------------------------------//
void checkCPU()
{
        if (getenv(NO386ENV))
                goto not386;

        asm {
                mov     ax,sp
                push    sp
                pop     bx
                cmp     bx,ax
                jnz     not386
                /* now it is 286 or better */
                mov     ax,7000h
                pushf
                push    ax
                popf
                cli  /* disable interrupts (even if previous popf would not do that) */
                pushf
                pop     ax
                popf
                and     ax,7000h
                jz              not386
        }
        tcpu_CPU386 = 1;
not386:
        tcpu_CPUchecked = 1;
}
//--------------------------------------------------------( checkCPU )-----//

#ifdef TESTCPU_TESTDRIVE

#include <stdio.h>

int main()
{
   checkCPU();
        printf("CPU checked=%s, 386+ detected=%s", tcpu_CPUchecked ? "Yes" : "No",
                                                                                                                        tcpu_CPU386     ? "Yes" : "No");
        return 0;
}

#endif
