/*
 * Diffie-Hellman key exchange parameters
 * SCCS ID: @(#)dhparams.c 1.5 96/04/04
 */

#include "global.h"
#include "rsaref.h"

static unsigned char dh_small_prime[] = {
    0xc1, 0x9d, 0x49, 0xf3, 0x4c, 0x5b, 0xb6, 0x20, 0x5b, 0x52, 0x9a,
    0xca, 0xaf, 0x79, 0x88, 0x84, 0xba, 0xe2, 0xd5, 0x64, 0xab, 0x72,
    0xba, 0xa4, 0x84, 0xce, 0x60, 0x28, 0x83, 0x38, 0x83, 0x20, 0xb7,
    0x06, 0x2f, 0xff, 0xda, 0xa5, 0xa8, 0x49, 0x59, 0x17, 0x41, 0xb4,
    0xad, 0xdd, 0xe7, 0xd3, 0x33, 0x29, 0x19, 0x52, 0xd9, 0x67, 0x19,
    0x89, 0x8e, 0x07, 0x92, 0x45, 0x3b, 0x15, 0x04, 0x25,
};				/* 512-bit prime */
static unsigned char dh_small_gen[] = {
    0x9a, 0x86, 0x33, 0xcc, 0xf4, 0xcb, 0xbd, 0xcf, 0xe2, 0x5d, 0xc2,
    0x5c, 0xea, 0x91, 0x7d, 0x43, 0xd5, 0x9d, 0x69, 0x36, 0x19, 0x47,
    0x5d, 0x83, 0x5b, 0x34, 0x46, 0x7e, 0x1e, 0x72, 0x25, 0x8f, 0xe3,
    0x0a, 0x1e, 0x03, 0xcc, 0x86, 0x7c, 0xff, 0x4b, 0x35, 0x2f, 0x1c,
    0x73, 0xef, 0xff, 0xa3, 0xd0, 0x75, 0xae, 0xfc, 0x20, 0xd4, 0x04,
    0x80, 0x48, 0xb0, 0xa9, 0xa7, 0x15, 0x65, 0x56, 0xb0,
};

static unsigned char dh_medium_prime[] = {
    0xb2, 0x56, 0x1d, 0xbd, 0x49, 0xbf, 0xfc, 0x26, 0xf9, 0x1f, 0xda,
    0xa9, 0x90, 0x07, 0x1c, 0x36, 0xdc, 0x7a, 0xc9, 0x75, 0x2d, 0x30,
    0x6f, 0x28, 0x32, 0x6d, 0xa3, 0x0b, 0x7d, 0xdc, 0x58, 0x8d, 0x1b,
    0xc1, 0x59, 0x79, 0xfa, 0x09, 0xd9, 0x76, 0x2b, 0xe6, 0x22, 0x78,
    0x11, 0x28, 0x36, 0x13, 0xc8, 0xa7, 0x59, 0xb0, 0x23, 0xca, 0xd8,
    0xe7, 0xff, 0x5c, 0x8d, 0x07, 0xc4, 0x11, 0xc8, 0xfd, 0x0b, 0x26,
    0x4c, 0x97, 0xe7, 0xc1, 0xf0, 0xd3, 0x2b, 0x18, 0xba, 0x56, 0xa1,
    0x46, 0xa2, 0xef, 0xa9, 0x30, 0x2c, 0xf4, 0x18, 0x10, 0x5e, 0xca,
    0xdf, 0x07, 0x82, 0x66, 0x51, 0xe2, 0x4a, 0xa3,
};				/* 768-bit prime */

static unsigned char dh_medium_gen[] = {
    0x67, 0xd1, 0xa3, 0x1b, 0x0f, 0x17, 0x7d, 0xc4, 0x25, 0xaf, 0xbc,
    0xcf, 0x42, 0x2a, 0x05, 0x3d, 0x56, 0x72, 0x36, 0xa8, 0xf4, 0xaf,
    0xd2, 0x0e, 0x56, 0xa4, 0x27, 0x17, 0x1e, 0x9a, 0x4c, 0x11, 0x19,
    0x7e, 0xf1, 0xa2, 0x2b, 0xe2, 0x57, 0xa1, 0x3d, 0xf7, 0x07, 0x2d,
    0x64, 0x8f, 0xa3, 0x83, 0xc8, 0x0f, 0xf1, 0x6e, 0x51, 0x19, 0x74,
    0xe1, 0x5b, 0x27, 0x4f, 0x5f, 0x2b, 0x40, 0xdd, 0x95, 0x91, 0xf3,
    0x4c, 0xe5, 0xe4, 0xa9, 0x56, 0x3b, 0xf4, 0xab, 0xd7, 0x5a, 0x3c,
    0x46, 0x61, 0x6b, 0xa5, 0x8e, 0x92, 0x28, 0x1b, 0xeb, 0xa8, 0x6d,
    0x75, 0xef, 0x22, 0xb2, 0x94, 0xd3, 0x4a, 0x97,
};				/* 750-bit generator */

static unsigned char dh_large_prime[] = { 
    0xc5, 0xbb, 0x4b, 0xc1, 0xea, 0x52, 0xbf, 0x5b, 0x35, 0x75, 0xd2,
    0x42, 0xbc, 0x53, 0x26, 0x76, 0x7d, 0x87, 0xdb, 0x0a, 0x61, 0x43,
    0xd7, 0x22, 0xbc, 0xbe, 0xf5, 0x2d, 0x79, 0xe8, 0xd9, 0x21, 0x1f,
    0xd9, 0x51, 0xe0, 0xd8, 0x6e, 0x91, 0x0d, 0x1d, 0x25, 0xaa, 0x73,
    0xe2, 0x24, 0x60, 0xdd, 0x2a, 0x31, 0xef, 0xe8, 0xdd, 0x15, 0x11,
    0x8e, 0x1b, 0x38, 0xa9, 0x15, 0x32, 0x6f, 0x63, 0xd9, 0x5a, 0x35,
    0xd0, 0x99, 0x0d, 0xd8, 0xac, 0x28, 0x96, 0x12, 0x4d, 0xca, 0xdf,
    0xf0, 0x2b, 0xd1, 0xc1, 0x8e, 0x10, 0x86, 0x20, 0xa7, 0x17, 0xe4,
    0xbb, 0x1e, 0xd6, 0x27, 0x6c, 0xf5, 0x63, 0x95, 0xf0, 0xd5, 0x63,
    0x64, 0x9b, 0x59, 0x84, 0xf6, 0x66, 0x27, 0xe7, 0x9b, 0x6d, 0x35,
    0xb8, 0x69, 0x94, 0x1f, 0x06, 0x65, 0x32, 0x93, 0x48, 0xb3, 0xca,
    0x3b, 0xa1, 0xdd, 0x4e, 0xa0, 0x10, 0x11,
};				/* 1024-bit prime */

static unsigned char dh_large_gen[] = { 
    0x38, 0xd0, 0x7f, 0x34, 0x3e, 0xbb, 0x55, 0x7f, 0x34, 0x86, 0xce,
    0x9c, 0x0b, 0x52, 0xe8, 0x5f, 0xbd, 0x6a, 0x4a, 0xf8, 0xfe, 0x2a,
    0x39, 0xde, 0xb9, 0x8e, 0x76, 0x61, 0xd8, 0x0c, 0x83, 0x3e, 0x83,
    0x36, 0x14, 0x86, 0x00, 0x86, 0x8c, 0xee, 0x40, 0xe9, 0x67, 0x9b,
    0xce, 0x47, 0xfd, 0x55, 0x7b, 0x5f, 0x74, 0x20, 0x34, 0x4c, 0x89,
    0xce, 0x99, 0xd3, 0x27, 0xb0, 0x0c, 0xd1, 0xb0, 0x7c, 0x48, 0xf3,
    0x97, 0xd5, 0xfc, 0x1a, 0x5a, 0x1e, 0x85, 0xe9, 0x5c, 0xe8, 0x95,
    0x8d, 0x4f, 0x5d, 0xd6, 0xdf, 0x73, 0xbf, 0x5e, 0x0b, 0x54, 0xa7,
    0x38, 0x01, 0x4e, 0xb8, 0xd8, 0xa9, 0x20, 0xd2, 0xd6, 0x2e, 0xec,
    0x25, 0xd5, 0xab, 0x3a, 0x70, 0xee, 0xca, 0xc2, 0x3a, 0x2c, 0x82,
    0x80, 0x2f, 0x13, 0x56, 0x78, 0x91, 0x83, 0x86, 0xb1, 0x4f, 0xf3,
    0x54, 0x46, 0xd2, 0x5e, 0x88, 0x37, 0x15,
};				/* 1000-bit generator */

static unsigned char dh_enormous_prime[] = {
    0x9a, 0xac, 0x0a, 0xc7, 0x26, 0x9e, 0xf2, 0x18, 0xae, 0x8d, 0x98,
    0xfa, 0xd0, 0xa5, 0xf1, 0x1f, 0xe3, 0x79, 0x37, 0x2d, 0xd2, 0x1d,
    0x49, 0x2f, 0x34, 0xa5, 0x4c, 0x47, 0xa0, 0xe3, 0x86, 0xf2, 0x68,
    0xb4, 0x8e, 0x7b, 0xf1, 0xea, 0xc2, 0x63, 0xc2, 0xce, 0xfb, 0xd4,
    0x35, 0x4e, 0x77, 0xd0, 0xa4, 0x0e, 0xc8, 0xae, 0x94, 0x2c, 0x13,
    0xa4, 0xc2, 0x07, 0x7f, 0x6e, 0x3e, 0xde, 0x08, 0x4f, 0x16, 0xa7,
    0x4c, 0x58, 0xc2, 0x47, 0xa5, 0xc3, 0x70, 0x77, 0xd5, 0x8b, 0xc2,
    0x90, 0xa4, 0x49, 0x56, 0x7d, 0x22, 0x38, 0xf1, 0x77, 0x25, 0xbb,
    0x8b, 0x82, 0x37, 0xcb, 0x54, 0x2c, 0xf5, 0xb2, 0x40, 0x9e, 0x8f,
    0xdf, 0x12, 0x0b, 0x15, 0xa1, 0x5d, 0x0f, 0x8b, 0xec, 0xbc, 0x61,
    0x3d, 0xf4, 0x4f, 0x95, 0x0f, 0x6e, 0x96, 0xb4, 0xf5, 0xc3, 0xd6,
    0xd0, 0xd7, 0xcb, 0x3e, 0x64, 0x50, 0xaf, 0x7c, 0x3d, 0x2e, 0x7f,
    0xd8, 0x2d, 0xf3, 0x9b, 0xc1, 0x2d, 0xd6, 0x1a, 0xad, 0x74, 0x37,
    0x8e, 0x21, 0xda, 0x92, 0x4f, 0x8c, 0x68, 0xe5, 0x5e, 0x6c, 0x76,
    0x89, 0xc8, 0x6c, 0xe8, 0xbc, 0xab, 0x56, 0xe0, 0xcb, 0x0a, 0xae,
    0xfb, 0xe1, 0x1b, 0xa2, 0xd7, 0xc6, 0x52, 0x5d, 0x88, 0xc3, 0x44,
    0x22, 0x89, 0x7b, 0xff, 0xd9, 0xe0, 0x85, 0x7c, 0xc9, 0x26, 0x7e,
    0xed, 0xff, 0x8c, 0x8d, 0x8e, 0x9b, 0xda, 0x50, 0x1a, 0x8b, 0x9b,
    0xba, 0x0a, 0x33, 0xcf, 0x4c, 0x23, 0x88, 0x00, 0xf0, 0x9b, 0x59,
    0xbe, 0x38, 0xe1, 0x95, 0x37, 0x3b, 0xa7, 0x86, 0x90, 0xc0, 0xef,
    0xb0, 0xfb, 0x6e, 0xfc, 0x15, 0x66, 0xe1, 0xc7, 0x09, 0x0e, 0x1f,
    0x2b, 0xe4, 0xa9, 0xc8, 0xbf, 0x9c, 0xef, 0x47, 0x0a, 0xfa, 0xd3,
    0xa4, 0xc7, 0x87, 0xd6, 0x29, 0xcc, 0xb5, 0x73, 0x1f, 0xba, 0x57,
    0xa1, 0x63, 0x97,
};				/* 2048 bit prime */

static unsigned char dh_enormous_gen[] = {
    0x6f, 0xe3, 0xd1, 0xdd, 0x1f, 0x4f, 0x30, 0xfd, 0x80, 0xcc, 0x4c,
    0xcd, 0x07, 0x8e, 0x3d, 0x41, 0xc8, 0xce, 0x71, 0x93, 0xc6, 0xac,
    0xe8, 0xbb, 0x45, 0x82, 0xbc, 0xa4, 0x9e, 0xb0, 0x3c, 0xb3, 0xe6,
    0xb5, 0x41, 0x01, 0x8d, 0x26, 0x30, 0x7d, 0x00, 0xfb, 0x77, 0x4e,
    0x7b, 0x66, 0x6b, 0x7a, 0x49, 0x22, 0x53, 0xb7, 0xf3, 0xc8, 0xff,
    0xab, 0x18, 0xe4, 0xa4, 0xfa, 0x2a, 0xe1, 0x06, 0x7b, 0xd7, 0x3e,
    0x72, 0xd3, 0x71, 0x71, 0xc7, 0x77, 0x95, 0xdd, 0xc2, 0x52, 0x17,
    0xac, 0x2f, 0x79, 0x20, 0x66, 0xd4, 0x82, 0x5a, 0xd3, 0x86, 0xef,
    0x48, 0x5e, 0xfc, 0x8e, 0x4e, 0x92, 0xe4, 0xbf, 0x0d, 0x98, 0xea,
    0x88, 0x3a, 0x55, 0xe1, 0x36, 0x73, 0xe4, 0xc5, 0x86, 0x61, 0x94,
    0x3f, 0x2a, 0x69, 0x5b, 0xba, 0x19, 0x13, 0x8a, 0x8a, 0x7c, 0xf1,
    0x17, 0xf9, 0x3c, 0x1f, 0x51, 0x43, 0xd7, 0x0d, 0x78, 0xe1, 0x67,
    0x41, 0x42, 0x64, 0x02, 0x80, 0x7f, 0x38, 0x3b, 0x3a, 0x72, 0xd5,
    0x07, 0xa9, 0x40, 0xc3, 0x7b, 0xf9, 0xd0, 0xfb, 0x8e, 0x0b, 0xb0,
    0xa0, 0x86, 0x56, 0xe7, 0xcc, 0xdf, 0x9d, 0x8b, 0x4b, 0x14, 0x5c,
    0x20, 0x0a, 0xe4, 0xad, 0x1a, 0x07, 0x52, 0x0f, 0xc3, 0xe3, 0x5d,
    0xab, 0xab, 0x8c, 0x09, 0x30, 0xc1, 0x7c, 0x58, 0x37, 0xa0, 0x2f,
    0x93, 0x73, 0xfb, 0xf7, 0xab, 0xee, 0x2a, 0x11, 0x7d, 0x61, 0x62,
    0x09, 0xa3, 0x01, 0x90, 0x5a, 0x30, 0xc3, 0x8d, 0xc7, 0xf8, 0x63,
    0x24, 0x52, 0x1c, 0x72, 0x64, 0x95, 0x03, 0x3a, 0x4e, 0x49, 0x41,
    0x1a, 0x3d, 0xab, 0x39, 0x83, 0x76, 0xe0, 0x88, 0xe4, 0x16, 0x42,
    0x09, 0x3e, 0x30, 0x4a, 0x61, 0xdf, 0x18, 0xc8, 0x69, 0xf4, 0xb2,
    0x9f, 0xa4, 0xf8, 0x40, 0xb2, 0x54, 0xfa, 0x16, 0x3c, 0xa6, 0x8d,
    0x3a, 0x74, 0x9f,
};				/* 2000-bit generator */

#define BITS(n) (n/8)	/* # of bytes in N bits */

R_DH_PARAMS dh_small_params = {
    dh_small_prime,		/* prime */
    BITS(512),			/* prime length in bytes */
    dh_small_gen,		/* generator */
    BITS(500),			/* generator length in bytes */
};

R_DH_PARAMS dh_medium_params = {
    dh_medium_prime,	/* prime */
    BITS(768),			/* prime length in bytes */
    dh_medium_gen,		/* generator */
    BITS(750),			/* generator length in bytes */
};

R_DH_PARAMS dh_large_params = {
    dh_large_prime,		/* prime */
    BITS(1024),			/* prime length in bytes */
    dh_large_gen,		/* generator */
    BITS(1000),			/* generator length in bytes */
};

R_DH_PARAMS dh_enormous_params = {
    dh_enormous_prime,	/* prime */
    BITS(2048),			/* prime length in bytes */
    dh_enormous_gen,	/* generator */
    BITS(2000),			/* generator length in bytes */
};
