#include <sys/param.h>
#include <sys/systm.h>
#include <sys/proc.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/vnode.h>
#include <sys/mount.h>
#include <sys/namei.h>
#include <sys/malloc.h>
#include <sys/buf.h>
#include <miscfs/tcfs/tcfs.h>
#include "kdes.h"
#include "tcfs_rw.h"

int tcfs_new_direntry	(void *, tcfs_fileinfo *);

int tcfs_new_direntry(void *v , tcfs_fileinfo *i)
{
	struct vop_create_args *x;
	struct ucred *cr;
	struct proc *pr;
	int err;

	x=(struct vop_create_args *)v;
	cr=x->a_cnp->cn_cred;
	pr=x->a_cnp->cn_proc;

	/* qui cifro la entry */

	/* Per i file speciali e per i link, niente flags (per ora)*/
	if((x->a_desc==VDESC(vop_mknod))||
	   (x->a_desc==VDESC(vop_symlink))||
	   (x->a_desc==VDESC(vop_link)))
		return tcfs_bypass(v);
	   
	if(!(err=tcfs_bypass(v)))
		err=tcfs_xsetflags(*(x->a_vpp),pr,cr,i);

	return err;
}

int tcfs_create(v)
void *v;
{
	struct vop_create_args *x;
	struct ucred *cr;
	struct proc *pr;
	tcfs_fileinfo i;

	x=(struct vop_create_args *)v;
	cr=x->a_cnp->cn_cred;
	pr=x->a_cnp->cn_proc;
	i=tcfs_xgetflags(x->a_dvp,pr,cr);

	if(FI_CFLAG(&i)||FI_GSHAR(&i))
		return tcfs_new_direntry(v,&i);
	else
		return tcfs_bypass(v);
}

int tcfs_mknod(v)
void *v;
{
	struct vop_mknod_args *x;
	struct ucred *cr;
	struct proc *pr;
	tcfs_fileinfo i;

	x=(struct vop_mknod_args *)v;
	cr=x->a_cnp->cn_cred;
	pr=x->a_cnp->cn_proc;
	i=tcfs_xgetflags(x->a_dvp,pr,cr);

	if(FI_CFLAG(&i)||FI_GSHAR(&i))
		return tcfs_new_direntry(v,&i);
	else
	return tcfs_bypass(v);
}

int tcfs_mkdir(v)
void *v;
{
	struct vop_mkdir_args *x;
	struct ucred *cr;
	struct proc *pr;
	tcfs_fileinfo i;

	x=(struct vop_mkdir_args *)v;
	cr=x->a_cnp->cn_cred;
	pr=x->a_cnp->cn_proc;
	i=tcfs_xgetflags(x->a_dvp,pr,cr);

	if(FI_CFLAG(&i)||FI_GSHAR(&i))
		return tcfs_new_direntry(v,&i);
	else
	return tcfs_bypass(v);
}

int tcfs_link(v)
void *v;
{
	struct vop_link_args *x;
	struct ucred *cr;
	struct proc *pr;
	tcfs_fileinfo i;

	x=(struct vop_link_args *)v;
	cr=x->a_cnp->cn_cred;
	pr=x->a_cnp->cn_proc;
	i=tcfs_xgetflags(x->a_dvp,pr,cr);

	if(FI_CFLAG(&i)||FI_GSHAR(&i))
		return tcfs_new_direntry(v,&i);
	else
	return tcfs_bypass(v);
}

int tcfs_symlink(v)
void *v;
{
	struct vop_symlink_args *x;
	struct ucred *cr;
	struct proc *pr;
	tcfs_fileinfo i;

	x=(struct vop_symlink_args *)v;
	cr=x->a_cnp->cn_cred;
	pr=x->a_cnp->cn_proc;
	i=tcfs_xgetflags(x->a_dvp,pr,cr);

	if(FI_CFLAG(&i)||FI_GSHAR(&i))
		return tcfs_new_direntry(v,&i);
	else
		return tcfs_bypass(v);
}
