#include <asm/segment.h>

#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/ioctl.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/tcfs_fs.h>

#include <linux/locks.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>
/* This is for kernel_thread */
#define __KERNEL_SYSCALLS__
#include <linux/unistd.h>
/* These are the function needed to handle keys hash table */ 
#include <linux/tcfs/hash.h>
#include <linux/tcfs/cipherinterface.h>

int tcfsusers;

int
tcfs_ioctl(struct inode * inode, struct file * filp, unsigned int cmd,
unsigned long arg)
{
	struct login lg;
	struct tgroup gl; 
	int uid, gid;
	int err=0;
	void *ks;
	void *gks;
	struct gid_hash_entry * ghtmp;
	struct hash_entry * he;
	unsigned int mode;
	struct tcfs_fattr fattr;
	int error;
	char tcfs_version[]={
                        TCFS_VERSION,
                        TCFS_VERSION_MINOR,
                        0,
			CIPHER_DES
                    }; 

	switch(cmd) {
	case TCFS_IOC_GETFLAGS:
		err = verify_area(VERIFY_WRITE, (int *) arg, sizeof(int));
		if (err)
			return err;
		put_user(inode->u.tcfs_i.tcfs_fl.cflag,(int *) arg);
		return 0;
	case TCFS_IOC_SETFLAGS:
		if (current->uid != inode->i_uid) {
			err=-EACCES;
			return err;
		}
		err = verify_area(VERIFY_READ, (int *) arg, sizeof(int));
		if (err)
			return err;
		memcpy_fromfs(&mode,(unsigned int *)arg,sizeof(int));
		TCFS_SEMW_DOWN(inode);
		err=tcfs_proc_seteattr(inode,&(inode->i_sb->u.tcfs_sb.x_server),inode->u.tcfs_i.pathname,mode,filp);
		TCFS_SEMW_UP(inode);
		error=tcfs_proc_getattr(TCFS_SERVER(inode), TCFS_FH(inode), &fattr);
		if (!error)
			tcfs_refresh_inode(inode,&fattr);
		return err;
	case TCFS_IOC_GETVERSION:
		err = verify_area(VERIFY_WRITE, (long *) arg, sizeof(long));
		if (err)
			return err;
		put_user(*(long *)tcfs_version, (long *)arg);
		return 0;
	case TCFS_IOC_SETVERSION: /* for compatibility purpouses */
		return 0;
	case TCFS_IOC_LOGIN:
		err = verify_area(VERIFY_READ, (unsigned char *) arg, sizeof(lg));

#ifdef TCFS_DEBUG
		printk ("TCFS_debug: in TCFS_IOC_LOGIN\n");
#endif
		if (err) {
			return err;
		}
		memcpy_fromfs(&lg,(struct login *)arg,sizeof(lg));

		ks=tcfs_init_key (lg.deskey);

		if (ks==NULL) {
			printk("TCFS: error initializing the key\n");
			return -ENOMEM;
		}

#ifdef TCFS_DEBUG
		{
			int i;
			char *pnt;

			printk("TCFS_debug: key is: ");

			pnt=(char *)&ks[0];
	 		for(i=0;i<16;i++,pnt++){	
				printk("%x:",(unsigned int)*pnt);
			}
			printk("\n");	
		
		}
#endif
			
		if (hash_add(lg.uid,lg.deskey,ks)==NULL) {
			kfree(ks);
		}

#ifdef TCFS_DEBUG
		printk ("TCFS_debug: exiting TCFS_IOC_LOGIN\n");
#endif

		tcfsusers++;
		return 0;

	case TCFS_IOC_LOGOUT:
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(uid));
		if (err) {
			return err;
		}
		memcpy_fromfs(&uid,(unsigned int *)arg,sizeof(uid));
		hash_rem_count(uid);
		tcfsusers--;
		return 0;

	case TCFS_IOC_FULLOUT:
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(uid));
		if (err) {
			return err;
		}
		memcpy_fromfs(&uid,(unsigned int *)arg,sizeof(uid));
		hash_rem_all(uid);
		return 0;

	case TCFS_IOC_SETFIX:
		if ((he=hash_lookup(current->uid))==NULL)
			return -EINVAL;
		he->permanent=1;
		return 0;

	case TCFS_IOC_GETFIX:
		err = verify_area(VERIFY_WRITE, (unsigned char *) arg, sizeof(unsigned char));
		if (err) {
			return err;
		}
		he=hash_lookup(current->uid);
		if (he==NULL)
			return -EINVAL;
		put_user(he->permanent,(unsigned char *)arg);
		return 0;

	case TCFS_IOC_GETCOUNT:
		err = verify_area(VERIFY_WRITE, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		he=hash_lookup(current->uid);
		if (he==NULL) {
			return -EINVAL;
			put_user(0,(unsigned int *)arg);
		}
		put_user(he->count,(unsigned int *)arg);
		return 0;

	case TCFS_IOC_DELFIX:
		he=hash_lookup(current->uid);
		if (he==NULL)
			return -EINVAL;
		hash_rem_permanent(current->uid);
		return 0;

	case TCFS_IOC_GLOGIN:
		err = verify_area(VERIFY_READ, (unsigned char *) arg, sizeof(gl));
#ifdef TCFS_DEBUG
		printk ("TCFS_debug: in TCFS_IOC_GLOGIN\n");
#endif
		if (err) {
			printk ("TCFS: error in GLOGIN, err=%d\n", err);
			return err;
		}
		memcpy_fromfs(&gl,(struct tgroup *)arg,sizeof(gl));
#ifdef TCFS_DEBUG
		{
			int i;
			printk ("TCFS_debug: key got via ioctl is: ");
			for (i=0;i<(KEYSIZE+KEYSIZE/8);i++)
				printk ("%u:", gl.deskey[i]);
			printk ("\n");
		}
#endif

		if ((ghtmp=gid_hash_lookup(gl.gid))==NULL) 
			ghtmp=gid_hash_add(gl.gid);
		if (gid_uid_add(gl.gid,gl.uid,gl.deskey)==NULL)
			return 0;
		if (ghtmp->ins<gl.soglia)
			return 0; 
                if (ghtmp->ins>gl.soglia) {
#ifdef TCFS_DEBUG
			printk("TCFS_debug: Key already present.\n");
#endif
			return 0;
		}
#ifdef TCFS_DEBUG
		printk ("TCFS_debug: threshold limit reached...interpolating..\n");
#endif

		memset(ghtmp->gidkey,'\0',KEYSIZE);
		interp(ghtmp->key,ghtmp->ins,ghtmp->gidkey);

/* ???
		if (ghtmp->ks==NULL) {
			gks=(des_key_schedule *)kmalloc(2*sizeof(des_key_schedule),GFP_KERNEL);  
			if (gks==NULL) {
				printk("TCFS: Unable to get a free page\n");
				return -ENOMEM;
			}
			ghtmp->ks=gks;
		}
*/

		ghtmp->ks=tcfs_init_key (ghtmp->gidkey);

#ifdef TCFS_DEBUG
		printk ("TCFS_debug: exiting TCFS_IOC_GLOGIN\n");
#endif
		return 0;

	case TCFS_IOC_GLOGOUT:
		err = verify_area(VERIFY_READ, (unsigned char *) arg, sizeof(gl));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gl,(struct tgroup *)arg,sizeof(gl));
		if ((ghtmp=gid_hash_lookup(gl.gid))==NULL) 
			return 0;
		gid_uid_rem_count(gl.gid,gl.uid);
		if (ghtmp->ins==0) {
			gid_hash_rem(gl.gid);
			return 0;
		}

		/* If we go below the threshold, the key gets removed */
		if (ghtmp->ins<gl.soglia) {
			gks=ghtmp->ks;
			ghtmp->ks=NULL;
			kfree(gks);
			memset(ghtmp->gidkey,'\0',KEYSIZE);
		}
		return 0;

	case TCFS_IOC_GFULLOUT:
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(gid));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gid,(unsigned int *)arg,sizeof(gid));
		gid_uid_rem_all(gid,current->uid);
		return 0;
	case TCFS_IOC_GSETFIX:
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(gid));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		he->permanent=1;
		return 0;

	case TCFS_IOC_GGETFIX:
		err = verify_area(VERIFY_WRITE, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		put_user(he->permanent,(unsigned int *)arg);
		return 0;

	case TCFS_IOC_GGETCOUNT:
		err = verify_area(VERIFY_WRITE, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		put_user(he->count,(unsigned int *)arg);
		return 0;

	case TCFS_IOC_GDELFIX:
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		gid_uid_rem_permanent(gid,current->uid);
		return 0;
	default:
			return -ENOTTY;
	}
}
