/*
 * T.C.F.S. 2.0 $Revision: 1.2 $
 *
 *      	This program handles RPC "TCFS" data requests 
 *              adopting a secure transfer protocol.
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

/*
 *       $Source: /usr/src/tcfs-current/linux/RCS/tcfs_mount.h,v $
 *        $State: Exp $
 *
 *     $Revision: 1.2 $ 
 *       $Author: ermmau $
 *         $Date: 1996/09/20 14:08:59 $
 *       $Locker: ermmau $
 */              

/*
 * $Log: tcfs_mount.h,v $
 * Revision 1.2  1996/09/20 14:08:59  ermmau
 * *** empty log message ***
 *
 * Revision 1.1  1996/09/18 13:30:29  andcoz
 * Initial revision
 *
 *
 */

/* -+-_== */


#ifndef _LINUX_TCFS_MOUNT_H
#define _LINUX_TCFS_MOUNT_H

/*
 *  linux/include/linux/tcfs_mount.h
 *
 *  Copyright (C) 1992  Rick Sladkey
 *
 *  structure passed from user-space to kernel-space during an tcfs mount
 */

/*
 * WARNING!  Do not delete or change the order of these fields.  If
 * a new field is required then add it to the end.  The version field
 * tracks which fields are present.  This will ensure some measure of
 * mount-to-kernel version compatibility.  Some of these aren't used yet
 * but here they are anyway.
 */

#define TCFS_PROGRAM		100003	/* tcfsd program number */
#define TCFS_VERSION		2	/* tcfsd version */
#define TCFS_PORT		2049	/* portnumber on server for tcfsd */

#define TCFS_MOUNT_PROGRAM	100005	/* mountd program number */
#define TCFS_MOUNT_VERSION	1	/* mountd version */
#define TCFS_MOUNT_PROC		1	/* mount process id */
#define TCFS_MOUNT_PORT		627	/* portnumber on server for mountd */

#define TCFS_PMAP_PROGRAM	100000	/* portmap program number */
#define TCFS_PMAP_VERSION	2	/* portmap version */
#define TCFS_PMAP_PROC		3	/* portmap getport id */
#define TCFS_PMAP_PORT		111	/* portnumber on server for portmap */

struct tcfs_mount_data {
	int version;			/* 1 */
	int fd;				/* 1 */
	int xasock;			/* Socket for xattrd daemon */
	struct tcfs_fh root;		/* 1 */
	int flags;			/* 1 */
	int rsize;			/* 1 */
	int wsize;			/* 1 */
	int timeo;			/* 1 */
	int retrans;			/* 1 */
	int acregmin;			/* 1 */
	int acregmax;			/* 1 */
	int acdirmin;			/* 1 */
	int acdirmax;			/* 1 */
	struct sockaddr_in addr;	/* 1 */
	struct sockaddr_in xattraddr;	/* Socket for xattrd daemon */
	char hostname[256];		/* 1 */
	char remote[1024];
};

/* bits in the flags field */

#define TCFS_MOUNT_SOFT		0x0001	/* 1 */
#define TCFS_MOUNT_INTR		0x0002	/* 1 */
#define TCFS_MOUNT_SECURE	0x0004	/* 1 */
#define TCFS_MOUNT_POSIX		0x0008	/* 1 */
#define TCFS_MOUNT_NOCTO		0x0010	/* 1 */
#define TCFS_MOUNT_NOAC		0x0020	/* 1 */
 
#endif
