/*
 * TCFS v. 0.5alpha-linux
 *
 * tcfsgenkey       tcfs-key generator
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *

 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <errno.h>
#include "tcfscode.h"
#include "genkey.h"
#include "defines.h"

#ifndef SECUDEDES
#include "d3des.h"
#endif

extern char *getsfskey (char *);

char *addsfsuser (char *login, char *pass)
{
	FILE *sfspf;
	char *newkey;
	char *cryptedkey;

	puts("now we'll generate the des key.");
	newkey=gendeskey();

	cryptedkey=(char*)calloc(KEYSIZE,sizeof(char));

	if ((sfspf=fopen (SFSPWDFILE, "a"))==NULL)
	{
		perror ("Error trying to open the tcfs passwd file");
		exit (1);
	}
	
	strcpy (cryptedkey, newkey);

	if (strlen (pass)<8)
		strcat(pass, pass);

#ifdef SECUDEDES
	desinit (DESMETHOD, D3DES);
	setkey_ (pass);
	endes (cryptedkey);
#else
	deskey (pass, EN0);
	desd3 (cryptedkey, newkey);
#endif

	cryptedkey=sfsencode(cryptedkey, strlen(cryptedkey));
	fprintf (sfspf, "%s:%s\n", login, cryptedkey);
	fclose (sfspf);
	return newkey;
}

void usage (char *progname)
{
	printf ("Usage: $s [login [password]]\n", progname);
	exit(1);
}

void main (int argn, char **argv)
{
	FILE *sfspf;
	char pass[128];
	char login[10];
	struct passwd *passentry;

	if ((sfspf=fopen (SFSPWDFILE, "a+"))==NULL)
	{
		perror ("Error trying to create the tcfs passwd file");
		exit (1);
	}
	fclose (sfspf);

	if (argn==1)
	{
		printf ("login: ");
		gets(login);
		strcpy (pass, getpass("password:"));
	}
	else
	if (argn>1)
	{
		if (strcmp(argv[1], "help")==0)
			usage(argv[0]);
		strcpy(login, argv[1]);
		if (argn>2)
			strcpy (pass, argv[2]);
		else
			strcpy (pass, getpass("password:"));
	}
	
	if ((passentry=getpwnam (login))==NULL)
	{
		fprintf (stderr, "This login does not seems to exist!\n");
		exit (1);
	}
	
	if (strcmp (crypt (pass, passentry->pw_passwd), passentry->pw_passwd)!=0)
	{
		fprintf (stderr, "Illegal password!\n");
		exit (1);
	}

	if (getsfskey (login)!=NULL)
	{
		fprintf (stderr, "User %s has already an tcfs key!\n", login);
		exit (1);
	}

	addsfsuser (login, crypt (pass, passentry->pw_passwd));
}
