/*
 * S.F.S. v. 0.5alpha-linux
 *
 * xattr_subs.c: routine per la gestione delle ioctl remote.
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

/* 
 * $Source: /home/andcoz/C/xattrd/RCS/xattr_subs.c,v $
 */

/*
 * $Header: /home/andcoz/C/xattrd/RCS/xattr_subs.c,v 1.3 1996/05/02 10:25:10 andcoz Exp $
 *
 * $Author: andcoz $ $Locker:  $
 * $Date: 1996/05/02 10:25:10 $ $Revision: 1.3 $
 */

/*
 * $Log: xattr_subs.c,v $
 * Revision 1.3  1996/05/02  10:25:10  andcoz
 * Corretti in nomi di file con _svc.
 * Ignorando i suggerimenti di ermmau.
 *
 * Revision 1.2  2036/02/07  06:28:35  andcoz
 * Modificato il meccanismi di ritorno del risultato.
 *
 * Revision 1.1  1996/04/30 13:48:15  andcoz
 * Initial revision
 *
 * Revision 1.1  1996/04/30 13:32:58  andcoz
 * Initial revision
 *
 */

/* -+-_== */

#include "xattr.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/ext2_fs.h>

void *xattrproc_null_1_svc(void *argp, struct svc_req *dummy)
{
  return 0;
}

res *xattrproc_geteattr_1_svc(geteattrargs *argp, struct svc_req *dummy)
{
  static unsigned long mode;
  static int fd, r;
  static res res;
  unsigned long flags;

  res.mode=-1;
  fd=open(argp->filename, O_RDONLY);
  
  if (fd<0)
    return &res;
  
  r=ioctl(fd, EXT2_IOC_GETFLAGS, &flags);
  
  close(fd);
  
  if (r<0)
    return &res;

  res.mode=flags;

  return &res;
}

res *xattrproc_seteattr_1_svc(seteattrargs *argp, struct svc_req *dummy)
{
  static unsigned long mode;
  static int fd,r;
  static res res;
  unsigned long flags;
 
  res.mode=-1; 
  flags=argp->mode;
  fd=open(argp->filename,O_RDONLY);

  if (fd<0)
    return &res;

  r=ioctl (fd, EXT2_IOC_SETFLAGS, &flags);
  close(fd);

  if (r>0)
    res.mode=0;

    return &res;
}

