/*
 * T.C.F.S. v. 1.0beta-linux
 *
 * strick.c: functions to attach the two nfs-mounted couples of fs.
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 * This code derives from: 
 *
 */





#include <stdio.h>
#include <rpc/rpc.h>
#include <sys/time.h>
#include <sys/mount.h>
#include "tcfs_prot.h"
#include <syslog.h>
#include "tcfs.h"
#include "mount.h"

/* Updates mountd mount-tables for NFS pathname conversion */ 
stick (local_dir,dummy_dir,remote_dir,work_dir)
char *local_dir,*dummy_dir,*remote_dir,*work_dir;
{
  sfs_stickargs ap;
  sfsstat ret=SFS_OK;
  int status;
  struct timeval tout = {60,0};
  char locdir[NFS_MAXPATHLEN+1],buf[NFS_MAXPATHLEN+1], dumdir[NFS_MAXPATHLEN+1];
  char remdir[NFS_MAXPATHLEN+1],tmp[1024],workdir[NFS_MAXPATHLEN+1];
  CLIENT *cln;
  
  if ((local_dir==NULL) || (remote_dir==NULL) || (dummy_dir==NULL)) {
    return ADM_BADUSAGE;
  }
  /* local dir test */
  if (*local_dir!='/') {
    if (getwd(buf) == NULL) {
      syslog(LOG_DAEMON,"stick: Can't stat current dir\n");
      return ADM_CWDERR;
    }
    sprintf(locdir,"%s/%s",buf,local_dir);
  } else
    strcpy(locdir,local_dir);
  if (chdir(locdir)<0) {
    sprintf(tmp,"stick: Can't change dir to %s\n",locdir);
    syslog(LOG_DAEMON,tmp);
    return ADM_ACCERR;
  }
  /* dummy dir test */
  if (*dummy_dir!='/') {
    if (getwd(buf) == NULL) {
      syslog(LOG_DAEMON,"stick: Can't stat current dir\n");
      return ADM_CWDERR;
    }
    sprintf(dumdir,"%s/%s",buf,dummy_dir);
  } else
    strcpy(dumdir,dummy_dir);
  if (chdir(dumdir)<0) {
    sprintf(tmp,"stick: Can't change dir to %s\n",dumdir);
    syslog(LOG_DAEMON,tmp);
    return ADM_ACCERR;
  }
  /* work dir test */
  if (*work_dir!='/') {
    if (getwd(buf) == NULL) {
      syslog(LOG_DAEMON,"stick: Can't stat current dir\n");
      return ADM_CWDERR;
    }
    sprintf(workdir,"%s/%s",buf,work_dir);
  } else
    strcpy(workdir,work_dir);
  if (chdir(workdir)<0) {
    sprintf(tmp,"stick: Can't change dir to %s\n",workdir);
    syslog(LOG_DAEMON,tmp);
    return ADM_ACCERR;
  }
  /* change current dir to / */
  chdir("/");
  if (strchr(remote_dir,':')==NULL) {
    syslog(LOG_DAEMON,"stick: wrong remote path format\n");
    return ADM_CWDERR;
  }
  strcpy(remdir,remote_dir);
  ap.local_dir=locdir;
  ap.dummy_dir=dumdir;
  ap.remote_dir=remdir;
  ap.work_dir=workdir;
   if ((cln=clnt_create("localhost",ADM_PROGRAM,ADM_VERSION,"udp"))
      == NULL) {
    clnt_pcreateerror("adm");
    return ADM_FAILED;
  }
  cln->cl_auth = authunix_create_default();
  if ((status = clnt_call(cln,ADMPROC_STICK,(xdrproc_t)xdr_sfs_stickargs,&ap,
			  (xdrproc_t)xdr_sfsstat,&ret,tout)) != RPC_SUCCESS) {
    clnt_perrno(status);
    return ADM_FAILED;
  }
  if (ret!=SFS_OK) {
    sprintf(tmp,"stick: %s\n",admmsg(ret-100));
    syslog(LOG_DAEMON,tmp);
  }
  return(ret);
}
