/*
 * T.C.F.S. v. 1.0beta-linux
 *
 * tcfs_adm.c:
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <rpc/rpc.h>
#include <sys/time.h>
#include <string.h>
#include "mount.h"
#include "tcfs_prot.h"

#include <syslog.h>
#include <errno.h>

#include "tcfs.h"

typedef struct svc_req *SR;

static nfstime roottime={0,0};

sfs_adm()
{
}

void *
admproc_null_2_svc( void * x, struct svc_req * cl)
{
}



sfsstat *
admproc_stick_2_svc(ap,rp)
     sfs_stickargs *ap;
     struct svc_req *rp;
{
	static sfsstat ret;
	char tmp[255]; 
	mtable *entry;
#ifdef DEBUG
	sprintf(tmp,"stick %s %s\n",ap->local_dir,ap->dummy_dir);
	syslog(LOG_DAEMON,tmp);
#endif
	if (already(ap->dummy_dir)) {
		ret=SFSERR_EXIST;
		return &ret;
	}
	if ((entry=(mtable *)malloc(sizeof(mtable)))==NULL){
	  syslog(LOG_DAEMON,"stick: not enough memory to allocate a mtable entry\n");
	  ret=SFSERR_IFULL;
	  return &ret;
	}
	entry->next==NULL;
	strcpy(entry->local_dir,ap->local_dir);
	strcpy(entry->remote_dir,ap->remote_dir);
	strcpy(entry->dummy_dir,ap->dummy_dir);
	strcpy(entry->work_dir,ap->work_dir);
	if (first==NULL)
	  first=entry;
	else {
	  entry->next=first;
	  first=entry;
	}
	ret=SFS_OK;
	return &ret;
}

already(s)
     char *s;
{
  mtable *tmp;
  tmp=first;
  while(tmp!=NULL) {
    if (!strcmp(s,tmp->dummy_dir))
      return 1;
    tmp=tmp->next;
  }
  return 0;
}

sfsstat *
admproc_unstick_2_svc(ap,rp)
sfs_unstickargs *ap;
struct svc_req *rp;
{
  static sfsstat ret;
  mtable *tmp,*prev;
  
  tmp=first; prev=first;
  while(tmp!=NULL) {
    if (!strcmp(ap->name,tmp->dummy_dir)) {
      if (first==prev) {
	first=first->next;
	free(prev);
	ret=SFS_OK;
	return &ret;
      }
      else {
	prev->next=tmp->next;
	free(tmp);
	ret=SFS_OK;
	return &ret;
      }
    }
    prev=tmp;
    tmp=tmp->next;
  }
  ret=SFSERR_NODIR;
  return &ret;
}

sfs_lookupres *
admproc_lookup_2_svc(ap,rp)
sfs_lookupargs *ap;
struct svc_req *rp;
{
  static sfs_lookupres ret;
  static char remote[NFS_MAXPATHLEN+1],work[NFS_MAXPATHLEN+1];
  static char dummy[NFS_MAXPATHLEN+1];
  mtable *tmp=first;
  ret.remote=remote;
  ret.work=work;
  ret.dummy=dummy;
  strcpy(remote,"");
  strcpy(work,"");
  strcpy(dummy,"");
  while (tmp!=NULL) {
    if (ap->mode==0) {
      if (strstr(ap->name,tmp->work_dir)!=NULL) {
	strcpy(ret.remote,tmp->remote_dir);
	strcpy(ret.work,tmp->work_dir);
	strcpy(ret.dummy,tmp->dummy_dir);
	return &ret;
      }
    }
    else {
      if (strstr(ap->name,tmp->dummy_dir)!=NULL) {
	strcpy(ret.remote,tmp->remote_dir);
	strcpy(ret.work,tmp->work_dir);
	strcpy(ret.dummy,tmp->dummy_dir);
	return &ret;
      }
    }
    tmp=tmp->next;
  }
  syslog(LOG_DAEMON,"sfs_lookup: entry not found in stick table.");
  return &ret;
}




