/*
 * T.C.F.S. v. 1.0beta-linux
 *
 * uid.h: hash-table for the user - criptation key couples.
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */
/* 	$Id: uid.h,v 1.2 1996/02/19 10:50:38 andcoz Exp $	 */

#include <unistd.h>

#ifndef UID_H
#define UID_H

typedef enum fskeyerror_t{
  E_NoSlotLeft=1,
  E_NoMemLeft=2,
  E_NotFound=4
} fskeyerror_t;

char *fskey(uid_t uid);
fskeyerror_t set_fskey(uid_t uid, char* key);
fskeyerror_t del_fskey(uid_t uid);

#endif






