/*
 * T.C.F.S. v. 1.0beta-linux
 *
 * getfskey     gets the secure sfs-key
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "defines.h"

char *getsfskey (char *login)
{
	FILE *sfspf;
	static char *token[2];
	
	if ((sfspf=fopen(SFSPWDFILE, "r"))==NULL)
	{
		perror ("Error opening sfs passwd file");
		exit (1);
	}
	
	while (!feof(sfspf))
	{
		int i;
		char *line;

		line=(char*)calloc(25,sizeof(char));

		fgets (line, 25, sfspf);
		if (feof(sfspf))
			break;
		token[0]=strtok(line, ":");
		token[1]=line+strlen(token[0])+1;
		if (strcmp(login, token[0])==0)
		{
			fclose (sfspf);
			return token[1];
		}
		free (line);
	}

	fclose (sfspf);
	return (NULL);
}
