/*
 * TCFS v. 2.0.1
 *
 * tcfslogin    disable the user to use tcfs-filesystem
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */
#include <stdio.h>
#include <linux/fs.h>
#include <linux/tcfs_fs.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <mntent.h>
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>

#include "defines.h"
#include "tcfscode.h"

void tcfs_disable_user (void)
{
  int fd, user=getuid(),set=0;
  struct mntent *mount_points;
  FILE *mtab;

  /* Get TCFS mount points */
  if ((mtab=setmntent ("/etc/mtab", "r"))==NULL)
    {
      perror ("tcfslogin");
      exit (1);
    }

  while ((mount_points=getmntent (mtab))!=NULL)
    {
#ifdef DEBUG_TCFS
      printf ("\n Entry\n type: %s\n fsname: %s\n dir: %s\n", mount_points->mnt_type, mount_points->mnt_fsname, mount_points->mnt_dir);
#endif
      if (strcmp (mount_points->mnt_type, "tcfs")==0)
	{
	  /* Got a TCFS File System */
	  if ((fd=open (mount_points->mnt_dir, O_RDONLY))<0)
	    perror (mount_points->mnt_dir);
	  else
            {
#ifdef DEBUG_TCFS
	      printf ("\n Calling IOCTL\n");
#endif
	      ioctl (fd, TCFS_IOC_LOGOUT, &user);
	      set++;
            }
	  close (fd);
	}
    }
  endmntent (mtab);
  if (set==0)
  	printf("No TCFS File Systems mounted\n");
}

void main (void)
{
  int len;
  char pass[128];
  struct passwd *passentry;
  
  strcpy (pass, getpass("Please enter your password:"));
  
  if ((passentry=getpwuid (getuid()))==NULL)
    {
      perror ("Error. Who are you??");
      exit (1);
    }
  
  if (strcmp (crypt (pass, passentry->pw_passwd), passentry->pw_passwd)!=0)
    {
      fprintf (stderr, "Illegal password!\n");
      exit (1);
    }
  
  tcfs_disable_user ();
}
