/*
 * T.C.F.S. 2.0 Alpha 1 
 *
 *      	   This  program  handles  RPC  "NFS"  data  requests
 *              adopting a secure transfer protocol.
 *                 This   is  an  unsecure   and  unchecked  version,
 *              use at your own risk.
 *
 *              Please, report Bugs to: <tcfs@edu-gw.dia.unisa.it>
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@edu-gw.dia.unisa.it>
 *		Angelo Celentano, <angcel@edu-gw.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@edu-gw.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@edu-gw.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@edu-gw.dia.unisa.it>
 *
 *   Permission to  use, copy, and modify  this software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies  of  any  software  which  is  or  includes a  copy  or
 * modification of this software and in all copies  of the supporting
 * documentation for such software.
 *
 *   This  software is  distribuited  under  the  GNU General  Public
 * License  (version  2, June  1991). Check  the  file  'COPYING'  for
 * more  infos. Some  parts of  this  software  derive  from the  NFS
 * implementation in the Linux kernel 2.0.x.
 *
 * This software  maybe be used  for any  purpose provided  the above
 * copyright  notice  is retained.  It  is  supplied  as is,  with no
 * warranty expressed or implied.
 *
 */

/* -+-_== */

#include <asm/segment.h>

#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/ioctl.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/tcfs_fs.h>

#ifdef TCFS_DES
#include <linux/kdes.h>
#endif

#ifdef TCFS_IDEA
#include <linux/idea.h>
#endif

#ifdef TCFS_RC5
#include <linux/rc5.h>
#endif

#include <linux/locks.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>
/* This is for kernel_thread */
#define __KERNEL_SYSCALLS__
#include <linux/unistd.h>
/* These are the function needed to handle keys hash table */ 
extern struct hash_entry ** hash_table;
extern void init_hash(void);
extern struct hash_entry * hash_add(int uid,char *deskey, void *other_data);
extern struct hash_entry * hash_lookup(int uid);
extern void hash_rem(int uid);

/* Implementation of TCFS ioctl functions. 
   Currently we have to handle some ioctl to put des keys into the
   kernel. Moreover we have to handle some ioctl for the extended 
   attributes. Here we have GETFLAGS and SETFLAGS to handle these
   attributes in a way compatible with the ext2 extended attributes.
   This means that one can use TCFS as a standard NFS file system
   and handle ext2 extended attributes via NFS as they are local.
   When we will develop XATTRD for other filesystem we will make it
   compatible with ext2 way so one can use ext2 extended attrs on
   filesystems other then ext2 !!!! */

int tcfs_ioctl(struct inode * inode, struct file * filp, unsigned int cmd,
unsigned long arg)
{
	static struct login lg;
	static int uid;
	int err=0;
#ifdef TCFS_DES
	des_key_schedule * ks=NULL;
#elif TCFS_IDEA
	idea_key_schedule *ks=NULL;
#elif TCFS_RC5
	rc5_key_schedule *ks=NULL;
#endif
	unsigned int mode;
	struct tcfs_fattr fattr;
	int error;
	
	switch(cmd) {
	case TCFS_IOC_GETFLAGS:
		err = verify_area(VERIFY_WRITE, (int *) arg, sizeof(int));
		if (err)
			return err;
		put_user(inode->u.tcfs_i.tcfs_fl.cflag,(int *) arg);
		return 0;
	case TCFS_IOC_SETFLAGS:
		err = verify_area(VERIFY_READ, (int *) arg, sizeof(int));
		if (err)
			return err;
		memcpy_fromfs(&mode,(unsigned int *)arg,sizeof(int));
		TCFS_SEMW_DOWN(inode);
		err=tcfs_proc_seteattr(inode,&(inode->i_sb->u.tcfs_sb.x_server),inode->u.tcfs_i.pathname,mode,filp);
		TCFS_SEMW_UP(inode);
		error=tcfs_proc_getattr(TCFS_SERVER(inode), TCFS_FH(inode), &fattr);
		if (!error)
			tcfs_refresh_inode(inode,&fattr);
		return err;
	case TCFS_IOC_GETVERSION:  /* For compatibility purpouses */
		 err = verify_area(VERIFY_WRITE, (int *) arg, sizeof(int));
		if (err)
			return err;
		mode=005;
		put_user(&mode,(int *)arg);
	case TCFS_IOC_SETVERSION: /* for compatibility purpouses */
		return 0;
	case TCFS_IOC_LOGIN:
		err = verify_area(VERIFY_READ, (unsigned char *) arg, sizeof(lg));
		if (err) {
			return err;
		}
		memcpy_fromfs(&lg,(struct login *)arg,sizeof(lg));
		/* ARGH ... here we have all we need ... UID, LEN of the deskey and DESKEY
		   We may initialize des and put the structure in a user key cache we have to
		   construct */

#ifdef TCFS_DES
		ks=(des_key_schedule *)kmalloc(sizeof(des_key_schedule),GFP_KERNEL);  
		if (ks==NULL) {
			printk("TCFS: Unable to get a free page\n");
			return -ENOMEM;
		}
		des_set_key((des_cblock *)lg.deskey,*ks);
#elif TCFS_IDEA
		ks=(idea_key_schedule *)kmalloc(sizeof(idea_key_schedule)*2,GFP_KERNEL);
		if (ks==NULL) {
			printk("TCFS: Unable to get a free page\n");
			return -ENOMEM;
		}
		idea_set_key((char*)lg.deskey,*ks);
#elif TCFS_RC5
		ks=(rc5_key_schedule *)kmalloc(sizeof(rc5_key_schedule)*1,GFP_KERNEL);
		if (ks==NULL) {
			printk("TCFS: Unable to get a free page\n");
			return -ENOMEM;
		}
		rc5_setup((char*)lg.deskey,*ks);

#endif

		if (hash_add(lg.uid,lg.deskey,ks)==NULL) {
			kfree(ks);
		}
		return 0;
	case TCFS_IOC_LOGOUT:
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(uid));
		if (err) {
			return err;
		}
		memcpy_fromfs(&uid,(unsigned int *)arg,sizeof(uid));
		hash_rem(uid);
		return 0;
	default:
			return -ENOTTY;
	}
}
