/*
 * T.C.F.S. v. 2.0
 *
 * gettcfskey	Get TCFS User key
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */
#include <stdio.h>
#include <linux/fs.h>
#include <linux/tcfs_fs.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>

#include "kdes.h"
#include "defines.h"

char *gettcfskey (char *login)
{
  FILE *tcfspf;
  int lockfd;
  char lockname[30];
  static char *token[2];
  
  strcpy (lockname, TCFSPWDFILE);
  strcat (lockname, ".lock");

  if ((lockfd=open(lockname, O_RDONLY))!=-1)
    {
      fprintf (stderr, "\nWARNING: tcfs passwd locked!\n");
      exit (1);
    }
  else
    if ((lockfd=open(lockname, O_CREAT))<0)
      {
        perror ("tcfslogin");
        exit (1);
      }

  if ((tcfspf=fopen(TCFSPWDFILE, "r"))==NULL)
    {
      perror ("tcfslogin");
      exit (1);
    }
  
  while (!feof(tcfspf))
    {
      int i;
      char *line;
      
      line=(char*)calloc(25,sizeof(char));
      
      fgets (line, 25, tcfspf);
      if (feof(tcfspf))
	break;
      token[0]=strtok(line, ":");
      token[1]=line+strlen(token[0])+1;
      if (strcmp(login, token[0])==0)
	{
	  fclose (tcfspf);
	  close (lockfd);
  	  unlink (lockname);
	  return token[1];
	}
      free (line);
    }
  
  fclose (tcfspf);
  close (lockfd);
  unlink (lockname);
  return (NULL);
}

