/*
 * T.C.F.S. 2.0 Alpha 1 
 *
 *      	   This  program  handles  RPC  "NFS"  data  requests
 *              adopting a secure transfer protocol.
 *                 This   is  an  unsecure   and  unchecked  version,
 *              use at your own risk.
 *
 *              Please, report Bugs to: <tcfs@edu-gw.dia.unisa.it>
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@edu-gw.dia.unisa.it>
 *		Angelo Celentano, <angcel@edu-gw.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@edu-gw.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@edu-gw.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@edu-gw.dia.unisa.it>
 *
 *   Permission to  use, copy, and modify  this software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies  of  any  software  which  is  or  includes a  copy  or
 * modification of this software and in all copies  of the supporting
 * documentation for such software.
 *
 *   This  software is  distribuited  under  the  GNU General  Public
 * License  (version  2, June  1991). Check  the  file  'COPING'  for
 * more  infos. Some  parts of  this  software  derive  from the  NFS
 * implementation in the Linux kernel 2.0.x.
 *
 * This software  maybe be used  for any  purpose provided  the above
 * copyright  notice  is retained.  It  is  supplied  as is,  with no
 * warranty expressed or implied.
 *
 */

/* -+-_== */

#include <linux/kdes.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/kernel.h>

void mkendes(char *block,int nb,des_key_schedule *ks)
{
	unsigned long * xi;
	int i;
	char *tmp;

	xi=(long *)block;
	tmp=block;
	des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,*ks,DES_ENCRYPT);
	tmp+=8;
	for (i=1;i<nb/8;i++) {
		*(xi+2)^=*xi;
		*(xi+3)^=*(xi+1);
		des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,*ks,DES_ENCRYPT);
		tmp+=8;
		xi+=2;
	}
}

void mkdedes(char *block,int nb,des_key_schedule *ks)
{
	unsigned long * xi,xo[2],xa[2];
	int i;
	char *tmp;

	xi=(long *)block;
	tmp=block;
	xo[0]=*xi; xo[1]=*(xi+1);
	des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,*ks,DES_DECRYPT);
	tmp+=8;
	xi=(long *)tmp;
	for (i=1;i<nb/8;i++) {
		xa[0]=*xi; xa[1]=*(xi+1);
		des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,*ks,DES_DECRYPT);
		*(xi)^=xo[0];
		*(xi+1)^=xo[1];
		xo[0]=xa[0];  
		xo[1]=xa[1];
		tmp+=8;
		xi+=2;
	}
}

void mendes(char *block,int nb,des_key_schedule *ks)
{
	unsigned long xo[2],in[2];
	int i;
	unsigned char *tmp;

	memcpy_fromfs(in,(long *)block,8L);
	tmp=block;
	des_ecb_encrypt((des_cblock *)in,(des_cblock *)in,*ks,DES_ENCRYPT);
	memcpy_tofs((unsigned long *)tmp,in,8L);
	xo[0]=in[0]; xo[1]=in[1];
	tmp+=8;
	for (i=1;i<nb;i++) {
		memcpy_fromfs(in,(unsigned long *)tmp,8L);
		in[0]^=xo[0];
		in[1]^=xo[1];
		des_ecb_encrypt((des_cblock *)in,(des_cblock *)in,*ks,DES_ENCRYPT);
		memcpy_tofs((unsigned long *)tmp,in,8L);
		xo[0]=in[0]; xo[1]=in[1];
		tmp+=8;
	}
}

void mdedes(char *block,int nb,des_key_schedule *ks)
{
	unsigned long xo[2],xa[2],xt[2];
	int i;
	unsigned char *tmp;

	tmp=block;
	memcpy_fromfs(xo,(unsigned long *)tmp,8L);
	xt[0]=xo[0]; xt[1]=xo[1];
	des_ecb_encrypt((des_cblock *)xt,(des_cblock *)xt,*ks,DES_DECRYPT);
	memcpy_tofs((unsigned long *)block,xt,8L);
	tmp+=8;
	for (i=1;i<nb;i++) {
		memcpy_fromfs(xa,(unsigned long *)tmp,8L);
		xt[0]=xa[0]; xt[1]=xa[1];
		des_ecb_encrypt((des_cblock *)xt,(des_cblock *)xt,*ks,DES_DECRYPT);
		xt[0]^=xo[0]; xt[1]^=xo[1];
		memcpy_tofs((unsigned long *)tmp,xt,8L);
		xo[0]=xa[0]; xo[1]=xa[1];
		tmp+=8;
	}
}
