/* ./src/include/global_prototypes.h */

/* 
 *
 * $Id: global_prototypes.h,v 1.14 1995/02/21 14:51:49 surkau Exp $
 *
 * $Log: global_prototypes.h,v $
 *
 */
 
#include <stdio.h>
#ifdef __STDC__
/***************************************************************
 *
 * Headers from file aux/aux_fprint.c
 *
 ***************************************************************/ 
       RC aux_fprint_OctetString(FILE *ff, OctetString	 *ostr);
       RC aux_fprint_BitString(FILE *ff, BitString	 *bstr);
       RC aux_fprint_KeyBits(FILE *ff, KeyBits	 *keybits);
       RC aux_fprint_ObjId(FILE *ff, ObjId	 *objid);
       RC aux_fprint_AlgId(FILE *ff, AlgId	 *aid);
       RC aux_fprint_algorithm(FILE *ff, ObjId	 *objid);
       RC global_fprint_error(FILE	*ff, int	  verbose);
       char *aux_sprint_OctetString(char *string, OctetString	 *ostr);
       char *aux_sprint_BitString(char *string, BitString	 *bstr);
       char *aux_sprint_KeyBits(char *string, KeyBits	 *keybits);
       char *aux_sprint_ObjId(char *string, ObjId	 *objid);
       char *aux_sprint_AlgId(char *string, AlgId	 *aid);
       char *aux_sprint_algorithm(char *string, ObjId	 *objid, char *name);
       char *global_sprint_error(char *string, int	  verbose);
       RC aux_print_OctetString(OctetString	 *ostr);
       RC aux_print_BitString(BitString	 *bstr);
       RC aux_print_KeyBits(KeyBits	 *keybits);
       RC aux_print_ObjId(ObjId	 *objid);
       RC aux_print_AlgId(AlgId	 *aid);
       RC aux_print_algorithm(ObjId	 *objid);
       RC global_print_error(int	  verbose);
/***************************************************************
 *
 * Headers from file crypt/global/PKCS.c
 *
 ***************************************************************/ 
       OctetString	*aux_create_PKCSBlock	(char BT, OctetString *D);
       OctetString	*aux_create_PKCS_MIC_D	(OctetString *hash_result, AlgId *signatureAlgorithm);
/***************************************************************
 *
 * Headers from file aux/aux_free.c
 *
 ***************************************************************/ 
       void	aux_free_OctetString	(OctetString **ostr);
       void	aux_free2_OctetString	(OctetString *ostr);
       void	aux_free_BitString	(BitString **bstr);
       void	aux_free2_BitString	(BitString *bstr);
       void	aux_free_ObjId	(ObjId **oid);
       void	aux_free2_ObjId	(ObjId *oid);
       void	aux_free_AlgId	(AlgId **algid);
       void	aux_free2_KeyInfo	(KeyInfo *p);
       void	aux_free_KeyInfo	(KeyInfo **keyinfo);
       void	aux_free_KeyBits	(KeyBits **keybits);
       void	aux_free2_KeyBits	(KeyBits *p);
       void	aux_free2_AlgId	(AlgId *algid);
/***************************************************************
 *
 * Headers from file aux/aux_xdmp.c
 *
 ***************************************************************/ 
       void	aux_fxdumpp	(FILE *dump_file, char *buffer, int len, int addr_type, Boolean printable);
       void	aux_fxdump	(FILE *dump_file, char *buffer, int len, int addr_type);
       char	*aux_sxdump2	(char *dump_file, char *buffer, int len, int addr_type);
       char	*aux_sxdump	(char *dump_file, char *buffer, int len, int addr_type);
       void	aux_fxdump2	(FILE *dump_file, char *buffer, int len, int addr_type);
       void	aux_xdump	(char *buffer, int len, int addr_type);
       void	aux_xdump2	(char *buffer, int len, int addr_type);


/***************************************************************
 *
 * Headers from file crypt/global/util.c
 *
 ***************************************************************/ 
       ObjId	*aux_cpy_ObjId	(ObjId *oid);
       int	aux_cpy2_ObjId	(ObjId *dup_oid, ObjId *oid);
       int	aux_cmp_ObjId	(ObjId *oid1, ObjId *oid2);
       AlgId	*aux_cpy_AlgId	(AlgId *aid);
       int	aux_cmp_AlgId	(AlgId *aid1, AlgId *aid2);
       int	aux_cmp_KeyBits	(KeyBits *keybits1, KeyBits *keybits);
       KeyInfo	*aux_cpy_KeyInfo	(KeyInfo *keyinfo);
       int	aux_cpy2_KeyInfo	(KeyInfo *dup_ki, KeyInfo *keyinfo);
       int	aux_cmp_BitString	(BitString *bitstring1, BitString *bitstring2);
       int	aux_cmp_KeyInfo	(KeyInfo *keyinfo1, KeyInfo *keyinfo2);
       int	aux_cpy2_OctetString	(OctetString *dup_ostr, OctetString *ostr);
       int	aux_cpy2_BitString	(BitString *dup_bstr, BitString *bstr);
       OctetString	*aux_cpy_OctetString	(OctetString *ostr);
       BitString	*aux_cpy_BitString	(BitString *bstr);
       void	global_add_error	(int number, char *text, char *addr, Struct_No addrtype, char *proc);
       char	*aux_cpy_String	(char *str);
       ObjId	*aux_Name2ObjId	(char *name);
       AlgId	*aux_Name2AlgId	(char *name);
       AlgType	aux_Name2AlgType	(char *name);
       AlgEnc	aux_Name2AlgEnc	(char *name);
       AlgHash	aux_Name2AlgHash	(char *name);
       AlgMode	aux_Name2AlgMode	(char *name);
       AlgSpecial	aux_Name2AlgSpecial	(char *name);
       ParmType	aux_Name2ParmType	(char *name);
       char	*aux_ObjId2Name	(ObjId *given_objid);
       AlgType	aux_ObjId2AlgType	(ObjId *given_objid);
       AlgEnc	aux_ObjId2AlgEnc	(ObjId *given_objid);
       AlgHash	aux_ObjId2AlgHash	(ObjId *given_objid);
       AlgSpecial	aux_ObjId2AlgSpecial	(ObjId *given_objid);
       AlgMode	aux_ObjId2AlgMode	(ObjId *given_objid);
       AlgId	*aux_ObjId2AlgId	(ObjId *given_objid);
       ParmType	aux_ObjId2ParmType	(ObjId *given_objid);
       int       FPRINTF(FILE *ff, char *format, ...);
       char     *CATSPRINTF(char *string, char *format, ...);
       char 	*CATNSTR(char *string, char *, int chars);
#ifndef ntohl
#if SIZEOFLONG == 64
       unsigned int	ntohl(unsigned int x);
#else
       unsigned long	ntohl(unsigned long x);
#endif
#endif
#ifndef htonl
#if SIZEOFLONG == 64
       unsigned int	htonl(unsigned int x);
#else
       unsigned long	htonl(unsigned long x);
#endif
#endif
       KeyInfo	*aux_BitString2EncryptionKey	(AlgId *alg, BitString *bstr);
/***************************************************************
 *
 * Headers from file crypt/global/rand.c
 *
 ***************************************************************/ 
	RC sec_init_random_seed_with_string(char *input);
        RC sec_random_LN(L_NUMBER *ln, unsigned int bits);
        RC sec_init_random(L_NUMBER seed[]);
        RC sec_get_random_seed(L_NUMBER seed[]);
        void sec_random_destroy_seed();
        OctetString *sec_random_ostr(unsigned int noctets);
        BitString *sec_random_bstr(unsigned int nbits);
        char *sec_random_str(int nchars, char *chars);
        RC sec_random_int(int r1, int r2, int *ret);
        RC sec_random_long(long r1, long r2, long *ret);
        RC sec_random_unsigned(unsigned int *ret);


/***************************************************************
 *
 * Headers from file crypt/rsa/rsa.c
 *
 ***************************************************************/ 
       RC	rsa_set_key	(KeyBits *key);
       RC	rsa_encrypt	(OctetString *in, BitString *out, More more, int keysize);
       RC	rsa_decrypt	(BitString *in, OctetString *out, More more, int keysize);
       RC	hash_sqmodn	(OctetString *in, OctetString *sum, More more, int keysize);
       RC	rsa_sign	(OctetString *hash, BitString *sign);
       RC	rsa_verify	(OctetString *hash, BitString *sign);
       RC	rsa_encblock2OctetString	(BitString *sign, OctetString *hash);
/***************************************************************
 *
 * Headers from file crypt/rsa/rsagen.c
 *
 ***************************************************************/ 
       RC	rsa_gen_key	(int keysize, KeyBits **skey, KeyBits **pkey);
/***************************************************************
 *
 * Headers from file crypt/dsa/dsa.c
 *
 ***************************************************************/ 
       RC	dsa_set_key	(OctetString *key, KeyBits *common);
       RC	dsa_sign	(OctetString *hash, KeyBits *sign);
       RC	dsa_verify	(OctetString *hash, KeyBits *sign);
/***************************************************************
 *
 * Headers from file crypt/dsa/dsagen.c
 *
 ***************************************************************/ 
       RC	dsa_gen_key	(OctetString **skey, OctetString **pkey, KeyBits *common);
       KeyBits	*dsa_gen_common	(int keysize);
/***************************************************************
 *
 * Headers from file crypt/des/des.c
 *
 ***************************************************************/ 
       int	desinit	(int mode, Boolean des3);
       int	desdone	(Boolean des3);
       int	setkey_	(char *key);
       int	setkey1	(char *key);
       int	endes	(char *block);
       int	endes1	(char *block);
       int	dedes	(char *block);
       int	dedes1	(char *block);
       long	f	(unsigned long r, unsigned char subkey[8]);
       unsigned long	byteswap	(unsigned long x);
/***************************************************************
 *
 * Headers from file crypt/des/des_if.c
 *
 ***************************************************************/ 
       int	des_encrypt	(OctetString *in_octets, BitString *out_bits, More more, KeyInfo *keyinfo);
       void	endes_cbc	(char *outblock);
       void	endes_ecb	(char *outblock);
       int	des_decrypt	(BitString *in_bits, OctetString *out_octets, More more, KeyInfo *keyinfo);
       void	dedes_cbc	(char *outblock);
       void	dedes_ecb	(char *outblock);
       int	setdoublekey	(char *key);
       int	read_dec	(int fd, char *buf, int len, char *key);
       int	write_enc	(int fd, char *buf, int len, char *key);
       int	close_dec	(int fd);
       int	close_enc	(int fd);
       int	c_desdone	(Boolean des3);
       char	*string_to_key	(char *asckey);
/***************************************************************
 *
 * Headers from file crypt/md/md2_if.c
 *
 ***************************************************************/ 
       RC	md2_hash	(OctetString *in_octets, OctetString *hash_result, More more);
/***************************************************************
 *
 * Headers from file crypt/md/md4_if.c
 *
 ***************************************************************/ 
       RC	md4_hash	(OctetString *in_octets, OctetString *hash_result, More more);
/***************************************************************
 *
 * Headers from file crypt/md/md5_if.c
 *
 ***************************************************************/ 
       RC	md5_hash	(OctetString *in_octets, OctetString *hash_result, More more);
/***************************************************************
 *
 * Headers from file crypt/sha/sha_if.c
 *
 ***************************************************************/ 
       RC	sha_hash	(OctetString *in_octets, OctetString *hash_result, More more);

/***************************************************************
 *
 * Headers from file crypt/dh/dh.c
 *
 ***************************************************************/ 
       AlgId    *dh_init(int size_of_p, int privat_value_length);
       KeyInfo 	*dh_phase1(AlgId *key_pg, KeyInfo **key_x, Boolean	 with_pg);
       BitString *dh_phase2(AlgId *key_pg, KeyInfo *key_x, KeyInfo *peer_y);





#else
/***************************************************************
 *
 * Headers from file aux/aux_fprint.c
 *
 ***************************************************************/ 
       RC aux_fprint_OctetString();
       RC aux_fprint_BitString();
       RC aux_fprint_KeyBits();
       RC aux_fprint_ObjId();
       RC aux_fprint_AlgId();
       RC aux_fprint_algorithm();
       RC global_fprint_error();
       char *aux_sprint_OctetString();
       char *aux_sprint_BitString();
       char *aux_sprint_KeyBits();
       char *aux_sprint_ObjId();
       char *aux_sprint_AlgId();
       char *aux_sprint_algorithm();
       char *global_sprint_error();
       RC aux_print_OctetString();
       RC aux_print_BitString();
       RC aux_print_KeyBits();
       RC aux_print_ObjId();
       RC aux_print_AlgId();
       RC aux_print_algorithm();
       RC global_print_error();
/***************************************************************
 *
 * Headers from file crypt/global/PKCS.c
 *
 ***************************************************************/ 
       OctetString	*aux_create_PKCSBlock	();
       OctetString	*aux_create_PKCS_MIC_D	();
/***************************************************************
 *
 * Headers from file aux/aux_free.c
 *
 ***************************************************************/ 
       void	aux_free_OctetString	();
       void	aux_free2_OctetString	();
       void	aux_free_BitString	();
       void	aux_free2_BitString	();
       void	aux_free_ObjId	();
       void	aux_free2_ObjId	();
       void	aux_free_AlgId	();
       void	aux_free2_KeyInfo	();
       void	aux_free_KeyInfo	();
       void	aux_free_KeyBits	();
       void	aux_free2_KeyBits	();
       void	aux_free2_AlgId	();
/***************************************************************
 *
 * Headers from file aux/aux_xdmp.c
 *
 ***************************************************************/ 
       void	aux_fxdumpp	();
       void	aux_fxdump	();
       char	*aux_sxdump2	();
       char	*aux_sxdump	();
       void	aux_fxdump2	();
       void	aux_xdump	();
       void	aux_xdump2	();


/***************************************************************
 *
 * Headers from file crypt/global/util.c
 *
 ***************************************************************/ 
       ObjId	*aux_cpy_ObjId	();
       int	aux_cpy2_ObjId	();
       int	aux_cmp_ObjId	();
       AlgId	*aux_cpy_AlgId	();
       int	aux_cmp_AlgId	();
       int	aux_cmp_KeyBits	();
       KeyInfo	*aux_cpy_KeyInfo	();
       int	aux_cpy2_KeyInfo	();
       int	aux_cmp_BitString	();
       int	aux_cmp_KeyInfo	();
       int	aux_cpy2_OctetString	();
       int	aux_cpy2_BitString	();
       OctetString	*aux_cpy_OctetString	();
       BitString	*aux_cpy_BitString	();
       void	global_add_error	();
       char	*aux_cpy_String	();
       ObjId	*aux_Name2ObjId	();
       AlgId	*aux_Name2AlgId	();
       AlgType	aux_Name2AlgType	();
       AlgEnc	aux_Name2AlgEnc	();
       AlgHash	aux_Name2AlgHash	();
       AlgMode	aux_Name2AlgMode	();
       AlgSpecial	aux_Name2AlgSpecial	();
       ParmType	aux_Name2ParmType	();
       char	*aux_ObjId2Name	();
       AlgType	aux_ObjId2AlgType	();
       AlgEnc	aux_ObjId2AlgEnc	();
       AlgHash	aux_ObjId2AlgHash	();
       AlgSpecial	aux_ObjId2AlgSpecial	();
       AlgMode	aux_ObjId2AlgMode	();
       AlgId	*aux_ObjId2AlgId	();
       ParmType	aux_ObjId2ParmType	();
       int       FPRINTF();
       char     *CATSPRINTF();
       char 	*CATNSTR();
#ifndef ntohl
#if SIZEOFLONG == 64
       unsigned int	ntohl();
#else
       unsigned long	ntohl();
#endif
#endif
#ifndef htonl
#if SIZEOFLONG == 64
       unsigned int	htonl();
#else
       unsigned long	htonl();
#endif
#endif
       KeyInfo	*aux_BitString2EncryptionKey	();


/***************************************************************
 *
 * Headers from file crypt/global/rand.c
 *
 ***************************************************************/ 
	RC sec_init_random_seed_with_string();
        RC sec_random_LN();
        RC sec_init_random();
        RC sec_get_random_seed();
        void sec_random_destroy_seed();
        OctetString *sec_random_ostr();
        BitString *sec_random_bstr();
        char *sec_random_str();
        RC sec_random_int();
        RC sec_random_long();
        RC sec_random_unsigned();

/***************************************************************
 *
 * Headers from file crypt/rsa/rsa.c
 *
 ***************************************************************/ 
       RC	rsa_set_key	();
       RC	rsa_encrypt	();
       RC	rsa_decrypt	();
       RC	hash_sqmodn	();
       RC	rsa_sign	();
       RC	rsa_verify	();
       RC	rsa_encblock2OctetString	();
/***************************************************************
 *
 * Headers from file crypt/rsa/rsagen.c
 *
 ***************************************************************/ 
       RC	rsa_gen_key	();
/***************************************************************
 *
 * Headers from file crypt/dsa/dsa.c
 *
 ***************************************************************/ 
       RC	dsa_set_key	();
       RC	dsa_sign	();
       RC	dsa_verify	();
/***************************************************************
 *
 * Headers from file crypt/dsa/dsagen.c
 *
 ***************************************************************/ 
       RC	dsa_gen_key	();
       KeyBits	*dsa_gen_common	();
/***************************************************************
 *
 * Headers from file crypt/des/des.c
 *
 ***************************************************************/ 
       int	desinit	();
       int	desdone	();
       int	setkey_	();
       int	setkey1	();
       int	endes	();
       int	endes1	();
       int	dedes	();
       int	dedes1	();
       long	f	();
       unsigned long	byteswap	();
/***************************************************************
 *
 * Headers from file crypt/des/des_if.c
 *
 ***************************************************************/ 
       int	des_encrypt	();
       void	endes_cbc	();
       void	endes_ecb	();
       int	des_decrypt	();
       void	dedes_cbc	();
       void	dedes_ecb	();
       int	setdoublekey	();
       int	read_dec	();
       int	write_enc	();
       int	close_dec	();
       int	close_enc	();
       int	c_desdone	();
       char	*string_to_key	();
/***************************************************************
 *
 * Headers from file crypt/md/md2_if.c
 *
 ***************************************************************/ 
       RC	md2_hash	();
/***************************************************************
 *
 * Headers from file crypt/md/md4_if.c
 *
 ***************************************************************/ 
       RC	md4_hash	();
/***************************************************************
 *
 * Headers from file crypt/md/md5_if.c
 *
 ***************************************************************/ 
       RC	md5_hash	();
/***************************************************************
 *
 * Headers from file crypt/sha/sha_if.c
 *
 ***************************************************************/ 
       RC	sha_hash	();

/***************************************************************
 *
 * Headers from file crypt/dh/dh.c
 *
 ***************************************************************/ 
       AlgId    *dh_init();
       KeyInfo 	*dh_phase1();
       BitString *dh_phase2();






#endif
