/*
 * T.C.F.S. Utils 2.0 $Revision: 1.13 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /usr/src/linux-2.0.33.SuSE/fs/tcfs/contrib/utils/lib/RCS/tcfs_keymaint.c,v $
 *        $State: Exp $
 *
 *     $Revision: 1.13 $
 *       $Author: anidel $
 *         $Date: 1998/06/19 08:15:56 $
 *       $Locker:  $
 */

static const char *RCSid="$Id: tcfs_keymaint.c,v 1.13 1998/06/19 08:15:56 anidel Exp $";
/* -+-_== */ 

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <mntent.h>
#include <errno.h>
#include <pwd.h>
#include <syslog.h>

#include <linux/kdes.h>
#include "tcfslib.h"
#include <sys/types.h>

#if defined (__GLIBC__)
#define _LINUX_SOCKET_H
#endif
#define _I386_BITOPS_H
#include <linux/fs.h>
#include <linux/tcfs_fs.h>

int 
tcfs_decrypt_key (char *u, char *pwd, char *t, char **tk)
{
  int len, i = 0;
  char pass[_PASSWORD_LEN], *cypher;
  static char *tcfskey;
  des_key_schedule ks;

  memcpy (pass, pwd, _PASSWORD_LEN);

  tcfskey = tcfs_decode (t, &len);

  while (strlen (pass) < 8)
    {
      char tmp[_PASSWORD_LEN];
      strcpy (tmp, pass);
      strcat (tmp, pass);
      strcat (pass, tmp);
    }

  while ((i * 8) <= KEYSIZE)
    {
      des_set_key ((des_cblock *) pass, ks);

      des_ecb_encrypt ((des_cblock *) (tcfskey + i * 8),
		       (des_cblock *) (tcfskey + i * 8), ks, DES_DECRYPT);
      i++;
    }
  bzero (pass, strlen (pass));

  memcpy (*tk, tcfskey, KEYSIZE);
  return 1;
}

int 
tcfs_encrypt_key (char *u, char *pw, char *key, char **ek)
{
  int i = 0;
  char pass[_PASSWORD_LEN];
  static char *tcfskey;
  des_key_schedule ks;

  memcpy (pass, pw, _PASSWORD_LEN);

  while (strlen(pass)<8)
    {
      char tmp[_PASSWORD_LEN];
      
      strcpy (tmp, pass);
      strcat (tmp, pass);
      strcat (pass, tmp);
    }

  while ((i * 8) <= KEYSIZE)
    {
      des_set_key ((des_cblock *) pass, ks);
      des_ecb_encrypt ((des_cblock *) (key + i * 8), (des_cblock *) (key + i * 8), ks, DES_ENCRYPT);
      i++;
    }

  tcfskey = tcfs_encode (key, KEYSIZE);
  memcpy (*ek, tcfskey, UUKEYSIZE);

  return 1;
}



int 
tcfs_callfunction (int function, char *arg, char *filesystem, char *filename)
{
  FILE *mtab;
  int fd, s = 0;
  struct mntent *mp;
  int val;

  if ((mtab = setmntent ("/etc/mtab", "r")) == NULL)
    return 0;

  while ((mp = getmntent (mtab)) != NULL)
    {
      if (strcmp (mp->mnt_type, "tcfs") == 0 /* && check di quale fs e'.. */ )
	{
	  if ((fd = open (mp->mnt_dir, O_RDONLY)) < 0)
	    return 0;
	  else
	    {
	      val=ioctl (fd, function, arg);
	      if(val >= 0) s++;
	    }
	  close (fd);
	}
    }
  endmntent (mtab);
  if (s == 0)
    {
      syslog (LOG_WARNING, "No tcfs filesystem mounted or no key present");
      return 0;
    }
  else
    return 1;
}

int 
tcfs_enable (char *u, char *tcfskey)
{
  struct login user;

  memcpy (user.deskey, tcfskey, KEYSIZE);
  user.uid = (getpwnam (u)->pw_uid);
  return tcfs_callfunction (TCFS_IOC_LOGIN, (char *) &user, NULL, NULL);
}

int 
tcfs_disable (char *u, int flags)
{
  int user;

  user = (getpwnam (u)->pw_uid);
  return tcfs_callfunction ((flags==ONE)?TCFS_IOC_LOGOUT:TCFS_IOC_FULLOUT, (char *) &user, NULL, NULL);
}

int tcfs_permanent (char *u, int flags)
{
	int user;

	user=(getpwnam(u)->pw_uid);
	
	return tcfs_callfunction ((flags==SET)?TCFS_IOC_SETFIX:TCFS_IOC_DELFIX, (char *)&user, NULL, NULL);
}

int tcfs_getcount (char *u)
{
	int count=0;

	if(!tcfs_callfunction (TCFS_IOC_GETCOUNT, (char *)&count, NULL, NULL))
		return -1;
	else 
		return count;
}

int tcfs_getpermanent (char *u)
{
	/* TCFS_IOC_GETFIX vuole un unsigned char altrimenti ci crea casini  
		tutto dipende da ioctl.c dove qualcuno ha usato un 
		unsigned char per he->permanent che e' il campo dove viene 
		conservato il flag di permanente 				*/

	unsigned char flag;

	if(!tcfs_callfunction (TCFS_IOC_GETFIX, (char *)&flag, NULL, NULL))
		return -1;
	else 
		return (int) flag;
	
}

int tcfs_enable_default(char *u, char *p)
{
	char *tkey;
	int i;
	static struct tcfspwdb_r t;

	if(!tcfs_getpwnam(u,&t))
		 return 0;

	tkey=(char*)malloc(KEYSIZE);

	if (!tkey)
		 return 0;

	tcfs_decrypt_key(u,p,t.upw,&tkey);
	 
	i=tcfs_enable(u,tkey);
	if (!i)
		{
		 free(tkey);
		 return 0;
		}

	free(tkey);
	return i;
}
