/*
 * T.C.F.S. Utils 2.0 $Revision: 1.12 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /usr/src/linux-2.0.33-tcfs/fs/tcfs/contrib/utils/src/RCS/tcfsgenkey.c,v $
 *        $State: Exp $
 *
 *     $Revision: 1.12 $
 *       $Author: anidel $
 *         $Date: 1998/01/19 14:12:28 $
 *       $Locker:  $
 */

static const char *RCSid="$Id: tcfsgenkey.c,v 1.12 1998/01/19 14:12:28 anidel Exp $";
/* -+-_== */ 

/* Thanks to Usui Takayuki (takajuki@satan.genesis.ne.jp) for the
 * Shadow Password support
 */

#include <stdio.h>
#include <strings.h>
#include <getopt.h>

#include "tcfserrors.h"
#include "tcfslib.h"

static struct option long_options[]=
{
	{ "help", 0, NULL, 'h' },
	{ "force", 0, NULL, 'f' },
	{ 0, 0, 0, 0 }
};

char *usage="Usage: %s [OPTION]
Generate TCFS key and add it to the TCFS database.

  -h [--help]      Shows this help\n";

int main (int argn, char *argv[])
{
	int index, val;
	char *user, *passwd;
	tcfspwdb *userinfo;
	char *newkey, *cryptedkey;

	/*
	 * Going to check arguments
	 */
	while ((val=getopt_long (argn, argv, "h", long_options, &index))!=EOF)
		switch (val)
		{
			case 'h':
				show_usage(usage, argv[0]);
				exit (OK);
				break; /* Useless code */
			default:
				exit (ER_UNKOPT);
				break;
		}

	if (argn-optind)
		tcfs_error (ER_UNKOPT, NULL);

	/*
	 * Must be root to do all this stuff
	 */
	if (geteuid())
		tcfs_error (ER_CUSTOM, "I don't have root privileges!\n");

	/*
	 * Authenticate user
	 */
	unix_auth (&user, &passwd);

	/*
	 * Generate a new key for the user.
	 */
	printf ("Please, press 10 random keys, so we can create a new key for you:\n");
	newkey=gentcfskey ();

	/*
	 * Encrypt the generated key with user password
	 */
	cryptedkey=(char*)calloc(UUKEYSIZE, sizeof(char));
	if (!cryptedkey)
		tcfs_error (ER_MEM, NULL);

	
	if (!tcfs_encrypt_key (user, passwd, newkey, &cryptedkey))
		tcfs_error (ER_MEM, NULL);

	/*
	 * Update TCFS key database
	 */
	if (!tcfspwdbr_new (&userinfo))
		tcfs_error (ER_MEM, NULL);

	if (!tcfspwdbr_edit (userinfo, F_USR|F_PWD, user, cryptedkey))
		tcfs_error (ER_MEM, NULL);

/* TODO:
	if (!change && tcfs_getpwnam (user, userinfo))
		tcfs_error (ER_CUSTOM, "Use -c to change the key.");
*/

	if (!tcfs_putpwnam (user, userinfo, U_CHG))
		tcfs_error (ER_CUSTOM, "Error: cannot generate key.");

	tcfs_error (ER_CUSTOM, "\nKey generated successfully.");
}
