/* RC5 */

#include<linux/autoconf.h>

#ifdef TCFS_RC5

#include <linux/rc5.h>

/*WORD S[t];*/

WORD P = 0xb7e15163, Q = 0x9e3779b9;

#define ROTL(x, y)	(((x)<<(y&(rc5_w-1)))|((x)>>(rc5_w-(y&(rc5_w-1)))))
#define ROTR(x, y)	(((x)>>(y&(rc5_w-1)))|((x)<<(rc5_w-(y&(rc5_w-1)))))

void rc5_encrypt (WORD *pt, WORD *ct, WORD *SU)
{
 WORD i, A=pt[0]+SU[0], B=pt[1]+SU[1];
 
 for (i=1;i<=rc5_r;i++)
  {
   A=ROTL(A^B, B)+SU[2*i];
   B=ROTL(B^A, A)+SU[2*i+1];
  }
 
 ct[0]=A;
 ct[1]=B;
}

void rc5_decrypt (WORD *ct, WORD *pt, WORD *SU)
{
 WORD i, B=ct[1], A=ct[0];

 for (i=rc5_r;i>0;i--)
  {
   B=ROTR(B-SU[2*i+1], A)^A;
   A=ROTR(A-SU[2*i], B)^B;
  }

 pt[1]=B-SU[1];
 pt[0]=A-SU[0];
}

void rc5_setup (unsigned char *K, WORD * SU)
{
 WORD i, j, k, u=rc5_w/8, A, B, L[rc5_c];

 for (i=rc5_b-1, L[rc5_c-1]=0; i!=-1; i--)
  L[i/u]=(L[i/u]<<8)+K[i];

 for (SU[0]=P,i=1;i<rc5_t;i++)
  SU[i]=SU[i-1]+Q;

 for (A=B=i=j=k=0;k<3*rc5_t;k++, i=(i+1)%rc5_t, j=(j+1)%rc5_c)
  {
   A=SU[i]=ROTL(SU[i]+(A+B),3);
   B=L[j]=ROTL(L[j]+(A+B), (A+B));
  }
}

#endif
