#define __NO_VERSION__
#include <linux/module.h>
#include <linux/tcfs/tcfsapi.h>

void tcfs_register_cipher (char *cipher, struct tcfs_cipher_operations *cipher_ops);
void tcfs_unregister_cipher (char *cipher);

static struct symbol_table tcfs_syms={
#include <linux/symtab_begin.h>
	X(tcfs_register_cipher),
	X(tcfs_unregister_cipher),
#include <linux/symtab_end.h>
};

void init_tcfs_syms (void)
{
	register_symtab (&tcfs_syms);
}
