/* pgg.c - Initializes PGG
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pgg.h>
#include <pggdebug.h>




void pgg_errenv_reset(PggErrenv errenv)
{
    if (errenv) {
        errenv->error = PGG_ERROR_SUCCESS;
        errenv->suberr = PGG_SUBERR_NONE;
    }
}


PggError pgg_errenv_get_error(PggErrenv errenv)
{
    return !errenv ? PGG_ERROR_ARGUMENT : errenv->error;
}


PggSuberr pgg_errenv_get_suberr(PggErrenv errenv)
{
    return !errenv ? PGG_SUBERR_NULLPTR : errenv->suberr;
}


void pgg_errenv_set(PggErrenv errenv, PggError error, PggSuberr suberr)
{
    if (errenv && error != PGG_ERROR_SUCCESS) {
        errenv->error = error;
        errenv->suberr = suberr;
    }
}


int pgg_errenv_is_set(PggErrenv errenv)
{
    return !errenv || errenv->error != PGG_ERROR_SUCCESS ? 1 : 0;
}


void pgg_errenv_copy(PggErrenv dest, PggErrenv source)
{
    if (!dest || !source)
        return;
    
    dest->error = source->error;
    dest->suberr = source->suberr;
}


