/* pggexe.h - GnuPG execution headers
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef PGG_INCLUDE_PGGEXE_H_19990604231409
#define PGG_INCLUDE_PGGEXE_H_19990604231409


#include <unistd.h>

#include <pgg.h>
#include <pggimpl.h>


_mktype(PggExe)
{
    unsigned long	magic;
    int			refcounter;
    int			state;
    char **		argv;
    int			argv_used;
    int			argv_capacity;
    pid_t		child_pid;		/* PID used during GnuPG execution */
    int			child_status;		/* Return status of GnuPG */
    int			child_status_pipe[2];	/* pipe used for status messages */
    int			child_stdin_pipe[2];	/* pipe used as stdin for GnuPG */
    int			child_stdout_pipe[2];	/* pipe used as stdout for GnuPG */
    int			use_status;
    int			use_shm;
    char *		status_buffer;		/* A buffer for reading status messages */
    int			status_buffer_size;	/* Size of the status_buffer */
    int			status_buffer_used;	/* used amount of the status buffer */
    PggExe_Status	status_code;
    char *		status_arg;		/* The argument of a status message */
    char *		shm_buf;
    int			shm_size;
    PggExe_ReadCB	reader;
    PggExe_WriteCB	writer;
    void *		reader_opaque;
    void *		writer_opaque;
    char *		read_buffer;
    char *		write_buffer;
    long		write_buffer_used;
    char *		gpgpath;
};


_mktypeptr(PggExe);


#define PggExeMAGIC 0xFF0F0499

#endif





