#!/bin/sh
export PGPPATH=.
export PGPPASS=testpass
export USEPASS="-p testpass"

echo ========== Generating key:
#needs existing pubring.pkr with good parameters in the first key.
#I could use newkeygen, but it takes a while...

if [ -s pubring.pkr ] ; then
    ./newkey5 -K 0 -k 0 -r pubring.pkr -u "Test Key" $USEPASS
else
    ./newkey5 -g 768 -u "Test Key" $USEPASS
fi

#this probably should be a cat, but...
mv pubnew.pkr pubring.pkr
mv secnew.skr secring.skr

#fix pubring to allow encryption
./lookup5 -x -m Test | ./minipgp5 -3 -t 24 $USEPASS >>pubring.pkr
echo -ne "\260\001\147" >>pubring.pkr
#strictly, you also need to use pgpk -s to sign the DSS key on the pubring

#add a V4 RSA key
./newkey5 -R -g 512 -u "RSAKey"
./lookup5 -x -m RSA | ./minipgp5 -3 -t 24 $USEPASS >>pubnew.pkr
echo -ne "\260\001\147" >>pubnew.pkr
cat pubnew.pkr >>pubring.pkr
cat secnew.skr >>secring.skr
rm -f putnew.pkr secnew.skr

pgpk -l

echo ========== Encrypt test

cat newkey5 | ./minipgp5 -l wrx | ./minipgp5 -z | \
  ./minipgp5 -k 0 >wrx.enc
rm -f wrx
pgpv wrx.enc
if cmp wrx newkey5; then echo quick encrypt ok; else exit 0; fi
rm wrx

echo ========== Encrypt and One pass sig test

for pka in 1 16; do
    for siga in 1 17 16; do
        for hash in 1 2 3; do
            for alg in 1 2 3; do
                echo
                echo testing pkenc $pka convenc $alg, hash $hash, sig $siga
                cat newkey5 | ./minipgp5 -l wrx >wrx.one
                ./minipgp5 -1 -A $siga -a $hash -t 1 $USEPASS >wrx.pre
                ./minipgp5 -3 -A $siga -a $hash -t 1 $USEPASS <newkey5 >wrx.two
                cat wrx.pre wrx.one wrx.two | ./minipgp5 -z | \
                ./minipgp5 -k 0 -a $alg -A $pka >wrx.enc
                rm -f wrx wrx.pre wrx.one wrx.two
                pgpv wrx.enc -o wrx

                if cmp wrx newkey5 ; then echo pgp decrypt ok; else exit 0; fi
                ./minipgp5 <wrx.enc $USEPASS | ./minipgp5  | ./minipgp5 >wry.out
                if cmp wry.out newkey5 ; then echo decrypt ok; else exit 0; fi
            done
        done
    done
done
rm wrx wry.out

echo ========== Detached Signature test

for siga in 1 16 17; do
    for hash in 1 2 3; do
        ./minipgp5 -3 <minipgp5 >minipgp5.sig $USEPASS -a $hash -A $siga
        ./minipgp5 <minipgp5 -v minipgp5.sig
        pgpv minipgp5.sig
    done
done

rm minipgp5.sig

echo ========== Decrypt test
#this fixes pgpe
./newkey5 -K 0 -k 0 -r pubring.pkr -u "Second Key" #$USEPASS
pgpk -a pubnew.pkr

rm -f wrx.out
pgpe newkey5 -r Test -s -u Test -o wrx.out
./minipgp5 <wrx.out $USEPASS | ./minipgp5 | ./minipgp5 >wry.out
if cmp wry.out newkey5; then echo our decrypt ok; else exit 0; fi
rm wry.out
