#include <stdio.h>
#include <string.h>
#include "libopgp.h"

long unm2buf(FILE *, char *);

/*-------------------------*/
int main(int argc, char *argv[])
{
  unsigned char dbuf[4096], *bp;
  int j, k;
  keyid_t keyid = 0;
  FILE *inf = stdin;

  do {
    while (!feof(inf)) {
      fgets(dbuf, 4095, inf);
      if (!strncmp(dbuf, "-----BEGIN PGP SIGNED MESSAGE-----", 34))
        break;
    }
    if (feof(inf))
      break;
    while (!feof(inf)) {        /* doubled - don't hash last TWO lines */
      fgets(dbuf, 4095, inf);
      if (!strncmp(dbuf, "-----BEGIN PGP SIGNATURE-----", 29))
        break;
    }
    while (dbuf[0] != '\n' && dbuf[0] != '\r')
      fgets(dbuf, 4095, inf);
    if (unm2buf(inf, dbuf) != unm2buf(inf, NULL))
      continue;
    bp = dbuf;
    j = *bp++;
    bp += j > 0xbf ? 1 : 1 << (j & 3);
    j = *bp++;
    if (j == 3) {
      j = *bp++;
      bp += j;
      for (j = 0; j < 8; j++)
        keyid = (keyid << 8) + *bp++;
    } else if (j == 4) {
      bp += 3;
      j = *bp++ * 256, j += *bp++;
      memmove(dbuf, bp, j);
      bp += j;
      k = *bp++ * 256, k += *bp++;
      memmove(&dbuf[j], bp, k);
      j += k;
      bp = dbuf;
      while (j > 0) {
        if ((bp[1] & 0x7f) == 0x10)
          for (k = 2; k < 10; k++)
            keyid = (keyid << 8) + bp[k];
        j -= *bp + 1;
        bp += *bp + 1;
      }
    }
    if (!PGP_gtkey(NULL, NULL, &keyid))
      fprintf(stdout, "%016qX\n", keyid);
  }
  while (!feof(inf));
  return 0;
}
