#include <stdio.h>
#include <string.h>
#include "libopgp.h"

long unm2buf(FILE *, char *);
void fixstr(char *);

/*-------------------------*/
int main(int argc, char *argv[])
{
  unsigned char dbuf[4096], xbuf[4096], *bp;
  int cnt, ret = 0;
  void *hctx;
  FILE *inf = stdin, *outf = stdout;

  if (argc > 1) {
    if (argv[1][0] != '-' && !(inf = fopen(argv[1], "r")))
      exit(-1);
    else
      outf = NULL;
  }
  do {
    while (!feof(inf))
      if (!fgets(dbuf, 4095, inf) ||
          !strncmp(dbuf, "-----BEGIN PGP SIGNED MESSAGE-----", 34))
        break;
      else if (outf)
        fputs(dbuf, outf);
    if (feof(inf))
      break;
    cnt = 1;                    /* default hash */
    while (dbuf[0] != '\n' && dbuf[0] != '\r') {
      fgets(dbuf, 4095, inf);
      if (!strstr(dbuf, "Hash:"))
        continue;
      if (strstr(dbuf, "SHA1"))
        cnt = 2;
      else if (strstr(dbuf, "RIPEMD160"))
        cnt = 3;
      else if (strstr(dbuf, "HAVAL"))
        cnt = 4;
      else if (strstr(dbuf, "MD2"))
        cnt = 5;
    }
    hctx = PGP_hini(cnt);
    xbuf[0] = 0;
    cnt = 0;
    bp = dbuf;
    while (!feof(inf)) {        /* doubled - don't hash last TWO lines */
      fgets(bp, 4095, inf);
      fixstr(bp);
      if (!strncmp(bp, "-----BEGIN PGP SIGNATURE-----", 29))
        break;
      bp = cnt++ & 1 ? xbuf : dbuf;
      PGP_hblk(hctx, bp, strlen(bp));
      if (*bp) {
        bp[strlen(bp) - 1] = 0;
        bp[strlen(bp) - 1] = '\n';
      }
      if (outf)
        fputs(bp, outf);
    }
    while (bp[0] != '\n' && bp[0] != '\r')
      fgets(bp, 4095, inf);
    if (unm2buf(inf, xbuf) != unm2buf(inf, NULL)) {
      fprintf(stderr, "*** Bad Signature Armor\n");
      fprintf(stdout, "*** Bad Signature Armor\n");
      continue;
    }
    if ((cnt = PGP_sigck(&xbuf[1 + (1 << (xbuf[0] & 3))], hctx))) {
      /* -5 no key, -1 bad hash */
      fprintf(stderr, "*** FAILED SIGNATURE %d\n", cnt);
      fprintf(stdout, "*** FAILED SIGNATURE %d\n", cnt);
    } else
      fprintf(stdout, "*** Good PGP Signature ***\n");
    while (!feof(inf))
      if (!fgets(bp, 4095, inf) ||
          !strncmp(bp, "-----END PGP SIGNATURE-----", 27))
        break;
    ret |= cnt;
  } while (!feof(inf));
  return ret;
}
