#include <stdlib.h>
#include <time.h>
#include "libopgp.h"
#include <rsa.h>
#include <dh.h>
#include <dsa.h>

#define BSZ 8
/*-------------------------*/
static int write_BN(UCHAR ** sp, BIGNUM * bnptr)
{
  int i;

  i = BN_num_bits(bnptr);
  *(*sp)++ = i >> 8, *(*sp)++ = i;
  i = BN_bn2bin(bnptr, *sp);
  *sp += i;
  return i + 2;
}

/*------------------------------------------------------------------------*/
int PGP_wrkey(UCHAR * buf, void *key, int sec, int prim, int alg,
              UCHAR * passph, char *userid)
{
  UCHAR *pp, *cp, *icp, keyctb[] =
  {0xb9, 0x9d, 0x99, 0x95};
  unsigned long i, len, v3flg;
  DH *newkey = key;
  DSA *newsig = key;
#ifndef NO_RSA
  RSA *rsakey = key;
#endif

  v3flg = alg >> 8;
  alg &= 0xff;
  pp = buf;
  *pp++ = keyctb[prim * 2 + sec];
  cp = pp;
  pp += 2;
  *pp++ = v3flg ? 3 : 4;
  i = time(NULL);               /* timestamp */
  *pp++ = i >> 24, *pp++ = i >> 16, *pp++ = i >> 8, *pp++ = i;
  len = 6;
  if (v3flg)
    *pp++ = 0, *pp++ = 0, len += 2;
  *pp++ = alg;
  switch (alg) {
#ifndef NO_RSA
  case 1:
    len += write_BN(&pp, rsakey->n);
    len += write_BN(&pp, rsakey->e);
    break;
#endif
  case 17:
    len += write_BN(&pp, newsig->p);
    len += write_BN(&pp, newsig->q);
    len += write_BN(&pp, newsig->g);
    len += write_BN(&pp, newsig->pub_key);
    break;
  case 16:
  case 20:
    len += write_BN(&pp, newkey->p);
    len += write_BN(&pp, newkey->g);
    len += write_BN(&pp, newkey->pub_key);
    break;
  }
  if (sec) {
    void *cfbc;
    i = PGP_wrs2k(pp, passph, v3flg ? 1 : 0xff, &cfbc);
    pp += i, len += i;
    cp = pp;                    /* mark start of crypt/checksum */
    switch (alg) {
#ifndef NO_RSA
    case 1:
      len += write_BN(&pp, rsakey->d);
      len += write_BN(&pp, rsakey->q);
      len += write_BN(&pp, rsakey->p);
      len += write_BN(&pp, rsakey->iqmp);
      RSA_free(rsakey);
      break;
#endif
    case 17:
      len += write_BN(&pp, newsig->priv_key);
      DSA_free(newsig);
      break;
    case 16:
      len += write_BN(&pp, newkey->priv_key);
      DH_free(newkey);
      break;
    }
    /* compute checksum */
    icp = cp, i = 0;
    while (icp != pp)
      i += *icp++;
    *pp++ = i >> 8, *pp++ = i, len += 2;
    if (cfbc) {                 /* passphrase encrypt secret portions of key */
      if (v3flg)
        while (cp != pp - 2) {
          i = *cp++ * 256, i += *cp++, i = (i + 7) / 8;
          PGP_cblk(cp, i, cfbc), PGP_cres(&cp[i - BSZ], cfbc);
          cp += i;
      } else
        PGP_cblk(cp, pp - cp, cfbc);
      free(cfbc);
    }
  }
  buf[1] = len >> 8, buf[2] = len;
  if (!sec)
    *pp++ = 0xb0, *pp++ = 0x01, *pp++ = 0x87;
  if (prim && userid) {
    *pp++ = 0xb4, *pp++ = strlen(userid);
    memcpy(pp, userid, strlen(userid));
    pp += strlen(userid);
    if (!sec && userid)
      *pp++ = 0xb0, *pp++ = 0x01, *pp++ = 0x03;
  }
  return (pp - buf);
}
