#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "libopgp.h"
#include <rsa.h>
#include <dh.h>
#include <dsa.h>

/*------------------------------------*/
int main(int argc, char *argv[])
{
  unsigned char *bp0, *bp, t, *sp = NULL;
  unsigned long i, ll;
  int j;
  DSA *dsakey = DSA_new();
  DH *dhkey = DH_new();
  keyid_t oldkid = 0;
  FILE *outf = stdout;
  extern char *optarg;
#ifndef NO_RSA
  RSA *rsakey = RSA_new();
#endif

  while ((i = getopt(argc, argv, "o:r:")) != -1) {
    if (i == 'r')
      PGP_ringf = fopen(optarg, "rb");
    else if (i == 'o') {
      outf = fopen(optarg, "wb");
      if (outf == NULL)
        exit(-1);
    } else {
      fprintf(stderr, "usage: ringscan [-r ring]\n");
      exit(-1);
    }
  }
  bp0 = malloc(2048);
  if (!PGP_ringf && (bp = getenv("PGPPATH"))) {  /* if no PGP_ringf, try PGPPATH */
    strncpy(bp0, bp, 2000);
    strcat(bp0, "/pubring.pkr");
    PGP_ringf = fopen(bp0, "rb");
  }
  if (!PGP_ringf && (bp = getenv("HOME"))) {  /* no, try default from HOME */
    strncpy(bp0, bp, 2000);
    strcat(bp0, "/.pgp/pubring.pkr");
    PGP_ringf = fopen(bp0, "rb");
  }
  if (!PGP_ringf)
    return -3;                  /* no keyring */
  free(bp0);

  while (!feof(PGP_ringf)) {
    t = fgetc(PGP_ringf);
    if (!(bp = PGP_gtpkt(PGP_ringf, t, &j)))
      break;
    bp0 = bp;
    t = (t & 0x7c) >> 2;
    switch (t) {
    case 2:                    /* sig */
      fprintf(outf, "sig\n");
      continue;
    case 12:                   /* validity */
      fprintf(outf, "val %02x\n", *bp);
      continue;
    case 13:                   /* uid - should match */
      fprintf(outf, "uid %s\n", bp);
      continue;
    case 5:
    case 6:
    case 7:
    case 14:
      switch (t) {
      case 5:
        sp = "KEY";
        break;
      case 6:
        sp = "key";
        break;
      case 7:
        sp = "SUB";
        break;
      case 14:
        sp = "sub";
        break;
      }
      j = *bp++;                /* vers */
      /* timestamp */
      ll = *bp++ << 24, ll += *bp++ << 16, ll += *bp++ << 8, ll += *bp++;
      if (j != 4)
        bp += 2;                /* old valid days */
      switch (*bp++) {
      case 17:
        dsakey->p = PGP_mpiBN(&bp), dsakey->q = PGP_mpiBN(&bp);
        dsakey->g = PGP_mpiBN(&bp);
        dsakey->pub_key = PGP_mpiBN(&bp);
        fprintf(outf, "%s %016qX DSA\n", sp, PGP_gkid(bp0, bp - bp0));
        break;
      case 16:
      case 20:
        dhkey->p = PGP_mpiBN(&bp), dhkey->g = PGP_mpiBN(&bp);
        dhkey->pub_key = PGP_mpiBN(&bp);

        fprintf(outf, "%s %016qX DH\n", sp, PGP_gkid(bp0, bp - bp0));
        break;
#ifndef NO_RSA
      case 1:
      case 2:
      case 3:
        rsakey->n = PGP_mpiBN(&bp), rsakey->e = PGP_mpiBN(&bp);
        j = 64;
        oldkid = 0;
        while (j)
          oldkid = (oldkid << 1) + BN_is_bit_set(rsakey->n, --j);
        fprintf(outf, "%s %016qX RSA %016qX (v4)\n", sp, oldkid,
                PGP_gkid(bp0, bp - bp0));
        break;
#endif
      }
      break;
    default:
      fprintf(outf, "??? %d\n", t);
    }
    if (bp0)
      free(bp0);
  }
  return -4;                    /* not found */
}
