#!/bin/sh

export PGPPATH=.
export PGPPASS=testpass
export USEPASS="-p testpass"

RSABITS=512

PKALGS=16
SIGALGS=17
CONVALGS="1 2 3"
HASHALGS="1 2 3"
SALTALGS="3 1 0"
SIGTS=-1
DSIGTS=-3

echo "PGP Type, (n)o pgp5, (b)ase pgp5, (r)sa pgp5, (2).62 compat"
read i

if [ $i = "2" ]; then
rm -f tstf*
cp README tstf.pro
cp tstf.pro tstf.ret
if [ ! -e randseed.bin ] ; then cp test.sh randseed.bin; fi

rm -f pubring.pgp secring.pgp tstf.pro.asc tstf.ret

./newkey -g $RSABITS -3
mv secnew.skr secnew.pgp
mv pubnew.pkr pubnew.pgp
cp secnew.pgp secring.skr
mv pubring.pkr pubring.sav
cp pubnew.pgp pubring.pkr
RSAKEY=`./ringscan | grep RSA | cut -c 5-21`

pgp -ka secnew.pgp +batchmode +verbose=0 >tstf.log
pgp -ka pubnew.pgp +batchmode +verbose=0 >tstf.log
./lookup -z -o testfpb1.pgp
./lookup -y -o testfpb2.pgp



./opgp -3 -i testfpb1.pgp -o tstf.sgn -t 16 -d 1 -k $RSAKEY



cat testfpb2.pgp tstf.sgn >tstf.pgp
pgp -ka tstf.pgp +batchmode +verbose=0 | grep "/.*Default"
rm -f testfsec.pgp testfpub.pgp testfpb2.pgp pubring.bak secring.bak

pgp -eas tstf.pro Default -u Default +batchmode +verbose=0 >/dev/null
./opgp -i tstf.pro.asc -o tstf.out
if cmp tstf.pro tstf.out; then echo decrypt ok; else exit 0; fi

# literal and encryption must seek output file, so cannot use pipe or append



./opgp -i tstf.out -o tstf.c1 -3 -d 1 -k $RSAKEY



./opgp -i tstf.out -o tstf.d1x -l tstf.out #literal
./opgp -O -i tstf.d1x -o tstf.d1
cat tstf.c1 tstf.d1 | ./opgp -o tstf.z1 -2 #append sig and compress

#conventional test
./opgp -i tstf.z1 -x 0 -y 1 -s 1 -a 1 -c -p testpass -o tstf.px
./opgp -O -i tstf.px -o tstf.pgp
pgp tstf.pgp -z"testpass" +batchmode +verbose=0 2>tstf.lg1 >tstf.log
if cmp tstf.pro tstf; then echo convencr ok; else exit 0; fi
rm tstf.pgp tstf

pgp -c tstf.out -a -o tstf.pgp -z"testpass" +batchmode +verbose=0 2>tstf.lg2
./opgp -p testpass -i tstf.pgp >tstf.out
if cmp tstf.pro tstf.out; then echo convdecr ok; else exit 0; fi




./opgp -i tstf.z1 -e $RSAKEY -a 1 -o tstf.a1x



./opgp -O -i tstf.a1x -o tstf.a1
./opgp -i tstf.a1 -o tstf.asc -m MESSAGE
pgp -f <tstf.asc  >tstf.ret +batchmode +verbose=0 2>tstf.log
if grep "Good signature" tstf.log ; then true; else exit 0; fi

./lookup -x -o testfpb2.pgp
./lookup -u -o testfpb1.pgp



./opgp -3 -o tstf.sgn -i testfpb2.pgp -t 32 -d 1 -p "" -k $RSAKEY



cat testfpb2.pgp tstf.sgn testfpb1.pgp >tstf.pgp
pgp -f <tstf.pgp +batchmode +verbose=0  >tstf.log
if grep "KEY REVOKED" tstf.log ; then echo revoked; else exit 0; fi

rm -f tstf*
mv pubring.sav pubring.pkr
echo 2.6.2 test complete
exit 0
fi

if [ $i = "n" ]; then
    NPGP=echo
    PKALGS="1 16"
    SIGALGS="17 1 16"
    HASHALGS="$HASHALGS 5"
    CONVALGS="$CONVALGS 4"
    SIGTS="-1 -5"
    DSIGTS="-3 -4"
    #HASHALGS="$HASHALGS 4" #haval
    #CONVALGS="$CONVALGS 5" #safer
fi

function newdhdsa {
echo ========== Generating DH/DSA key:
#this won't work if pubring.pkr has only RSA keys

if [ -s pubring.pkr ] ; then
    DSAKEY=`./ringscan | grep DSA | cut -c 5-21`
    DHKEY=`./ringscan | grep DH | cut -c 5-21`
    ./newkey -K $DSAKEY -k $DHKEY -u "Test Key" $USEPASS
else
    ./newkey -g 768 -u "Test Key" $USEPASS
fi
#this probably should be a cat, but...
mv pubnew.pkr pubring.pkr
mv secnew.skr secring.skr
DSAKEY=`./ringscan | grep DSA | cut -c 5-21`
DHKEY=`./ringscan | grep DH | cut -c 5-21`
./lookup -x -m Test | ./opgp -k $DSAKEY -3 -t 24 $USEPASS >>pubring.pkr
echo -ne "\260\001\147" >>pubring.pkr
}

function newrsav3 {
echo ========== Generating RSA v3 key:
./newkey -3 -g $RSABITS
./lookup -z -r pubnew.pkr | ./opgp -3 -t 16 $USEPASS >pnew.pkr
cat pnew.pkr >>pubnew.pkr
rm -f pnew.pkr
pgpk -a secnew.skr
pgpk -a pubnew.pkr
}

function newrsav4 {
echo ========== Generating RSA v4 key:
./newkey -R -g $RSABITS -u "OtherKey"
./lookup -x -m RSA | ./opgp -3 -t 24 $USEPASS >>pubnew.pkr
echo -ne "\260\001\147" >>pubnew.pkr
cat pubnew.pkr >>pubring.pkr
cat secnew.skr >>secring.skr
rm -f putnew.pkr secnew.skr
}

newdhdsa
touch pgp.cfg

if [ $i = "r" ]; then
    PKALGS="$PKALGS 1"
    SIGALGS="$SIGALGS 1 16"
    newrsav3
elif [ $i = "n" ]; then
    newrsav4
fi

pgpk -ll

RSAKEY=`./ringscan | grep RSA | cut -c 5-21`

SIGALGS="$DSAKEY $RSAKEY $DHKEY"
PKALGS="$DHKEY $RSAKEY"

if [ $i != "n" ]; then
  echo ========== Decrypt test
  rm -f wrx.out
  pgpe README -r Test -s -u Test -o wrx.out
  ./opgp -i wrx.out $USEPASS -o wry.out
  if cmp wry.out README; then echo our decrypt ok; else exit 0; fi
  rm wry.out
fi
echo ========== Clearsign test:
./clearsig -k $DSAKEY -i README -p testpass | ./testsig -
echo ========== Detached Signature test
for siga in $SIGALGS; do
  for sigt in $DSIGTS; do
    for hash in $HASHALGS; do
      echo Testing readme signed using $siga/$hash, v$sigt
      ./opgp -i README -o README.sig $USEPASS -d $hash $sigt -k $siga
      ./opgp -i README -v README.sig
      $NPGP pgpv README.sig
    done
  done
done
rm -f README.sig
echo ========== encrypt and one pass sig test
for pka in $PKALGS; do
  for siga in $SIGALGS; do
    for hash in $HASHALGS; do
      for alg in $CONVALGS; do
        for sigt in $SIGTS; do
          echo testing enc $pka/$alg, sig $siga/$hash$sigt
          ./opgp -i README -o rdx.enc -l rdx \
             -k $siga -d $hash -t 1 $USEPASS $sigt -z -a $alg -e $pka
          rm -f rdx
          $NPGP pgpv rdx.enc -o rdx
          ./opgp $USEPASS -i rdx.enc -o rdy.out
          if cmp rdy.out README ; then echo decrypt ok; else exit 0; fi
          rm -f rdx.enc rdy.out
        done
      done
    done
  done
done
rm -f rdx rdy.out
echo ========== Conventional test
for xa in $SALTALGS; do
  for ya in $HASHALGS; do
    for a in $CONVALGS; do
      for za in $CONVALGS; do
        echo testing conv-key only a C:$a S:$xa H:$ya SC:$za
        ./opgp -x $xa -y $ya -s $a -a $a -C $USEPASS -i README -m "" -o c1.asc
        ./opgp -I -i c1.asc | ./opgp -I $USEPASS | diff README - | head
        $NPGP pgpv c1.asc -o cvtv.one
        $NPGP diff README cvtv.one
        rm -f cvtv.one c1.asc
      done
      echo testing conv only a C:$a S:$xa H:$ya
      ./opgp -x $xa -y $ya -s $a -a $a -c $USEPASS -i README -m "" -o cvt2.asc
      ./opgp -I -i cvt2.asc | ./opgp -I $USEPASS | diff README - | head
      $NPGP pgpv cvt2.asc -o cvtv.two
      $NPGP diff README cvtv.two
      rm -f cvtv.two cvt2.asc
    done
  done
done
