#include <stdio.h>
#include <string.h>

extern unsigned long PGP_crc24t[256];
extern unsigned char PGP_dmtab[84];

/*-------------------------*/
/* Same as in dearmor, except returns a buffer */
static unsigned char inbuf[256], *ip = inbuf;
long unm2buf(FILE * ifd, char *ofd)
{
  int i = 3, j;
  unsigned long t, ccrc = 0xB704CE;
  char cx[4], *c = cx;

  if (ofd)
    c = ofd;
  inbuf[0] = 0;
  while (i == 3) {
    for (i = 0; i < 4; i++) {
      while (!(j = *ip++) || j > 124 || j < 40
             || (c[i] = PGP_dmtab[j - 40]) > 65)
        if (!j && !fgets(ip = inbuf, 255, ifd))
          return -1;
      if (c[i] < 64)
        continue;
      if (ofd)
        break;
      i--;
    }
    t = (c[0] << 18) | (c[1] << 12) | (c[2] << 6) | c[3];
    if (!ofd)
      return t;
    c[0] = t >> 16, c[1] = t >> 8, c[2] = t;
    i -= (i > 1);
    c += i;
  }
  for (t = 0; t < c - ofd; t++)
    ccrc = ccrc << 8 ^ PGP_crc24t[0xff & ((ccrc >> 16) ^ ofd[t])];
  return ccrc & 0xffffff;
}

/*-------------------------*/
/* canonicalize string (and remove dash escape) */
void fixstr(char *s)
{
  while (strlen(s) && s[strlen(s) - 1] <= ' ')
    s[strlen(s) - 1] = 0;
  strcat(s, "\r");
  strcat(s, "\n");
  if (!strncmp(s, "- -", 3))
    memmove(s, &s[2], strlen(s));
};
