/* REXX Program PGPexec.CMD
   used to execute PGP and write the result code to a log file
*/
parse ARG PGPoptions PGPparams

PGPpath = VALUE('PGPPATH',,'OS2ENVIRONMENT')
If (Length(PGPpath)> 0) & (RIGHT(PGPpath,1) \= '\') then
   PGPpath = PGPpath || '\'
ExecString = PGPpath||'PGP.EXE'


address cmd ExecString||' '||PGPoptions||' '||PGPparams


/* Do logging ---------------------------------------------- */
Erfolg = RC

Tab = '09'x
PARSE SOURCE BetrSyst Shell MyName
MyDir = FILESPEC("Drive",MyName)||FILESPEC("Path",MyName)
LogFile = MyDir||'PGPREXX.LOG'
Erg = STREAM(LogFile,'C','OPEN WRITE')
Erg = LINEOUT(LogFile,Date('O')||' '||Time()||Tab||'>>>'||Tab||MsgId||Tab||Erfolg||Tab||PGPparams)
Erg = STREAM(LogFile,'C','CLOSE')
EXIT
