/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CEditDiskTestDialog.cp,v 1.12.8.1 1998/11/12 03:05:05 heller Exp $
____________________________________________________________________________*/

#if PGP_DEBUG	// [

#include <LEditText.h>
#include <LPopupButton.h>
#include <PP_Messages.h>
#include <UModalDialogs.h>
#include "CPGPStDialogHandler.h"

#include "pgpMacMemory.h"
#include "MacStrings.h"
#include "MacDriverUtils.h"

#include "PGPMountUtils.h"
#include "PGPDisk.h"

#include "CDiskTestsTable.h"
#include "CEditDiskTestDialog.h"
#include "CWarningAlert.h"

const short		kEditDiskTestDialogResID	= 22000;
const short		kVolumeMenuResID			= 22000;

const PaneIDT	kOKButtonPaneID				= 22001;
const PaneIDT	kCancelButtonPaneID			= 22002;
const PaneIDT	kVolumePopupMenuPaneID		= 22003;
const PaneIDT	kTestNameEditTextPaneID		= 22005;

const PaneIDT	kDriverReadTasksEditTextPaneID		= 22102;
const PaneIDT	kDriverMinReadBlocksEditTextPaneID	= 22104;
const PaneIDT	kDriverMaxReadBlocksEditTextPaneID	= 22106;
const PaneIDT	kDriverWriteTasksEditTextPaneID		= 22112;
const PaneIDT	kDriverMinWriteBlocksEditTextPaneID	= 22114;
const PaneIDT	kDriverMaxWriteBlocksEditTextPaneID	= 22116;

const PaneIDT	kFMReadTasksEditTextPaneID			= 22202;
const PaneIDT	kFMMinReadBytesEditTextPaneID		= 22204;
const PaneIDT	kFMMaxReadBytesEditTextPaneID		= 22206;
const PaneIDT	kFMWriteTasksEditTextPaneID			= 22212;
const PaneIDT	kFMMinWriteBytesEditTextPaneID		= 22214;
const PaneIDT	kFMMaxWriteBytesEditTextPaneID		= 22216;

	Boolean
DoEditDiskTestDialog(struct TestDriveConfiguration *testConfig)
{
	CPGPStDialogHandler			dialogHandler( kEditDiskTestDialogResID, nil );
	CEditDiskTestDialog		*dialogObj;
	Boolean					valid;
	
	pgpAssertAddrValid( testConfig, TestDriveConfiguration );
	
	dialogObj = (CEditDiskTestDialog *) dialogHandler.GetDialog();
	if( IsNull( dialogObj ) )
	{
		pgpDebugMsg( "DoEditDiskTestDialog: Nil dialog object" );
		return( FALSE );
	}
	
	dialogObj->Show();
	
	while (TRUE)
	{
		MessageT	hitMessage = dialogHandler.DoDialog();

		if( hitMessage == msg_Cancel )
		{
			valid = FALSE;
			break;
		}
		else if( hitMessage == msg_OK &&
					dialogObj->GetTestConfiguration( testConfig ) )
		{
			valid = TRUE;
			break;
		}
	}

	dialogObj->Hide();
	
	return( valid );
}

CEditDiskTestDialog::CEditDiskTestDialog()
{
}

CEditDiskTestDialog::CEditDiskTestDialog(LStream *inStream)
	: CPGPDiskDialog(inStream)
{
}

CEditDiskTestDialog::~CEditDiskTestDialog()
{
}

	void
CEditDiskTestDialog::FinishCreateSelf(void)
{
	CPGPDiskDialog::FinishCreateSelf();
	
	AddMountedVolumesToPopup();
}

	void
CEditDiskTestDialog::AddMountedVolumesToPopup(void)
{
	MenuHandle		volumeMenu;
	
	pgpClearMemory( mVRefNumList, sizeof( mVRefNumList ) );
	
	volumeMenu = GetMenu( kVolumeMenuResID );
	AssertHandleIsValid( volumeMenu, nil );
	
	if( volumeMenu != nil )
	{
		HParamBlockRec	pb;
		short			numMenuItems;
		short			menuItemIndex;
		short			firstPGPDiskIndex;
		OSStatus		status;
		Str255			volumeName;
		short			driverRefNum;
		LPopupButton		*popupMenuObj;
		
		// Remove existing menu items, if any.
		numMenuItems = CountMItems( volumeMenu );
		for( menuItemIndex = numMenuItems; menuItemIndex >= 1;
				menuItemIndex-- )
		{
			DeleteMenuItem( volumeMenu, menuItemIndex );
		}
		
		// Find the PGPDisk driver
		if( ! DriverIsInstalled( kPGPDiskDriverName, &driverRefNum ) )
			driverRefNum = 0;
		
		// Loop over all mounted volumes and add them to the menu.
		// Volumes which cannot be tested are dimmed. PGPDisk are marked
		// with a bullet character.
		
		firstPGPDiskIndex 	= 0;
		menuItemIndex		= 1;
		
		pgpClearMemory( &pb, sizeof( pb ) );
	
		pb.volumeParam.ioNamePtr = volumeName;
		
		do
		{
			pb.volumeParam.ioVolIndex = menuItemIndex;

			status = PBHGetVInfoSync( &pb );
			if( IsntErr( status ) )
			{
				mVRefNumList[menuItemIndex - 1] = pb.volumeParam.ioVRefNum;
				
				AppendMenu( volumeMenu, volumeName );
				
				// Check to see if it is a PGPDisk
				if( pb.volumeParam.ioVDRefNum != 0 &&
					pb.volumeParam.ioVDRefNum == driverRefNum )
				{
					if( firstPGPDiskIndex == 0 )
						firstPGPDiskIndex = menuItemIndex;
			
					SetItemIcon( volumeMenu, menuItemIndex, 1 );
				}
				
				// Check to see if we can test this volume
				// Check for volume lock.
				if( ( pb.volumeParam.ioVAtrb & 0x8080 ) != 0 )
				{
					DisableItem( volumeMenu, menuItemIndex );
				}
				
				++menuItemIndex;
			}
		
		} while( IsntErr( status ) );
		
		popupMenuObj = (LPopupButton *) FindPaneByID( kVolumePopupMenuPaneID );
		pgpAssertAddrValid( popupMenuObj, VoidAlign );
	
		popupMenuObj->SetMacMenuH( volumeMenu );
		
		if( firstPGPDiskIndex != 0 )
		{
			popupMenuObj->SetValue( firstPGPDiskIndex );
		}
		else
		{
			popupMenuObj->SetValue( 1 );
		}
	}
}

	Int32
CEditDiskTestDialog::GetEditFieldValue(PaneIDT editFieldPaneID)
{
	LEditText	*editFieldObj;

	editFieldObj = (LEditText *) FindPaneByID( editFieldPaneID );
	pgpAssertAddrValid( editFieldObj, LEditText );
	
	return( editFieldObj->GetValue() );
}

	Boolean
CEditDiskTestDialog::GetTestConfiguration(TestDriveConfiguration *testConfig)
{
	LEditText		*editFieldObj;
	LPopupButton	*popupMenuObj;
	
	pgpAssertAddrValid( testConfig, TestDriveConfiguration );
	
	pgpClearMemory( testConfig, sizeof( *testConfig ) );
	
	// Get test name
	editFieldObj = (LEditText *) FindPaneByID( kTestNameEditTextPaneID );
	pgpAssertAddrValid( editFieldObj, LEditText );
	
	editFieldObj->GetDescriptor( testConfig->testName );
	if( testConfig->testName[0] == 0 )
	{
		CWarningAlert::Display( kWANoteAlertType, kWAOKStyle,
				"\pPlease enter a test name" );
		return( FALSE );
	}
	
	// Get test volume vRefNum
	popupMenuObj = (LPopupButton *) FindPaneByID( kVolumePopupMenuPaneID );
	pgpAssertAddrValid( popupMenuObj, VoidAlign );

	pgpAssert( popupMenuObj->GetValue() >= 1 );
	
	testConfig->vRefNum = mVRefNumList[popupMenuObj->GetValue() - 1];
	
	// Driver read tasks
	testConfig->numDriverReadTasks =
			GetEditFieldValue( kDriverReadTasksEditTextPaneID );
	testConfig->minDriverReadBlocks =
			GetEditFieldValue( kDriverMinReadBlocksEditTextPaneID );
	testConfig->maxDriverReadBlocks =
			GetEditFieldValue( kDriverMaxReadBlocksEditTextPaneID );

	if( testConfig->minDriverReadBlocks > testConfig->maxDriverReadBlocks )
	{
		CWarningAlert::Display( kWANoteAlertType, kWAOKStyle,
				"\pMinimum driver read blocks must not exceed maximum driver "
				"read blocks" );
		return( FALSE );
	}

	// Driver write tasks
	testConfig->numDriverWriteTasks =
			GetEditFieldValue( kDriverWriteTasksEditTextPaneID );
	testConfig->minDriverWriteBlocks =
			GetEditFieldValue( kDriverMinWriteBlocksEditTextPaneID );
	testConfig->maxDriverWriteBlocks =
			GetEditFieldValue( kDriverMaxWriteBlocksEditTextPaneID );

	if( testConfig->minDriverWriteBlocks > testConfig->maxDriverWriteBlocks )
	{
		CWarningAlert::Display( kWANoteAlertType, kWAOKStyle,
					"\pMinimum driver write blocks must not exceed maximum "
					"driver write blocks" );
		return( FALSE );
	}

	// FM read tasks
	testConfig->numFMReadTasks 	=
			GetEditFieldValue( kFMReadTasksEditTextPaneID );
	testConfig->minFMReadBytes 	=
			GetEditFieldValue( kFMMinReadBytesEditTextPaneID );
	testConfig->maxFMReadBytes 	=
			GetEditFieldValue( kFMMaxReadBytesEditTextPaneID );

	if( testConfig->minFMReadBytes > testConfig->maxFMReadBytes )
	{
		CWarningAlert::Display( kWANoteAlertType, kWAOKStyle,
					"\pMinimum file manager read bytes must not exceed "
					"maximum file manger read bytes" );
		return( FALSE );
	}

	// FM write tasks
	testConfig->numFMWriteTasks =
			GetEditFieldValue( kFMWriteTasksEditTextPaneID );
	testConfig->minFMWriteBytes =
			GetEditFieldValue( kFMMinWriteBytesEditTextPaneID );
	testConfig->maxFMWriteBytes =
			GetEditFieldValue( kFMMaxWriteBytesEditTextPaneID );

	if( testConfig->minFMWriteBytes > testConfig->maxFMWriteBytes )
	{
		CWarningAlert::Display( kWANoteAlertType, kWAOKStyle,
					"\pMinimum file manager write bytes must not exceed "
					"maximum file manger write bytes" );
		return( FALSE );
	}

	return( TRUE );
}

#endif	// ] PGP_DEBUG
