/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPDiskPreferences.c,v 1.4.8.1 1998/11/12 03:05:22 heller Exp $
____________________________________________________________________________*/

#include "pgpMacMemory.h"
#include "MacStrings.h"

#include "PGPDisk.h"
#include "PGPDiskPreferences.h"
#include "PGPDiskResources.h"
#include "PGPDiskUtils.h"
#include "SleepAlert.h"

const OSType	kPrefsMagic 	= kPrefsFileType;
const ushort	kPrefsVersion	= 0x0100;


PGPDiskPrefs	gPGPDiskPrefs;

	static void
InitDefaultPreferences(PGPDiskPrefs *prefs)
{
	pgpAssertAddrValid( prefs, PGPDiskPrefs );
	
	pgpClearMemory( prefs, sizeof( *prefs ) );
	
	prefs->magic 	= kPrefsMagic;
	prefs->version	= kPrefsVersion;
	
	prefs->driverPrefs	= kDefaultPGPDiskDriverPrefs;
	
	prefs->newDiskDefaultSize	= 10;
	prefs->newDiskDefaultIsMB	= TRUE;
	prefs->mainWindowLocation.v	= 0;
	prefs->mainWindowLocation.h	= 0;
}

	static Boolean
ValidatePreferences(PGPDiskPrefs *prefs)
{
	pgpAssertAddrValid( prefs, PGPDiskPrefs );
	
	if( prefs->magic != kPrefsMagic )
	{
		pgpDebugMsg( "ValidatePreferences: Invalid preferences magic" );
		return( FALSE );
	}
	
	if( prefs->version != kPrefsVersion )
	{
		pgpDebugMsg( "ValidatePreferences: Invalid preferences version" );
		return( FALSE );
	}
	
	if( prefs->driverPrefs.unmountAfterIdleTime == 0 )
	{
		prefs->driverPrefs.unmountIdleTimeSeconds = 1 * 60;
	}
	
	return( TRUE );
}

	OSStatus
GetPrefsFileSpec(FSSpec *fileSpec)
{
	OSStatus	status;
	
	pgpAssertAddrValid( fileSpec, FSSpec );
	
	status = FindPGPPreferencesFolder( kOnSystemDisk, &fileSpec->vRefNum,
						&fileSpec->parID );
	if( IsntErr( status ) )
	{
		Str255	prefsFileName;
		
		GetIndString( prefsFileName, kMiscStringsListResID,
				kPreferencesFilenameStrIndex );
		if( prefsFileName[0] != 0 && prefsFileName[0] <= 31 )
		{
			CopyPString( prefsFileName, fileSpec->name );
		}
		else
		{
			status = bdNamErr;
		}
	}
	
	return( status );
}

	void
WritePreferences(const PGPDiskPrefs *prefs)
{
	OSStatus	status;
	FSSpec		fileSpec;
	
	pgpAssertAddrValid( prefs, PGPDiskPrefs );
	
	status = GetPrefsFileSpec( &fileSpec );
	if( IsntErr( status ) )
	{
		(void) FSpRstFLock( &fileSpec );
		(void) FSpDelete( &fileSpec );
		
		status = FSpCreate( &fileSpec, kPGPDiskFileCreator, kPrefsFileType,
						smSystemScript );
		if( IsntErr( status ) )
		{
			short	fileRef;
			
			status = FSpOpenDF( &fileSpec, fsRdWrPerm, &fileRef );
			if( IsntErr( status ) )
			{
				long	count;
				
				count = sizeof( *prefs );
				
				status = FSWrite( fileRef, &count, prefs );
			
				(void) FSClose( fileRef );
			}
			FlushVol( nil, fileSpec.vRefNum );
		}
	}
	
	CopySleepAlertToPrefs();
	
	AssertNoErr( status, "WritePrefs" );
}

	void
ReadPreferences(PGPDiskPrefs *prefs)
{
	OSStatus	status;
	FSSpec		fileSpec;
	
	pgpAssertAddrValid( prefs, PGPDiskPrefs );
	
	status = GetPrefsFileSpec( &fileSpec );
	if( IsntErr( status ) )
	{
		short	fileRef;
		
		status = FSpOpenDF( &fileSpec, fsRdPerm, &fileRef );
		if( IsntErr( status ) )
		{
			long	count;
			
			count = sizeof( *prefs );
			
			status = FSRead( fileRef, &count, prefs );
			if( IsntErr( status ) )
			{
				if( ! ValidatePreferences( prefs ) )
					status = -1;
			}
			
			(void) FSClose( fileRef );
		}
	}
	
	if( IsErr( status ) )
	{
		pgpAssert( status == fnfErr );
		InitDefaultPreferences( prefs );
	}
}

	OSStatus
SendPreferencesToAllDrivers(const PGPDiskDriverPrefs *driverPrefs)
{
	OSStatus		err	= nsDrvErr;
	const ushort	kMaxDrivers	= 100;
	short			driverRefNums[ kMaxDrivers ];
	ushort 			numDrivers;
	
	pgpAssertAddrValid( driverPrefs, PGPDiskDriverPrefs );

	GetAllPGPDiskDrivers( driverRefNums, kMaxDrivers, &numDrivers);
	for( ushort driverIndex = 0; driverIndex < numDrivers; ++driverIndex )
	{
		OSStatus	tempErr;
		
		tempErr = SendPreferencesToDriver( driverRefNums[ driverIndex ],
						driverPrefs );
		if( IsErr( tempErr ) && IsntErr( err ) )
			err = tempErr;
	}
		
	return( err );
}

