/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CDriveList.cp,v 1.3.8.1 1998/11/12 03:05:38 heller Exp $
____________________________________________________________________________*/

#include "CDrive.h"
#include "CDriveList.h"
#include "MacInterrupts.h"


CDriveList *	CDriveList::sDriveList	= nil;

	CDriveList *
CDriveList::sGetList( void )
	{
	pgpAssert( IsntNull( sDriveList ) );
	
	return( sDriveList );
	}


	OSErr
CDriveList::sCreateList( void )
	{
	OSErr	err	= noErr;
	
	pgpAssert( IsNull( sDriveList ) );
	
	sDriveList	= new CDriveList;
	pgpAssert( IsntNull( sDriveList ) );
	if ( IsNull( sDriveList) )
		{
		err	= memFullErr;
		}
	
	return( err );
	}
	
	
	void
CDriveList::sDisposeList( void )
	{
	pgpAssert( IsntNull( sDriveList ) );
	pgpAssert( sDriveList->GetNumDrives() == 0 );
	
	delete sDriveList;
	sDriveList	= nil;
	}


CDriveList::CDriveList( void )
	{
	mDriveArray	= nil;
	mNumDrives	= 0;
	}


CDriveList::~CDriveList( void )
	{
	pgpAssert( GetNumDrives() == 0 );
	sDriveList	= nil;
	
	if ( IsntNull( mDriveArray ) )
		{
		DisposePtr( (Ptr)mDriveArray );
		mDriveArray	= nil;
		}
	}

	
	
	CDrive *
CDriveList::GetDriveForDriveNumber( short driveNumber )
	{
	for( ushort index = 0; index < GetNumDrives(); ++index )
		{
		CDrive *	drive;
		
		drive	= GetIndDrive( index );
		if ( drive->GetDriveNumber() == driveNumber )
			{
			CDrive::sAssertValid( drive );
			return( drive );
			}
		}
	
	return( nil );
	}
	
		
	ushort
CDriveList::GetDriveIndex( const CDrive *driveToFind )
	{
	for( ushort index = 0; index < GetNumDrives(); ++index )
		{
		CDrive *	drive;
		
		drive	= GetIndDrive( index );
		if ( drive == driveToFind )
			return( index );
		}
	
	pgpDebugPStr( "\pCDriveList::GetDriveIndex: drive not found" );
	return( ~0 );
	}
	
	
	
	
	void
CDriveList::AddDrive( const CDrive *drive )
	{
	const CDrive **	newList	= (const CDrive **)NewPtrSys( sizeof( CDrive * ) *
									(mNumDrives + 1) );
	
	if ( IsntNull( newList ) )
		{
		// copy the old list into the new and dump the old
		if ( IsntNull( mDriveArray ) )
			{
			BlockMoveData( mDriveArray, newList, mNumDrives *
					sizeof( CDrive * ) );
			
			DisposePtr( (Ptr)mDriveArray );
			mDriveArray	= nil;
			}
		
		newList[ mNumDrives ]	= drive;
		
		mDriveArray	= newList;
		++mNumDrives;
		}
	}


	
	void
CDriveList::RemoveDrive( const CDrive *drive )
	{
	pgpAssert( mNumDrives != 0 );
	
	ushort	index	= GetDriveIndex( drive );
	
	if ( index < GetNumDrives() && mNumDrives != 0)
		{
		ulong	numAfter	= ( mNumDrives - index ) - 1;
		
		EnterCriticalSection();
		if ( numAfter != 0 )
			{
			BlockMoveData( &mDriveArray[ index + 1 ], &mDriveArray[ index ],
					numAfter * sizeof( CDrive * ) );
			}
		
		--mNumDrives;
		ExitCriticalSection();
		}
	}






	
	