/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CInterruptLevelTester.cp,v 1.5.8.1 1998/11/12 03:06:22 heller Exp $
____________________________________________________________________________*/

#include <Timer.h>
#include <stddef.h>
#include "pgpMacMemory.h"
#include "MacFiles.h"
#include "UInt64.h"

#include "SetupA5.h"


#if TARGET_RT_MAC_CFM
assumes 68K non-CFM
#endif

#include "CInterruptLevelTester.h"



CInterruptLevelTester::CInterruptLevelTester()
	: mMagic( kMagicValue )
	{
	OSErr	err	= noErr;
	
	mTestInProgress		= false;
	mAcknowledgeDone	= false;
	mIODirection		= kNoDirection;
	
	RememberA5();
	}


CInterruptLevelTester::~CInterruptLevelTester( )
	{
	if ( mTestInProgress )
		{
		Stop();
		}
	}



	OSErr
CInterruptLevelTester::Setup( short fileRefNum )
	{
	OSErr	err	= noErr;
	
	mFileRefNum	= fileRefNum;
	
	mMicrosecondsDelay	= DetermineMicrosecondsDelay( fileRefNum );
	return( err );
	}
	
	
	ulong
CInterruptLevelTester::DetermineMicrosecondsDelay( short fileRefNum )
	{
	OSErr			err	= noErr;
	ulong			delay	= 500;
	const ulong		kTestSize	= 4UL * 104UL;
	const ulong		kIterations	= 20;

	UnsignedWide	startMS;
	UnsignedWide	stopMS;
	Microseconds( &startMS );
	
	for ( ulong writeCount = 0; writeCount < kIterations; ++writeCount )
		{
		char	buffer[ kTestSize ];
		long	count	= kTestSize;
		
		err	= FSWrite( fileRefNum, &count, buffer );
		if ( IsErr( err ) )
			break;
		}
	FlushFile( fileRefNum );
	
	Microseconds( &stopMS );
	
	if ( IsntErr( err ) )
		{
		CUInt64	elapsedMS		= CUInt64( stopMS ) - CUInt64( startMS );
		ulong	msPerRequest	= elapsedMS.lo / kIterations;

		// give ample CPU time to system; we can always create multiple
		// requests
		delay	= msPerRequest * 10;
		}
		
	AssertNoErr( err, "CInterruptLevelTester::DetermineMicrosecondsDelay" );
	
	return( delay );
	}
	

/*___________________________________________________________________________
	IO is done strictly within the specified file. The test is destructive of
	all data within the file.
___________________________________________________________________________*/
	void
CInterruptLevelTester::Run(
	short			fileRefNum,
	IODirection		direction )
	{
	AssertFileRefNumIsValid( fileRefNum, "CInterruptLevelTester::Run" );
	
	mFileRefNum			= fileRefNum;
	mIODirection		= direction;
	mTestInProgress		= TRUE;
	mAcknowledgeDone	= false;
	
	if ( Setup( fileRefNum ) == noErr )
		{
		InstallTimeMgrTask();
		}
	else
		{
		mTestInProgress = false;
		}
	}
	
	
	
	void
CInterruptLevelTester::Stop( )
	{
	pgpAssert( mTestInProgress );
	
	mTestInProgress	= false;
	
	// time mgr, io tasks should set this once they've agreed to stop
	while( ! mAcknowledgeDone )
		{
		}
	}


	void
CInterruptLevelTester::HandleIOCompletion( MyPB *myPB )
	{
	ParamBlockRec *	pb	= &myPB->pb;
	OSErr		resultErr;
	
	resultErr	= pb->ioParam.ioResult;
	
	if ( resultErr == eofErr )
		resultErr	= noErr;
		
	pgpAssert( resultErr == noErr );

	if ( mTestInProgress && IsntErr( resultErr ) )
		{
		// do it again soon...
		InstallTimeMgrTask();
		}
	else
		{
		mAcknowledgeDone	= TRUE;
		}
	}
	
	
	pascal void
CInterruptLevelTester::sIOCompletion()
	{
	long	saveD0	= GetD0();
	
	EnterCallbackA5();
	
	ParamBlockRec *	pb;
	
	pb	= (ParamBlockRec *)GetA0();
	
	MyPB *	myPB;
	myPB	= (MyPB *)(((char *)pb) - offsetof( MyPB, pb ));
	
	pgpAssert( myPB->thisObject->mMagic == kMagicValue );
	myPB->thisObject->HandleIOCompletion( myPB );
	
	ExitCallbackA5();
	
	SetD0( saveD0 );
	}
	

	
	pascal void
CInterruptLevelTester::sTimeMgrTask()
	{
	MyTMTask *myTask	= (MyTMTask *)GetA1();
	
	EnterCallbackA5();

	
	pgpAssert( offsetof( MyTMTask, tmTask ) == 0 );
	
	RmvTime( (QElemPtr)&myTask->tmTask );
	
	pgpAssert( myTask->thisObject->mMagic == kMagicValue );
	
	myTask->thisObject->DoIOFromTimeMgrTask();
	
	ExitCallbackA5();
	}
	
	
	void
CInterruptLevelTester::InstallTimeMgrTask()
	{
	TMTask *tmTask;
	
	mMyTMTask.thisObject	= this;
	tmTask					= &mMyTMTask.tmTask;
	
	pgpClearMemory( tmTask, sizeof( *tmTask ) );
	tmTask->tmAddr			= (TimerUPP)sTimeMgrTask;
	
	// put it into the queue
	InsTime( (QElemPtr)tmTask );
	
	// add some variation in, but no more than twice
	// so that we end up with a delay of [delay, delay * 2]
	UnsignedWide	dummy;
	Microseconds( &dummy );
	ulong	delay	= mMicrosecondsDelay + ( dummy.lo % mMicrosecondsDelay );
	delay	= -delay;	// indicate that it's microseconds
	 
	pgpAssert( (long)delay < 0 );	// microseconds is negative vs positive
									// milliseconds
	
	PrimeTime( (QElemPtr)tmTask, delay );
	}



