/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CAdminDialog.cp,v 1.50.2.1.2.1 1998/11/12 03:06:57 heller Exp $
____________________________________________________________________________*/

#include <PP_KeyCodes.h>
#include <PP_Messages.h>
#include <UReanimator.h>
#include <LMultiPanelView.h>
#include <LEditText.h>
#include <LCheckBox.h>
#include <LTextEditView.h>
#include <LScrollerView.h>

#include "MacDesktop.h"
#include "MacFiles.h"
#include "MacResources.h"
#include "MacStrings.h"

#include "pgpFileSpec.h"
#include "pflPrefTypes.h"
#include "pgpAdminPrefs.h"
#include "pgpUtilities.h"
#include "PGPOpenPrefs.h"
#include "pgpClientPrefs.h"
#include "CWarningAlert.h"
#include "pgpClientLib.h"

#include "CString.h"
#include "CTempFile.h"
#include "CPanel.h"

#include "PGPadminGlobals.h"
#include "CKeyTable.h"
#include "CAdminDialog.h"

const ResIDT	RidL_Dialog						=	128;

const ResIDT	ppob_CompanyName				=	2000;
const ResIDT	ppob_AdminWizardDescription		=	2100;
const ResIDT	ppob_ADKDescription				=	2200;
const ResIDT	ppob_UseIncomingADK				=	2300;
const ResIDT	ppob_ChooseIncomingADK			=	2400;
const ResIDT	ppob_UseOutgoingADK				=	2500;
const ResIDT	ppob_ChooseOutgoingADK			=	2600;
const ResIDT	ppob_UsePGPdiskADK				=	2650;
const ResIDT	ppob_ChoosePGPdiskADK			=	2655;
const ResIDT	ppob_EnforceADKs				=	2700;
const ResIDT	ppob_PassphraseMinimums			=	2800;
const ResIDT	ppob_CorporateKeyOptions		=	2900;
const ResIDT	ppob_ChooseCorporateKey			=	3000;
const ResIDT	ppob_UseDesignatedRevoker		=	3050;
const ResIDT	ppob_ChooseDesignatedRevoker	=	3060;
const ResIDT	ppob_KeyGenerationOptions		=	3100;
const ResIDT	ppob_ChooseDefaultKeys			=	3200;
const ResIDT	ppob_AutoUpdating				=	3300;
const ResIDT	ppob_MiscOptions				=	3400;
const ResIDT	ppob_Summary					=	3500;
const ResIDT	ppob_CopyClientPrefs			=	3600;
const ResIDT	ppob_ChooseInstaller			=	3700;
const ResIDT	ppob_SaveInstaller				=	3800;
const ResIDT	ppob_Finished					=	3900;

const PaneIDT	button_Next						=	1000;
const PaneIDT	button_Previous					=	1001;
const PaneIDT	button_Quit						=	1002;
const PaneIDT	pane_MultiPanel					=	1003;

const PaneIDT	pane_CompanyName			=	2000;
const PaneIDT	edittext_CompanyName		=	2001;

const PaneIDT	pane_UseIncomingADK				=	2300;
const PaneIDT	checkbox_UseIncomingADK			=	2301;

const PaneIDT	pane_ChooseIncomingADK			=	2400;
const PaneIDT	table_IncomingADK				=	2401;

const PaneIDT	pane_UseOutgoingADK				=	2500;
const PaneIDT	checkbox_UseOutgoingADK			=	2501;

const PaneIDT	pane_ChooseOutgoingADK			=	2600;
const PaneIDT	table_OutgoingADK				=	2601;

const PaneIDT	pane_UsePGPdiskADK				=	2650;
const PaneIDT	checkbox_UsePGPdiskADK			=	2651;

const PaneIDT	pane_ChoosePGPdiskADK			=	2655;
const PaneIDT	table_PGPdiskADK				=	2656;

const PaneIDT	pane_EnforceADKs						=	2700;
const PaneIDT	checkbox_EnforceIncomingADK				=	2701;
const PaneIDT	checkbox_EnforceOutgoingADK				=	2702;
const PaneIDT	checkbox_EnforceRemoteADKStrictness		=	2703;

const PaneIDT	pane_PassphraseMinimums						=	2800;
const PaneIDT	checkbox_EnforceMinimumPassphraseCharacters	=	2801;
const PaneIDT	edittext_MinimumPassphraseCharacters		=	2802;
const PaneIDT	checkbox_EnforceMinimumPassphraseQuality	=	2803;
const PaneIDT	edittext_MinimumPassphraseQuality			=	2804;

const PaneIDT	pane_CorporateKeyOptions				=	2900;
const PaneIDT	checkbox_AutoSignCorporateKey			=	2901;
const PaneIDT	checkbox_CorporateKeyIsMetaIntroducer	=	2902;
const PaneIDT	checkbox_WarnIfNotSignedByCorporateKey	=	2903;

const PaneIDT	pane_ChooseCorporateKey			=	3000;
const PaneIDT	table_CorporateKey				=	3001;

const PaneIDT	pane_UseDesignatedRevoker				=	3050;
const PaneIDT	checkbox_EnableADesignatedRevokerKey	=	3051;

const PaneIDT	pane_ChooseDesignatedRevoker			=	3060;
const PaneIDT	table_DesignatedRevoker					=	3061;

const PaneIDT	pane_KeyGenerationOptions		=	3100;
const PaneIDT	checkbox_AllowKeyGeneration		=	3101;
const PaneIDT	checkbox_AllowRSAKeyGeneration	=	3102;
const PaneIDT	edittext_MinimumKeySize			=	3103;

const PaneIDT	pane_ChooseDefaultKeys			=	3200;
const PaneIDT	table_DefaultKeys				=	3201;

const PaneIDT	pane_AutoUpdating					=	3300;
const PaneIDT	checkbox_UpdateAllKeys				=	3301;
const PaneIDT	edittext_UpdateAllKeys				=	3302;
const PaneIDT	checkbox_UpdateTrustedIntroducers	=	3303;
const PaneIDT	edittext_UpdateTrustedIntroducers	=	3304;

const PaneIDT	pane_MiscOptions						=	3400;
const PaneIDT	checkbox_AllowConventionalEncryption	=	3401;
const PaneIDT	edittext_MessageHeaderComment			=	3402;

const PaneIDT	pane_Summary					=	3500;
const PaneIDT	texteditview_Summary			=	3501;
const PaneIDT	scroller_Summary				=	3502;

const PaneIDT	pane_CopyClientPrefs			=	3600;
const PaneIDT	checkbox_CopyClientPrefs		=	3601;

const PaneIDT	pane_ChooseInstaller			=	3700;
const PaneIDT	button_ChooseInstaller			=	3701;
const PaneIDT	statictext_Installer			=	3702;

const PaneIDT	pane_SaveInstaller				=	3800;

const PaneIDT	pane_Finished					=	3900;

enum {
	panel_CompanyName			=	1,
	panel_AdminWizardDescription,
	panel_ADKDescription,
	panel_UseIncomingADK,
	panel_ChooseIncomingADK,
	panel_UseOutgoingADK,
	panel_ChooseOutgoingADK,
	panel_EnforceADKs,
	panel_UsePGPdiskADK,
	panel_ChoosePGPdiskADK,
	panel_PassphraseMinimums,
	panel_CorporateKeyOptions,
	panel_ChooseCorporateKey,
	panel_UseDesignatedRevoker,
	panel_ChooseDesignatedRevoker,
	panel_KeyGenerationOptions,
	panel_ChooseDefaultKeys,
	panel_AutoUpdating,
	panel_MiscOptions,
	panel_Summary,
	panel_CopyClientPrefs,
	panel_ChooseInstaller,
	panel_SaveInstaller,
	panel_Finished,

	panel_First						=	panel_CompanyName,
	panel_Last						=	panel_Finished
};


const MessageT	msg_Next					=	button_Next;
const MessageT	msg_Previous				=	button_Previous;
const MessageT	msg_IncomingADKTable		=	table_IncomingADK;
const MessageT	msg_OutgoingADKTable		=	table_OutgoingADK;
const MessageT	msg_PGPdiskADKTable			=	table_PGPdiskADK;
const MessageT	msg_AutoSignCorporateKey	=	checkbox_AutoSignCorporateKey;
const MessageT	msg_CorporateKeyTable		=	table_CorporateKey;
const MessageT	msg_DesignatedRevokerTable	=	table_DesignatedRevoker;
const MessageT	msg_AllowKeyGeneration		=	checkbox_AllowKeyGeneration;
const MessageT	msg_ChooseInstaller			=	button_ChooseInstaller;
const MessageT	msg_UpdateAllKeys			=	checkbox_UpdateAllKeys;
const MessageT	msg_UpdateTrustedIntroducers
							=	checkbox_UpdateTrustedIntroducers;
const MessageT	msg_EnforceMinimumPassphraseCharacters	
							=	checkbox_EnforceMinimumPassphraseCharacters;
const MessageT	msg_EnforceMinimumPassphraseQuality
							=	checkbox_EnforceMinimumPassphraseQuality;



const SInt16	kMinimumPassphraseCharacters			=	3;
const SInt16	kMaximumPassphraseCharacters			=	255;
const SInt16	kMinimumPassphraseQuality				=	20;
const SInt16	kMaximumPassphraseQuality				=	100;
const SInt16	kMinimumKeySize							=	768;
const SInt16	kMaximumKeySize							=	4096;
const SInt16	kMaximumRSAKeySize						=	2048;
const SInt16	kMinimumDaysBeforeUpdate				=	1;
const SInt16	kMaximumDaysBeforeUpdate				=	999;

const OSType	kPGPInstallerType						=	'APPL';
const OSType	kPGPInstallerCreator					=	'VIS3';
const OSType	kPrefFileType							=	'pref';
const OSType	kPGPKeysCreator							=	'pgpK';

const ResType	kAdminResType							=	'ADMN';
const ResIDT	ADMN_AdminPrefs							=	5001;
const ResIDT	ADMN_ClientPrefs						=	5002;

const ResType	kTextResType		=	'TEXT';
const ResIDT	TEXT_EasyInstall	=	1001;




extern PGPContextRef	gPGPContext;


CAdminDialog::CAdminDialog(
	LStream *	inStream)
		: LGADialog(inStream), mDirty(false)
{
}

CAdminDialog::~CAdminDialog()
{
}

	void
CAdminDialog::FinishCreateSelf()
{
	LGADialog::FinishCreateSelf();
	
	// Listen to controls
	UReanimator::LinkListenerToControls(this, this, RidL_Dialog);
	
	// Add panels to view
	LMultiPanelView *	multiPanel = (LMultiPanelView *)
							FindPaneByID(pane_MultiPanel);
	
	multiPanel->AddPanel(	ppob_CompanyName,
							nil,
							panel_CompanyName);
	multiPanel->AddPanel(	ppob_AdminWizardDescription,
							nil,
							panel_AdminWizardDescription);
	multiPanel->AddPanel(	ppob_ADKDescription,
							nil,
							panel_ADKDescription);
	multiPanel->AddPanel(	ppob_UseIncomingADK,
							nil,
							panel_UseIncomingADK);
	multiPanel->AddPanel(	ppob_ChooseIncomingADK,
							nil,
							panel_ChooseIncomingADK);
	multiPanel->AddPanel(	ppob_UseOutgoingADK,
							nil,
							panel_UseOutgoingADK);
	multiPanel->AddPanel(	ppob_ChooseOutgoingADK,
							nil,
							panel_ChooseOutgoingADK);
	multiPanel->AddPanel(	ppob_UsePGPdiskADK,
							nil,
							panel_UsePGPdiskADK);
	multiPanel->AddPanel(	ppob_ChoosePGPdiskADK,
							nil,
							panel_ChoosePGPdiskADK);
	multiPanel->AddPanel(	ppob_EnforceADKs,
							nil,
							panel_EnforceADKs);
	multiPanel->AddPanel(	ppob_PassphraseMinimums,
							nil,
							panel_PassphraseMinimums);
	multiPanel->AddPanel(	ppob_CorporateKeyOptions,
							nil,
							panel_CorporateKeyOptions);
	multiPanel->AddPanel(	ppob_ChooseCorporateKey,
							nil,
							panel_ChooseCorporateKey);
	multiPanel->AddPanel(	ppob_UseDesignatedRevoker,
							nil,
							panel_UseDesignatedRevoker);
	multiPanel->AddPanel(	ppob_ChooseDesignatedRevoker,
							nil,
							panel_ChooseDesignatedRevoker);
	multiPanel->AddPanel(	ppob_KeyGenerationOptions,
							nil,
							panel_KeyGenerationOptions);
	multiPanel->AddPanel(	ppob_ChooseDefaultKeys,
							nil,
							panel_ChooseDefaultKeys);
	multiPanel->AddPanel(	ppob_AutoUpdating,
							nil,
							panel_AutoUpdating);
	multiPanel->AddPanel(	ppob_MiscOptions,
							nil,
							panel_MiscOptions);
	multiPanel->AddPanel(	ppob_Summary,
							nil,
							panel_Summary);
	multiPanel->AddPanel(	ppob_CopyClientPrefs,
							nil,
							panel_CopyClientPrefs);
	multiPanel->AddPanel(	ppob_ChooseInstaller,
							nil,
							panel_ChooseInstaller);
	multiPanel->AddPanel(	ppob_SaveInstaller,
							nil,
							panel_SaveInstaller);
	multiPanel->AddPanel(	ppob_Finished,
							nil,
							panel_Finished);
	multiPanel->CreateAllPanels();
	
	// Listen to panel broadcasters
	((LCheckBox *) FindPaneByID(
		checkbox_EnforceMinimumPassphraseCharacters))->AddListener(this);
	((LCheckBox *) FindPaneByID(
		checkbox_EnforceMinimumPassphraseQuality))->AddListener(this);
	((LCheckBox *) FindPaneByID(
		checkbox_AutoSignCorporateKey))->AddListener(this);
	((LCheckBox *) FindPaneByID(
		checkbox_AllowKeyGeneration))->AddListener(this);
	((LCheckBox *) FindPaneByID(
		checkbox_UpdateAllKeys))->AddListener(this);
	((LCheckBox *) FindPaneByID(
		checkbox_UpdateTrustedIntroducers))->AddListener(this);
	((LCheckBox *) FindPaneByID(
		button_ChooseInstaller))->AddListener(this);

	// Hide RSA key generation on RSA only builds
	PGPError	pgpErr;
	PGPBoolean	rsaSupported;
	
	pgpErr = PGPRSASupported(&rsaSupported);
	PGPThrowIfPGPErr_(pgpErr);
	
	if (! rsaSupported) {
		FindPaneByID(checkbox_AllowRSAKeyGeneration)->Hide();
	}

	// Set up tables
	PGPFilterRef	filter;
	CKeyTable *		theTable;
	
	pgpErr = PGPNewKeyEncryptAlgorithmFilter(
										gPGPContext, 
										kPGPPublicKeyAlgorithm_ElGamal,
										&filter);
	PGPThrowIfPGPErr_(pgpErr);
	
	// Increase the ref count so that we can use the same filter for three
	// tables
	pgpErr = PGPIncFilterRefCount(filter);
	PGPThrowIfPGPErr_(pgpErr);
	pgpErr = PGPIncFilterRefCount(filter);
	PGPThrowIfPGPErr_(pgpErr);
	
	theTable = (CKeyTable *) FindPaneByID(table_IncomingADK);
	theTable->SetTableInfo(filter, false);
	theTable->AddListener(this);
	
	theTable = (CKeyTable *) FindPaneByID(table_OutgoingADK);
	theTable->SetTableInfo(kInvalidPGPFilterRef, false);
	theTable->AddListener(this);
	theTable = (CKeyTable *) FindPaneByID(table_PGPdiskADK);
	theTable->SetTableInfo(filter, false);
	theTable->AddListener(this);
	theTable = (CKeyTable *) FindPaneByID(table_CorporateKey);
	theTable->SetTableInfo(kInvalidPGPFilterRef, false);
	theTable->AddListener(this);
	theTable = (CKeyTable *) FindPaneByID(table_DesignatedRevoker);
	theTable->SetTableInfo(filter, false);
	theTable->AddListener(this);
	theTable = (CKeyTable *) FindPaneByID(table_DefaultKeys);
	theTable->SetTableInfo(kInvalidPGPFilterRef, true);
	
	// Set panel targets
	((CPanel *) FindPaneByID(pane_CompanyName))->SetPanelTarget(
		(LEditText *) FindPaneByID(edittext_CompanyName));
	((CPanel *) FindPaneByID(pane_KeyGenerationOptions))->SetPanelTarget(
		(LEditText *) FindPaneByID(edittext_MinimumKeySize));
	((CPanel *) FindPaneByID(pane_MiscOptions))->SetPanelTarget(
		(LEditText *) FindPaneByID(edittext_MessageHeaderComment));

	multiPanel->SwitchToPanel(panel_First);
}

	void
CAdminDialog::ListenToMessage(
	MessageT	inMessage,
	void *		ioParam)
{
	(void) ioParam;
	
	switch (inMessage) {
		case msg_Cancel:
		{
			ObeyCommand(cmd_Quit, nil);
		}
		break;

		case msg_Next:
		{
			if (VerifyEditFieldValues()) {
				LMultiPanelView *	multiPanel = (LMultiPanelView *) 
										FindPaneByID(pane_MultiPanel);
				SInt16				currentPanel = multiPanel->
										GetCurrentIndex();
							
				if (currentPanel != panel_SaveInstaller) {
					currentPanel++;
					
					// Skip the unneeded panes
					if (((currentPanel == panel_ChooseIncomingADK)
					&& (! ((LCheckBox *)
					FindPaneByID(checkbox_UseIncomingADK))->
					GetValue() == Button_On))
					|| ((currentPanel == panel_ChooseOutgoingADK)
					&& (! ((LCheckBox *)
					FindPaneByID(checkbox_UseOutgoingADK))->
					GetValue() == Button_On))
					|| ((currentPanel == panel_ChoosePGPdiskADK)
					&& (! ((LCheckBox *)
					FindPaneByID(checkbox_UsePGPdiskADK))->
					GetValue() == Button_On))
					|| ((currentPanel == panel_ChooseCorporateKey)
					&& (! ((LCheckBox *)
					FindPaneByID(checkbox_AutoSignCorporateKey))->
					GetValue() == Button_On))
					|| ((currentPanel == panel_ChooseDesignatedRevoker)
					&& (! ((LCheckBox *)
					FindPaneByID(checkbox_EnableADesignatedRevokerKey))->
					GetValue() == Button_On))) {
						currentPanel++;
					}
					if (currentPanel == panel_EnforceADKs) {
						if (((LCheckBox *)
						FindPaneByID(checkbox_UseIncomingADK))->
						GetValue() == Button_On) {
					  		FindPaneByID(checkbox_EnforceIncomingADK)->
					  			Enable();
					  	} else {
					  		FindPaneByID(checkbox_EnforceIncomingADK)->
					  			Disable();
					  	}
						if (((LCheckBox *)
						FindPaneByID(checkbox_UseOutgoingADK))->
						GetValue() == Button_On) {
					  		FindPaneByID(checkbox_EnforceOutgoingADK)->
					  			Enable();
					  	} else {
					  		FindPaneByID(checkbox_EnforceOutgoingADK)->
					  			Disable();
					  	}
					}
					
					// Update summary panel
					if (currentPanel == panel_Summary) {
						UpdateSummaryPane();
					}
										
					// Show the new panel
					multiPanel->SwitchToPanel(currentPanel);
					
					// Adjust the buttons
					LPane *		buttonNext = FindPaneByID(button_Next);
					CKeyTable *	theTable = nil;
					
					switch (currentPanel) {
						case panel_ChooseIncomingADK:
						{
							theTable = (CKeyTable *)
								FindPaneByID(table_IncomingADK);
						}
						break;
						
						
						case panel_ChooseOutgoingADK:
						{
							theTable = (CKeyTable *)
								FindPaneByID(table_OutgoingADK);
						}
						break;
						
						
						case panel_ChoosePGPdiskADK:
						{
							theTable = (CKeyTable *)
								FindPaneByID(table_PGPdiskADK);
						}
						break;


						case panel_ChooseCorporateKey:
						{
							theTable = (CKeyTable *)
								FindPaneByID(table_CorporateKey);
						}
						break;
						
						case panel_ChooseDesignatedRevoker:
						{
							theTable = (CKeyTable *)
								FindPaneByID(table_DesignatedRevoker);
						}
						break;
						
						case panel_ChooseInstaller:
						{
							CString	descriptor;
							
							FindPaneByID(statictext_Installer)->
								GetDescriptor(descriptor);
							if (descriptor.GetLength() == 0) {
								buttonNext->Disable();
							} else {
								buttonNext->Enable();
							}
						}
						break;
					}
					if (theTable != nil) {
						if (theTable->GetFirstSelectedCell().IsNullCell()) {
							buttonNext->Disable();
						} else {
							buttonNext->Enable();
						}
					}
					FindPaneByID(button_Previous)->Enable();
					if (currentPanel == panel_SaveInstaller) {
						buttonNext->SetDescriptor(CString(STRx_AdminStrings,
														kSaveButtonStringID));
					}
				} else {
					// Save the options
					Save();
				}
			}
		}
		break;


		case msg_Previous:
		{
			if (VerifyEditFieldValues()) {
				LMultiPanelView *	multiPanel = (LMultiPanelView *) 
										FindPaneByID(pane_MultiPanel);
				SInt16				currentPanel = multiPanel->
										GetCurrentIndex() - 1;

				// Skip the unneeded panes
				if (((currentPanel == panel_ChooseIncomingADK)
				&& (! ((LCheckBox *)
				FindPaneByID(checkbox_UseIncomingADK))->
				GetValue() == Button_On))
				|| ((currentPanel == panel_ChooseOutgoingADK)
				&& (! ((LCheckBox *) FindPaneByID(checkbox_UseOutgoingADK))->
				GetValue() == Button_On))
				|| ((currentPanel == panel_ChoosePGPdiskADK)
				&& (! ((LCheckBox *) FindPaneByID(checkbox_UsePGPdiskADK))->
				GetValue() == Button_On))
				|| ((currentPanel == panel_ChooseCorporateKey)
				&& (! ((LCheckBox *)
				FindPaneByID(checkbox_AutoSignCorporateKey))->
				GetValue() == Button_On))
				|| ((currentPanel == panel_ChooseDesignatedRevoker)
				&& (! ((LCheckBox *)
				FindPaneByID(checkbox_EnableADesignatedRevokerKey))->
				GetValue() == Button_On))) {
					currentPanel--;
				}
				
				// Update summary panel
				if (currentPanel == panel_Summary) {
					UpdateSummaryPane();
				}

				// Show the new panel
				multiPanel->SwitchToPanel(currentPanel);

				// Adjust the buttons
				LPane *	buttonNext = FindPaneByID(button_Next);
				
				if (currentPanel != panel_SaveInstaller) {
					buttonNext->SetDescriptor(CString(	STRx_AdminStrings,
														kNextButtonStringID));
				}
				buttonNext->Enable();
				if (currentPanel == panel_First) {
					FindPaneByID(button_Previous)->Disable();
				}
				SetDefaultButton(button_Next);
			}
		}
		break;
		
		
		case msg_EnforceMinimumPassphraseCharacters:
		{
			LCheckBox *	theCheckbox = (LCheckBox *) FindPaneByID(
							checkbox_EnforceMinimumPassphraseCharacters);
			LEditText *	theEditField = (LEditText *) FindPaneByID(
							edittext_MinimumPassphraseCharacters);
									
			if (theCheckbox->GetValue() == Button_On) {
				theEditField->Enable();
				SwitchTarget(theEditField);
			} else {
				theEditField->Disable();
			}
		}
		break;
		
		
		case msg_EnforceMinimumPassphraseQuality:
		{
			LCheckBox *	theCheckbox = (LCheckBox *) FindPaneByID(
							checkbox_EnforceMinimumPassphraseQuality);
			LEditText *	theEditField = (LEditText *) FindPaneByID(
							edittext_MinimumPassphraseQuality);
								
			if (theCheckbox->GetValue() == Button_On) {
				theEditField->Enable();
				SwitchTarget(theEditField);
			} else {
				theEditField->Disable();
			}
		}
		break;
		
		
		case msg_UpdateAllKeys:
		{
			LCheckBox *	theCheckbox = (LCheckBox *) FindPaneByID(
							checkbox_UpdateAllKeys);
			LEditText *	theEditField = (LEditText *) FindPaneByID(
							edittext_UpdateAllKeys);
								
			if (theCheckbox->GetValue() == Button_On) {
				theEditField->Enable();
				SwitchTarget(theEditField);
			} else {
				theEditField->Disable();
			}
		}
		break;



		case msg_UpdateTrustedIntroducers:
		{
			LCheckBox *	theCheckbox = (LCheckBox *) FindPaneByID(
							checkbox_UpdateTrustedIntroducers);
			LEditText *	theEditField = (LEditText *) FindPaneByID(
							edittext_UpdateTrustedIntroducers);
								
			if (theCheckbox->GetValue() == Button_On) {
				theEditField->Enable();
				SwitchTarget(theEditField);
			} else {
				theEditField->Disable();
			}
		}
		break;



		case msg_IncomingADKTable:
		case msg_OutgoingADKTable:
		case msg_PGPdiskADKTable:
		case msg_CorporateKeyTable:
		case msg_DesignatedRevokerTable:
		{
			CKeyTable *	theTable;
			
			switch (inMessage) {
				case msg_IncomingADKTable:
				{
					theTable = (CKeyTable *) FindPaneByID(table_IncomingADK);
				}
				break;
				
				
				case msg_OutgoingADKTable:
				{
					theTable = (CKeyTable *) FindPaneByID(table_OutgoingADK);
				}
				break;


				case msg_PGPdiskADKTable:
				{
					theTable = (CKeyTable *) FindPaneByID(table_PGPdiskADK);
				}
				break;


				case msg_CorporateKeyTable:
				{
					theTable = (CKeyTable *)
						FindPaneByID(table_CorporateKey);
				}
				break;

				case msg_DesignatedRevokerTable:
				{
					theTable = (CKeyTable *)
						FindPaneByID(table_DesignatedRevoker);
				}
				break;
			}
			if (theTable->GetFirstSelectedCell().IsNullCell()) {
				FindPaneByID(button_Next)->Disable();
			} else {
				FindPaneByID(button_Next)->Enable();
			}
		}
		break;
		
		
		case msg_AllowKeyGeneration:
		{
			if (((LCheckBox *) FindPaneByID(checkbox_AllowKeyGeneration))->
			GetValue() == Button_On) {
				LEditText *	editTextMinimumKeySize = (LEditText *)
								FindPaneByID(edittext_MinimumKeySize);
				
				FindPaneByID(checkbox_AllowRSAKeyGeneration)->Enable();
				editTextMinimumKeySize->Enable();
				SwitchTarget(editTextMinimumKeySize);
			} else {
				FindPaneByID(checkbox_AllowRSAKeyGeneration)->Disable();
				FindPaneByID(edittext_MinimumKeySize)->Disable();
			}
		}
		break;

		
		case msg_AutoSignCorporateKey:
		{
			if (((LCheckBox *) FindPaneByID(checkbox_AutoSignCorporateKey))->
			GetValue() == Button_On) {
				FindPaneByID(checkbox_WarnIfNotSignedByCorporateKey)->
					Enable();
				FindPaneByID(checkbox_CorporateKeyIsMetaIntroducer)->
					Enable();
			} else {
				FindPaneByID(checkbox_WarnIfNotSignedByCorporateKey)->
					Disable();
				FindPaneByID(checkbox_CorporateKeyIsMetaIntroducer)->
					Disable();
			}
		}
		break;
		
		
		case msg_ChooseInstaller:
		{
			StandardFileReply	reply;
			UniversalProcPtr	fileFilterUPP;
			OSStatus			err;
		
			// Find the installer
			if (FindApplication(kPGPInstallerType, kPGPInstallerCreator,
				kFindAppOnAllVolumes, &mBaseInstallerSpec)) {
				::LMSetSFSaveDisk(-mBaseInstallerSpec.vRefNum);
				::LMSetCurDirStore(mBaseInstallerSpec.parID);
			}
			
			fileFilterUPP = NewFileFilterProc(InstallerFileFilter);
			::StandardGetFile(	fileFilterUPP,
								1,
								&kPGPInstallerType,
								&reply);
			DisposeRoutineDescriptor(fileFilterUPP);
			if (reply.sfGood) {
				CString			descriptor;
				LPane *			baseInstallerCaption =
									FindPaneByID(statictext_Installer);
				
				mBaseInstallerSpec = reply.sfFile;
				err = FSpGetFullPath(&mBaseInstallerSpec, descriptor);
				PGPThrowIfOSErr_(err);
				baseInstallerCaption->SetDescriptor(descriptor);
				FindPaneByID(button_Next)->Enable();
			}
		}
		break;
	}
}

	Boolean
CAdminDialog::AttemptQuitSelf(
	SInt32	inSaveOption)
{
	(void) inSaveOption;
	
	if (mDirty) {
		::SysBeep(0);
	}
	return ! mDirty;
}



	Boolean
CAdminDialog::VerifyEditFieldValues()
{
	Boolean			result = true;
	LEditText *		theEditField;
	SInt16			theValue;
	SInt16			stringID = 0;
	SInt16			minimum;
	SInt16			maximum;
	SInt16			currentPanel = ((LMultiPanelView *) FindPaneByID(
										pane_MultiPanel))->GetCurrentIndex();
	
	// Test the fields
	switch (currentPanel) {
		case panel_PassphraseMinimums:
		{
			theEditField = (LEditText *) FindPaneByID(
								edittext_MinimumPassphraseCharacters);
			theValue = theEditField->GetValue();
			if (theEditField->IsEnabled() &&
			((theValue < kMinimumPassphraseCharacters) ||
			(theValue > kMaximumPassphraseCharacters))) {
				result = false;
				stringID = kMinimumPassphraseCharactersStringID;
				minimum = kMinimumPassphraseCharacters;
				maximum = kMaximumPassphraseCharacters;
			} else {
				theEditField = (LEditText *) FindPaneByID(
									edittext_MinimumPassphraseQuality);
				theValue = theEditField->GetValue();
				if (theEditField->IsEnabled() &&
				((theValue < kMinimumPassphraseQuality) ||
				(theValue > kMaximumPassphraseQuality))) {
					result = false;
					stringID = kMinimumPassphraseQualityStringID;
					minimum = kMinimumPassphraseQuality;
					maximum = kMaximumPassphraseQuality;
				}
			}
		} 
		break;
		
		
		case panel_KeyGenerationOptions:
		{
			Boolean	hasRSAGeneration = ((LCheckBox *) FindPaneByID(
						checkbox_AllowRSAKeyGeneration))->
						GetValue() == Button_On;
			SInt16	maxKeySize = hasRSAGeneration ? kMaximumRSAKeySize :
									kMaximumKeySize;
			
			theEditField = (LEditText *) FindPaneByID(
											edittext_MinimumKeySize);
			theValue = theEditField->GetValue();
										
			if (theEditField->IsEnabled() &&
			((theValue < kMinimumKeySize) ||
			(theValue > maxKeySize)))
			{
				result = false;
				
				if( hasRSAGeneration )
				{
					stringID = kMinimumRSAKeySizeStringID;
				}
				else
				{
					stringID = kMinimumKeySizeStringID;
				}
				
				minimum = kMinimumKeySize;
				maximum = maxKeySize;
			}
		}
		break;


		case panel_AutoUpdating:
		{
			theEditField = (LEditText *) FindPaneByID(
								edittext_UpdateAllKeys);
			theValue = theEditField->GetValue();
			if (theEditField->IsEnabled() &&
			((theValue < kMinimumDaysBeforeUpdate) ||
			(theValue > kMaximumDaysBeforeUpdate))) {
				result = false;
			} else {
				theEditField = (LEditText *) FindPaneByID(
									edittext_UpdateTrustedIntroducers);
				theValue = theEditField->GetValue();
				if (theEditField->IsEnabled() &&
				((theValue < kMinimumDaysBeforeUpdate) ||
				(theValue > kMaximumDaysBeforeUpdate))) {
					result = false;
				}
			}
			if (result == false) {
				stringID = kMinimumNumberOfDaysStringID;
				minimum = kMinimumDaysBeforeUpdate;
				maximum = kMaximumDaysBeforeUpdate;
			}
		} 
		break;
	}
	
	
	// Handle bad compare
	if (result == false ) {
		::SysBeep(0);
		CWarningAlert::Display(	kWAStopAlertType,
								kWAOKStyle,
								CString(STRx_AdminStrings,
										stringID),
								CString(minimum),
								CString(maximum));
		SwitchTarget(theEditField);
		theEditField->SelectAll();
	}
		
	return result;
}

	Boolean
CAdminDialog::Save()
{
	Boolean				result = false;
	StandardFileReply	reply;
	OSStatus			err;
	CString				savedName(mBaseInstallerSpec.name);
	
	strcat(savedName, CString(STRx_AdminStrings, kSavedNameSuffixStringID));
	// Choose where to save the copy
	::StandardPutFile(	CString(STRx_AdminStrings, kSavePromptStringID),
						savedName,
						&reply);
	if (reply.sfGood) {
	
		// Create a copy of the file
		if (! FSpEqual(&mBaseInstallerSpec, &reply.sfFile)) {
			if (reply.sfReplacing) {
				err = ::FSpDelete(&reply.sfFile);
				PGPThrowIfOSErr_(err);
			}
			err = FSpCopyFiles(PGPGetContextMemoryMgr(gPGPContext),
						&mBaseInstallerSpec, &reply.sfFile);
			PGPThrowIfOSErr_(err);
		}

		// Open temp pref file
		PGPPrefRef			prefRef = kInvalidPGPPrefRef;
		PFLFileSpecRef		tempSpecRef = kInvalidPFLFileSpecRef;
		PFLFileSpecRef		prefFileSpec = kInvalidPFLFileSpecRef;
		
		try {
			CTempFile			tempFile(kPGPKeysCreator, kPrefFileType);
			PGPError			pgpErr;
			FSSpec				tempSpec;
			StHandleBlock		handle((Size) 0);
			StHandleBlock		keyHandle((Size) 0);
			CString				edittextString;
			Boolean				isSelected;
			CKeyTable *			keyTable;
			PGPKeyID			keyID;
			PGPByte				exportedID[kPGPMaxExportedKeyIDSize];
			PGPSize				size;
			SInt32				algorithm;
			
			tempFile.GetSpecifier(tempSpec);
			pgpErr = PFLNewFileSpecFromFSSpec(
						PGPGetContextMemoryMgr(gPGPContext),
						&tempSpec,
						&tempSpecRef);
			PGPThrowIfPGPErr_(pgpErr);
			pgpErr = PGPOpenPrefFile(	tempSpecRef,
										NULL,
										0, 
							  			&prefRef);
			PGPThrowIfPGPErr_(pgpErr);
			
			// Write prefs to file
			FindPaneByID(edittext_CompanyName)->
				GetDescriptor(edittextString);
			if (edittextString.GetLength() != 0) {
				pgpErr = PGPSetPrefString(	prefRef,
											kPGPPrefAdminCompanyName,
											edittextString);
				PGPThrowIfPGPErr_(pgpErr);
			}
			
			isSelected = ((LCheckBox *) FindPaneByID(checkbox_UseIncomingADK))->
							GetValue() == Button_On;
			pgpErr = PGPSetPrefBoolean(	prefRef,
						kPGPPrefUseDHADK,
						isSelected);
			PGPThrowIfPGPErr_(pgpErr);
			if (isSelected) {
				try {
					keyTable = (CKeyTable *) FindPaneByID(table_IncomingADK);
					keyTable->GetSelectedKeys(keyHandle);
					::HandAndHand(keyHandle, handle);
					PGPThrowIfMemError_();
					keyTable->GetFirstSelectedKeyID(&keyID);
					pgpErr = PGPExportKeyID(	&keyID,
												exportedID,
												&size);
					PGPThrowIfPGPErr_(pgpErr);
					pgpErr = PGPSetPrefData(	prefRef, 
												kPGPPrefDHADKID, 
									 			size, 
												exportedID);
					PGPThrowIfPGPErr_(pgpErr);
				}
				
				catch (...) {
					throw;
				}
			}

			isSelected = ((LCheckBox *) FindPaneByID(checkbox_UseOutgoingADK))->
							GetValue() == Button_On;
			pgpErr = PGPSetPrefBoolean(	prefRef,
						kPGPPrefUseOutgoingADK,
						isSelected);
			PGPThrowIfPGPErr_(pgpErr);
			if (isSelected) {
				try {
					keyTable = (CKeyTable *) FindPaneByID(table_OutgoingADK);
					keyTable->GetSelectedKeys(keyHandle);
					::HandAndHand(keyHandle, handle);
					PGPThrowIfMemError_();
					keyTable->GetFirstSelectedKeyID(&keyID,
													&algorithm);
					pgpErr = PGPExportKeyID(	&keyID,
												exportedID,
												&size);
					PGPThrowIfPGPErr_(pgpErr);
					pgpErr = PGPSetPrefData(	prefRef, 
												kPGPPrefOutgoingADKID, 
									 			size, 
												exportedID);
					PGPThrowIfPGPErr_(pgpErr);
					pgpErr = PGPSetPrefNumber(	prefRef,
												kPGPPrefOutADKPublicKeyAlgorithm,
												algorithm);
					PGPThrowIfPGPErr_(pgpErr);
				}
				
				catch (...) {
					throw;
				}
			}

			isSelected = ((LCheckBox *) FindPaneByID(checkbox_UsePGPdiskADK))->
							GetValue() == Button_On;
			pgpErr = PGPSetPrefBoolean(	prefRef,
						kPGPPrefUsePGPdiskADK,
						isSelected);
			PGPThrowIfPGPErr_(pgpErr);
			if (isSelected) {
				try {
					keyTable = (CKeyTable *) FindPaneByID(table_PGPdiskADK);
					keyTable->GetSelectedKeys(keyHandle);
					::HandAndHand(keyHandle, handle);
					PGPThrowIfMemError_();
					keyTable->GetFirstSelectedKeyID(&keyID);
					pgpErr = PGPExportKeyID(	&keyID,
												exportedID,
												&size);
					PGPThrowIfPGPErr_(pgpErr);
					pgpErr = PGPSetPrefData(	prefRef, 
												kPGPPrefPGPdiskADKKeyID, 
									 			size, 
												exportedID);
					PGPThrowIfPGPErr_(pgpErr);
				}
				
				catch (...) {
					throw;
				}
			}
			
			pgpErr = PGPSetPrefBoolean(	prefRef,
										kPGPPrefEnforceIncomingADK,
										((LCheckBox *) FindPaneByID(
											checkbox_EnforceIncomingADK))->
											GetValue() == Button_On);
			PGPThrowIfPGPErr_(pgpErr);
			pgpErr = PGPSetPrefBoolean(	prefRef,
										kPGPPrefEnforceOutgoingADK,
										((LCheckBox *) FindPaneByID(
											checkbox_EnforceOutgoingADK))->
											GetValue() == Button_On);
			PGPThrowIfPGPErr_(pgpErr);
			pgpErr = PGPSetPrefBoolean(	prefRef,
										kPGPPrefEnforceRemoteADKClass,
										((LCheckBox *) FindPaneByID(
											checkbox_EnforceRemoteADKStrictness))
											->GetValue() == Button_On);
			PGPThrowIfPGPErr_(pgpErr);
			
			isSelected = ((LCheckBox *) FindPaneByID(
							checkbox_EnforceMinimumPassphraseCharacters))->
							GetValue() == Button_On;
			pgpErr = PGPSetPrefBoolean(	prefRef,
										kPGPPrefEnforceMinChars,
										isSelected);
			PGPThrowIfPGPErr_(pgpErr);
			if (isSelected) {
				pgpErr = PGPSetPrefNumber(
							prefRef,
							kPGPPrefMinChars,
							FindPaneByID(edittext_MinimumPassphraseCharacters)->
								GetValue());
				PGPThrowIfPGPErr_(pgpErr);
			}

			isSelected = ((LCheckBox *) FindPaneByID(
							checkbox_EnforceMinimumPassphraseQuality))->
							GetValue() == Button_On;
			pgpErr = PGPSetPrefBoolean(	prefRef,
										kPGPPrefEnforceMinQuality,
										isSelected);
			PGPThrowIfPGPErr_(pgpErr);
			if (isSelected) {
				pgpErr = PGPSetPrefNumber(
							prefRef,
							kPGPPrefMinQuality,
							FindPaneByID(edittext_MinimumPassphraseQuality)->
								GetValue());
				PGPThrowIfPGPErr_(pgpErr);
			}

			isSelected = ((LCheckBox *) FindPaneByID(
							checkbox_AutoSignCorporateKey))->
							GetValue() == Button_On;
			pgpErr = PGPSetPrefBoolean(	prefRef,
										kPGPPrefAutoSignTrustCorp,
										isSelected);
			PGPThrowIfPGPErr_(pgpErr);

			pgpErr = PGPSetPrefBoolean(
						prefRef,
						kPGPPrefWarnNotCertByCorp,
						isSelected && ((LCheckBox *) FindPaneByID(
							checkbox_WarnIfNotSignedByCorporateKey))->
							GetValue() == Button_On);
			PGPThrowIfPGPErr_(pgpErr);

			pgpErr = PGPSetPrefBoolean(
						prefRef,
						kPGPPrefMetaIntroducerCorp,
						isSelected && ((LCheckBox *) FindPaneByID(
							checkbox_CorporateKeyIsMetaIntroducer))->
							GetValue() == Button_On);
			PGPThrowIfPGPErr_(pgpErr);

					
			keyTable = (CKeyTable *) FindPaneByID(table_CorporateKey);
			keyTable->GetSelectedKeys(keyHandle);
			if (::GetHandleSize(keyHandle) != 0) {
				try {
					::HandAndHand(keyHandle, handle);
					PGPThrowIfMemError_();
					keyTable->GetFirstSelectedKeyID(&keyID,
													&algorithm);
					pgpErr = PGPExportKeyID(	&keyID,
												exportedID,
												&size);
					PGPThrowIfPGPErr_(pgpErr);
					pgpErr = PGPSetPrefData(	prefRef, 
												kPGPPrefCorpKeyID, 
									 			size, 
												exportedID);
					PGPThrowIfPGPErr_(pgpErr);
					pgpErr = PGPSetPrefNumber(	prefRef,
												kPGPPrefCorpKeyPublicKeyAlgorithm,
												algorithm);
					PGPThrowIfPGPErr_(pgpErr);
				}
				
				catch (...) {
					throw;
				}
			}

			isSelected = ((LCheckBox *) FindPaneByID(
							checkbox_EnableADesignatedRevokerKey))->
							GetValue() == Button_On;
			pgpErr = PGPSetPrefBoolean(	prefRef,
						kPGPPrefAutoAddRevoker,
						isSelected);
			PGPThrowIfPGPErr_(pgpErr);
			if (isSelected) {
				try {
					keyTable = (CKeyTable *) FindPaneByID(
							table_DesignatedRevoker);
					keyTable->GetSelectedKeys(keyHandle);
					::HandAndHand(keyHandle, handle);
					PGPThrowIfMemError_();
					keyTable->GetFirstSelectedKeyID(&keyID,
													&algorithm);
					pgpErr = PGPExportKeyID(	&keyID,
												exportedID,
												&size);
					PGPThrowIfPGPErr_(pgpErr);
					pgpErr = PGPSetPrefData(	prefRef, 
												kPGPPrefRevokerKeyID, 
									 			size, 
												exportedID);
					PGPThrowIfPGPErr_(pgpErr);
					pgpErr = PGPSetPrefNumber(
								prefRef,
								kPGPPrefRevokerPublicKeyAlgorithm,
								algorithm);
					PGPThrowIfPGPErr_(pgpErr);
				}
				
				catch (...) {
					throw;
				}
			}

			isSelected = ((LCheckBox *) FindPaneByID(
				checkbox_AllowKeyGeneration))->GetValue() == Button_On;
			pgpErr = PGPSetPrefBoolean(	prefRef,
										kPGPPrefAllowKeyGen,
										isSelected);
			PGPThrowIfPGPErr_(pgpErr);

			pgpErr = PGPSetPrefBoolean(	prefRef,
										kPGPPrefAllowRSAKeyGen,
										isSelected && ((LCheckBox *)
											FindPaneByID(
											checkbox_AllowRSAKeyGeneration))->
											GetValue() == Button_On);
			PGPThrowIfPGPErr_(pgpErr);
			if (isSelected) {
				pgpErr = PGPSetPrefNumber(	prefRef,
											kPGPPrefMinimumKeySize,
											FindPaneByID(
												edittext_MinimumKeySize)->
												GetValue());
				PGPThrowIfPGPErr_(pgpErr);
			}

			((CKeyTable *) FindPaneByID(table_DefaultKeys))->
				GetSelectedKeys(keyHandle);
			::HandAndHand(handle, keyHandle);
			PGPThrowIfMemError_();
			if (::GetHandleSize(keyHandle) != 0) {
				::HLock(keyHandle);
				pgpErr = PGPSetPrefData(	prefRef, 
											kPGPPrefDefaultKeys, 
								 			::GetHandleSize(keyHandle), 
								 			*keyHandle);
				::HUnlock(keyHandle);
				PGPThrowIfPGPErr_(pgpErr);
			}
			
			isSelected = ((LCheckBox *) FindPaneByID(
							checkbox_UpdateAllKeys))->
							GetValue() == Button_On;
			pgpErr = PGPSetPrefBoolean(	prefRef,
										kPGPPrefUpdateAllKeys,
										isSelected);
			PGPThrowIfPGPErr_(pgpErr);
			if (isSelected) {
				pgpErr = PGPSetPrefNumber(
							prefRef,
							kPGPPrefDaysUpdateAllKeys,
							FindPaneByID(edittext_UpdateAllKeys)->
								GetValue());
				PGPThrowIfPGPErr_(pgpErr);
			}

			isSelected = ((LCheckBox *) FindPaneByID(
							checkbox_UpdateTrustedIntroducers))->
							GetValue() == Button_On;
			pgpErr = PGPSetPrefBoolean(	prefRef,
										kPGPPrefUpdateTrustedIntroducers,
										isSelected);
			PGPThrowIfPGPErr_(pgpErr);
			if (isSelected) {
				pgpErr = PGPSetPrefNumber(
							prefRef,
							kPGPPrefDaysUpdateTrustedIntroducers,
							FindPaneByID(edittext_UpdateTrustedIntroducers)->
								GetValue());
				PGPThrowIfPGPErr_(pgpErr);
			}
			

			pgpErr = PGPSetPrefBoolean(
						prefRef,
						kPGPPrefAllowConventionalEncryption,
						((LCheckBox *) FindPaneByID(
							checkbox_AllowConventionalEncryption))->
							GetValue() == Button_On);
			PGPThrowIfPGPErr_(pgpErr);
			
			FindPaneByID(edittext_MessageHeaderComment)->
				GetDescriptor(edittextString);
			if (edittextString.GetLength() != 0) {
				pgpErr = PGPSetPrefString(	prefRef,
											kPGPPrefComments,
											edittextString);
				PGPThrowIfPGPErr_(pgpErr);
			}

			// Save the admin prefs file and copy it to the resource fork
			// of the installer
			pgpErr = PGPSavePrefFile(prefRef);
			PGPThrowIfPGPErr_(pgpErr);
			pgpErr = PGPClosePrefFile(prefRef);
			prefRef = kInvalidPGPPrefRef;
			PGPThrowIfPGPErr_(pgpErr);
			err = CopyFileToResource(	&tempSpec,
										&reply.sfFile,
										kAdminResType,
										ADMN_AdminPrefs);
			PGPThrowIfOSErr_(err);
			
			// Replace the %adminstr% in the installer
			FindPaneByID(edittext_CompanyName)->
				GetDescriptor(edittextString);
			err = AddCompanyNameToInstaller(&reply.sfFile, edittextString);
			PGPThrowIfOSErr_(err);
			
			// Copy admin prefs to current machine's admin prefs
			FSSpec	adminPrefs;
			
			pgpErr = PGPOpenAdminPrefs(	PGPGetContextMemoryMgr(gPGPContext),
										&prefRef);
			PGPThrowIfPGPErr_(pgpErr);
			pgpErr = PGPGetPrefFileSpec(	prefRef,
											&prefFileSpec);
			PGPThrowIfPGPErr_(pgpErr);
			pgpErr = PGPClosePrefFile(prefRef);
			prefRef = kInvalidPGPPrefRef;
			PGPThrowIfPGPErr_(pgpErr);
			pgpErr = PFLGetFSSpecFromFileSpec(	prefFileSpec,
												&adminPrefs);
			PGPThrowIfPGPErr_(pgpErr);
			PFLFreeFileSpec(prefFileSpec);
			prefFileSpec = kInvalidPFLFileSpecRef;
			err = FSpCopyFiles(PGPGetContextMemoryMgr(gPGPContext),
						&tempSpec, &adminPrefs);
			PGPThrowIfOSErr_(err);							
			
			// Copy the current client prefs to the resource fork of the
			// installer
			if (((LCheckBox *) FindPaneByID(checkbox_CopyClientPrefs))->
					GetValue() == Button_On) {
				FSSpec			clientPrefs;
				
				pgpErr = PGPOpenClientPrefs(PGPGetContextMemoryMgr(gPGPContext),
											&prefRef);
				PGPThrowIfPGPErr_(pgpErr);
				pgpErr = PGPGetPrefFileSpec(	prefRef,
												&prefFileSpec);
				PGPThrowIfPGPErr_(pgpErr);
				pgpErr = PGPClosePrefFile(prefRef);
				prefRef = kInvalidPGPPrefRef;
				PGPThrowIfPGPErr_(pgpErr);
				pgpErr = PFLGetFSSpecFromFileSpec(	prefFileSpec,
													&clientPrefs);
				err = FSpCopyFiles(PGPGetContextMemoryMgr(gPGPContext),
							&clientPrefs, &tempSpec);
				PGPThrowIfOSErr_(err);
				PFLFreeFileSpec(prefFileSpec);
				prefFileSpec = kInvalidPFLFileSpecRef;
				pgpErr = PGPOpenPrefFile(	tempSpecRef, 
											NULL,
											0,
								  			&prefRef);
				PGPThrowIfPGPErr_(pgpErr);
				pgpErr = PGPSetPrefNumber(	prefRef,
											kPGPPrefDateOfLastSplashScreen,
											0);
				PGPThrowIfPGPErr_(pgpErr);
				pgpErr = PGPSetPrefString(	prefRef,
											kPGPPrefOwnerName,
											"");
				PGPThrowIfPGPErr_(pgpErr);
				pgpErr = PGPSetPrefString(	prefRef,
											kPGPPrefCompanyName,
											"");
				PGPThrowIfPGPErr_(pgpErr);
				pgpErr = PGPSetPrefString(	prefRef,
											kPGPPrefLicenseNumber,
											"");
				PGPThrowIfPGPErr_(pgpErr);
				pgpErr = PGPSetPrefBoolean(	prefRef,
											kPGPPrefFirstKeyGenerated,
											false);
				PGPThrowIfPGPErr_(pgpErr);
				PGPRemovePref(	prefRef, 
								kPGPPrefPGPtoolsMacPrivateData);
				PGPRemovePref(	prefRef, 
								kPGPPrefPGPkeysMacMainWinPos);
				PGPRemovePref(	prefRef, 
								kPGPPrefPGPkeysMacColumnData);
				pgpErr = PGPSavePrefFile(prefRef);
				PGPThrowIfPGPErr_(pgpErr);
				pgpErr = PGPClosePrefFile(prefRef);
				prefRef = kInvalidPGPPrefRef;
				PGPThrowIfPGPErr_(pgpErr);
				err = CopyFileToResource(	&tempSpec,
											&reply.sfFile,
											kAdminResType,
											ADMN_ClientPrefs);
				PGPThrowIfOSErr_(err);
			}

			// switch to next panel
			LMultiPanelView *	multiPanel = (LMultiPanelView *) FindPaneByID(
									pane_MultiPanel);
									
			multiPanel->SwitchToPanel(multiPanel->GetCurrentIndex() + 1);
			FindPaneByID(button_Next)->Disable();
			SetDefaultButton(button_Quit);
			
			PFLFreeFileSpec(tempSpecRef);
			result = true;
		}
		
		catch (...) {
			if (PFLFileSpecRefIsValid(prefFileSpec)) {
				PFLFreeFileSpec(prefFileSpec);
			}
			if (PFLFileSpecRefIsValid(tempSpecRef)) {
				PFLFreeFileSpec(tempSpecRef);
			}
			if (PGPPrefRefIsValid(prefRef)) {
				PGPClosePrefFile(prefRef);
			}
			throw;
		}
	}
	
	return result;		
}

	OSStatus
CAdminDialog::CopyFileToResource(
	FSSpec *	inFileSpec,
	FSSpec *	inResourceFileSpec,
	ResType		inType,
	ResIDT		inID)
{
	OSStatus	result;
	SInt16		resourceForkRefNum = -1;
	SInt16		fileRefNum = -1;
	
	try {
		StHandleBlock	handle((Size) 0);
	
		// Open the files
		::SetResLoad(false);
		resourceForkRefNum = ::FSpOpenResFile(inResourceFileSpec, fsRdWrPerm);
		::SetResLoad(true);
		PGPThrowIfResError_();
		result = ::FSpOpenDF(inFileSpec, fsRdPerm, &fileRefNum);
		PGPThrowIfOSErr_(result);
		
		// Add the resource if it doesn't already exist
		if (! ResourceExists(inType, inID, true)) {
			::AddResource(	handle,
							inType,
							inID,
							"\p");
			PGPThrowIfResError_();
			::UpdateResFile(resourceForkRefNum);
			PGPThrowIfResError_();
			::DetachResource(handle);
			PGPThrowIfResError_();
		}
		::SetHandleSize(handle, 1024);
		::SetResLoad(false);
		
		Handle			theResource = ::GetResource(inType, inID);
		StHandleLocker	theLock(handle);
		SInt32			count = 1024;
		SInt32			offset = 0;
		SInt32			dataLength;
		
		::SetResLoad(true);
		result = ::GetEOF(fileRefNum, &dataLength);
		PGPThrowIfOSErr_(result);
		::SetResourceSize(theResource, dataLength);
		PGPThrowIfResError_();
		do {
			result = ::FSRead(fileRefNum, &count, *handle);
			
			if ((result == noErr) || (result == eofErr)) {
				::WritePartialResource(	theResource,
										offset,
										*handle,
										count);
				PGPThrowIfResError_();
				offset += count;
			} else {
				PGPThrowOSErr_(result);
			}
		} while (result == noErr);
		::UpdateResFile(resourceForkRefNum);
		PGPThrowIfResError_();
		result = noErr;
	}
	
	catch (CComboError & exception) {
		result = exception.err;
	}
	
	catch (...) {
		result = fnfErr;
	}
	
	if (resourceForkRefNum != -1) {
		::CloseResFile(resourceForkRefNum);
		::FlushVol(nil, inResourceFileSpec->vRefNum);
	}
	if (fileRefNum != -1) {
		::FSClose(fileRefNum);
	}
	
	return result;
}

	pascal Boolean
CAdminDialog::InstallerFileFilter(
	CInfoPBPtr	inPB,
	Ptr			inDataP)
{
	(void) inDataP;
	
	Boolean	result = true;
	
	if (cpbFileCreator(inPB) == kPGPInstallerCreator) {
		result = false;
	}
	
	return result;
}



	void
CAdminDialog::UpdateSummaryPane()
{
	CString		none(STRx_AdminStrings, kNoneStringID);
	CString		tab(STRx_AdminStrings, kTabStringID);
	CString		data;
	Boolean		temp;
	PGPError	pgpErr;
	Handle		theSummary = ::NewHandle(0);
	
	// Add site license
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kCompanyNameStringID));
	FindPaneByID(edittext_CompanyName)->GetDescriptor(data);
	if (data.GetLength() != 0) {
		AppendStringToHandle(theSummary, data);
	} else {
		AppendStringToHandle(theSummary, none);
	}
	
	// Add Incoming ADK
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kIncomingADKStringID));
	if (FindPaneByID(checkbox_UseIncomingADK)->GetValue() == Button_On) {
		((CKeyTable *) FindPaneByID(table_IncomingADK))->
			GetFirstSelectedUserID(data);
		AppendStringToHandle(theSummary, data);
		if (FindPaneByID(checkbox_EnforceIncomingADK)->GetValue()
		== Button_On) {
			AppendStringToHandle(	theSummary,
									CString(	STRx_AdminStrings,
												kEnforcedStringID));
		} else {
			AppendStringToHandle(	theSummary,
									CString(	STRx_AdminStrings,
												kNotEnforcedStringID));
		}
	} else {
		AppendStringToHandle(theSummary, none);
	}

	// Add Outgoing ADK
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kOutgoingADKStringID));
	if (FindPaneByID(checkbox_UseOutgoingADK)->GetValue() == Button_On) {
		((CKeyTable *) FindPaneByID(table_OutgoingADK))->
			GetFirstSelectedUserID(data);
		AppendStringToHandle(theSummary, data);
		if (FindPaneByID(checkbox_EnforceOutgoingADK)->GetValue()
		== Button_On) {
			AppendStringToHandle(	theSummary,
									CString(	STRx_AdminStrings,
												kEnforcedStringID));
		} else {
			AppendStringToHandle(	theSummary,
									CString(	STRx_AdminStrings,
												kNotEnforcedStringID));
		}
	} else {
		AppendStringToHandle(theSummary, none);
	}

	// Add PGPdisk ADK
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kPGPdiskADKStringID));
	if (FindPaneByID(checkbox_UsePGPdiskADK)->GetValue() == Button_On) {
		((CKeyTable *) FindPaneByID(table_PGPdiskADK))->
			GetFirstSelectedUserID(data);
		AppendStringToHandle(theSummary, data);
	} else {
		AppendStringToHandle(theSummary, none);
	}
	
	// Enforce Remote ADK
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kEnforceRemoteADKStringID));
	if (FindPaneByID(checkbox_EnforceRemoteADKStrictness)->GetValue() == Button_On) {
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kYesStringID));
	} else {
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kNoStringID));
	}
	
	// Enforce Minimum Passphrase Length
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kEnforceMinimumPassphraseLengthStringID));
	if (FindPaneByID(checkbox_EnforceMinimumPassphraseCharacters)->
	GetValue() == Button_On) {
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kYesStringID));
		AppendStringToHandle(theSummary, tab);
		FindPaneByID(edittext_MinimumPassphraseCharacters)->
			GetDescriptor(data);
		AppendStringToHandle(theSummary, data);
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kCharactersStringID));
	} else {
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kNoStringID));
	}

	// Enforce Minimum Passphrase Quality
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kEnforceMinimumPassphraseQualityStringID));
	if (FindPaneByID(checkbox_EnforceMinimumPassphraseQuality)->
	GetValue() == Button_On) {
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kYesStringID));
		AppendStringToHandle(theSummary, tab);
		FindPaneByID(edittext_MinimumPassphraseQuality)->
			GetDescriptor(data);
		AppendStringToHandle(theSummary, data);
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kPercentStringID));
	} else {
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kNoStringID));
	}

	// Corporate Key
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kCorporateKeyStringID));
	temp = false;
	if (FindPaneByID(checkbox_AutoSignCorporateKey)->
	GetValue() == Button_On) {
		((CKeyTable *) FindPaneByID(table_CorporateKey))->
			GetFirstSelectedUserID(data);
		AppendStringToHandle(theSummary, data);
		AppendStringToHandle(theSummary, "\p\r");
		temp = true;
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kAutoSignStringID));
		if (FindPaneByID(checkbox_CorporateKeyIsMetaIntroducer)->
		GetValue() == Button_On) {
			AppendStringToHandle(theSummary, "\p\r");
			AppendStringToHandle(	theSummary,
									CString(	STRx_AdminStrings,
												kMetaIntroducerStringID));
		}
	} else {
		AppendStringToHandle(theSummary, none);
	}
	
	// Encrypt to Keys Not Signed by Corporate Key
	if (temp) {
		AppendStringToHandle(
			theSummary,
			CString(	STRx_AdminStrings,
			kEncryptToKeysNotSignedByCorporateKeyStringID));
		if (FindPaneByID(checkbox_WarnIfNotSignedByCorporateKey)->
		GetValue() == Button_On) {
			AppendStringToHandle(	theSummary,
									CString(	STRx_AdminStrings,
												kWarnStringID));
		} else {
			AppendStringToHandle(	theSummary,
									CString(	STRx_AdminStrings,
												kDoNotWarnStringID));
		}
	}

	// Add DesignatedRevoker
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kDesignatedRevokerStringID));
	if (FindPaneByID(checkbox_EnableADesignatedRevokerKey)->
	GetValue() == Button_On) {
		((CKeyTable *) FindPaneByID(table_DesignatedRevoker))->
			GetFirstSelectedUserID(data);
		AppendStringToHandle(theSummary, data);
	} else {
		AppendStringToHandle(theSummary, none);
	}
		
	// Key Generation
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kKeyGenerationStringID));
	if (FindPaneByID(checkbox_AllowKeyGeneration)->
	GetValue() == Button_On) {
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kAllowedStringID));
		if (FindPaneByID(checkbox_AllowKeyGeneration)->
		GetValue() == Button_Off) {
			AppendStringToHandle(
				theSummary,
				CString(	STRx_AdminStrings,
							kRSAAlgorithmDisabledStringID));
		}
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kMinimumKeyGenerationSize));
		FindPaneByID(edittext_MinimumKeySize)->
			GetDescriptor(data);
		AppendStringToHandle(theSummary, data);
	} else {
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kNotAllowedStirngID));
	}
	
	// Automatic Updates
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kAutomaticUpdatesStringID));
	temp = false;
	if (FindPaneByID(checkbox_UpdateTrustedIntroducers)->
	GetValue() == Button_On) {
		temp = true;
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kEveryStringID));
		FindPaneByID(edittext_UpdateTrustedIntroducers)->
			GetDescriptor(data);
		AppendStringToHandle(theSummary, data);
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kTrustedIntroducersStringID));
	}
	if (FindPaneByID(checkbox_UpdateAllKeys)->GetValue() == Button_On) {
		if (temp) {
			AppendStringToHandle(theSummary, "\p\r");
		}
		temp = true;
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kEveryStringID));
		FindPaneByID(edittext_UpdateAllKeys)->
			GetDescriptor(data);
		AppendStringToHandle(theSummary, data);
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kAllKeysStringID));
	}
	if (! temp) {
		AppendStringToHandle(theSummary, none);
	}	

	// Allow Conventional Encryption
	AppendStringToHandle(
		theSummary,
		CString(	STRx_AdminStrings,
					kAllowConventionalEncryptionStringID));
	if (FindPaneByID(checkbox_AllowConventionalEncryption)->
	GetValue() == Button_On) {
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kYesStringID));
	} else {
		AppendStringToHandle(	theSummary,
								CString(	STRx_AdminStrings,
											kNoStringID));
	}

	// Message Header Comment
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kMessageHeaderCommentStringID));
	FindPaneByID(edittext_MessageHeaderComment)->GetDescriptor(data);
	if (data.GetLength() != 0) {
		AppendStringToHandle(theSummary, data);
	} else {
		AppendStringToHandle(theSummary, none);
	}
	
	// Pre-Loaded Keys
	PGPKeySetRef	keySet = kInvalidPGPKeySetRef;
	PGPKeyListRef	keyList = kInvalidPGPKeyListRef;
	PGPKeyIterRef	keyIter = kInvalidPGPKeyIterRef;
	
	AppendStringToHandle(	theSummary,
							CString(	STRx_AdminStrings,
										kPreLoadedKeysStringID));
	try {
		((CKeyTable *) FindPaneByID(table_DefaultKeys))->
			GetSelectedKeys(&keySet);
		pgpErr = PGPOrderKeySet(	keySet,
									kPGPUserIDOrdering,
									&keyList);
		PGPThrowIfPGPErr_(pgpErr);
		pgpErr = PGPNewKeyIter(	keyList,
								&keyIter);
		PGPThrowIfPGPErr_(pgpErr);

		PGPKeyRef		key;
		PGPSize			len;

		while ((PGPKeyIterNext(keyIter, &key) == kPGPError_NoErr)
		&& PGPKeyRefIsValid(key)) {
			AppendStringToHandle(theSummary, tab);
			pgpErr = PGPGetPrimaryUserIDNameBuffer(	key,
													data.GetBufferSize(),
													data,
													&len);
			if (pgpErr != kPGPError_BufferTooSmall) {
				PGPThrowIfPGPErr_(pgpErr);
			}
			AppendStringToHandle(theSummary, data);
			AppendStringToHandle(theSummary, "\p\r");
		}

		PGPFreeKeyIter(keyIter);
		PGPFreeKeyList(keyList);
		PGPFreeKeySet(keySet);
	}
	
	catch (...) {
		if (PGPKeyIterRefIsValid(keyIter)) {
			PGPFreeKeyIter(keyIter);
		}
		if (PGPKeyListRefIsValid(keyList)) {
			PGPFreeKeyList(keyList);
		}
		if (PGPKeySetRefIsValid(keySet)) {
			PGPFreeKeySet(keySet);
		}
		throw;
	}
	
	// Set the edit field
	((LTextEditView *) FindPaneByID(texteditview_Summary))->
		SetTextHandle(theSummary);
	::DisposeHandle(theSummary);
}



	OSStatus
CAdminDialog::AddCompanyNameToInstaller(
	FSSpec *	inFileSpec,
	StringPtr	inCompanyName)
{
	OSStatus	result;
	SInt16		resourceForkRefNum = -1;
	
	try {
		CString	adminStr(STRx_AdminStrings, kInstallerAdminStringID);
		CString	configuredStr(STRx_AdminStrings, kConfiguredForStringID);
		
		if (inCompanyName[0] > 0) {
			AppendPString(inCompanyName, configuredStr);
		} else {
			CString client(STRx_AdminStrings, kClientStringID);
			
			AppendPString(client, configuredStr);
		}
		::SetResLoad(false);
		resourceForkRefNum = ::FSpOpenResFile(inFileSpec, fsRdWrPerm);
		::SetResLoad(true);
		PGPThrowIfResError_();
		
		// Get the TEXT resource
		StResource	theText(kTextResType, TEXT_EasyInstall, true, true);
		SInt32		mungerResult;
		
		// Modify and update the resource
		mungerResult = ::Munger(theText, 0, adminStr.GetConstCString(),
						adminStr.GetLength(), configuredStr.GetConstCString(),
						configuredStr.GetLength());
		PGPThrowIf_(mungerResult < 0);
		::ChangedResource(theText);
		PGPThrowIfResError_();		
		::UpdateResFile(resourceForkRefNum);
		PGPThrowIfResError_();
		result = noErr;
	}
	
	catch (CComboError & exception) {
		result = exception.err;
	}
	
	catch (...) {
		result = fnfErr;
	}
	
	if (resourceForkRefNum != -1) {
		::CloseResFile(resourceForkRefNum);
		::FlushVol(nil, inFileSpec->vRefNum);
	}
	
	return result;
}



	Boolean
CAdminDialog::HandleKeyPress(
	const EventRecord &	inKeyEvent)
{
	Boolean	handled = false;
	SInt16	currentPanel = dynamic_cast<LMultiPanelView &>(
							*FindPaneByID(pane_MultiPanel)).GetCurrentIndex();

	// Skip the unneeded panes
	if (currentPanel == panel_Summary) {
		Char16	theKey = (Char16(inKeyEvent.message) & charCodeMask);
		
		switch (theKey) {
			case char_PageUp:
			case char_PageDown:
			{
				SInt16			thePart = (theKey == char_PageUp) ? kControlPageUpPart :
									kControlPageDownPart;
									
				dynamic_cast<LScrollerView &>(*FindPaneByID(scroller_Summary)).VertScroll(thePart);
				handled = true;
			}
			break;
		}
	}
	
	if (! handled) {
		handled = LGADialog::HandleKeyPress(inKeyEvent);
	}
	
	return handled;
}
