/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CKeyView.h,v 1.13.8.1 1998/11/12 03:08:06 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LView.h>

#include "pgpKeys.h"

class CKeyTable;
class CKeyTableLabels;
class LCaption;
class LBevelButton;
class CPGPActiveScroller;

const ResIDT	kKeyViewResID		=	132;

class CKeyView	:	public LView
{
public:
	enum {	class_ID = 'keyV'	};
	

					CKeyView();
					CKeyView(LStream	*inStream);
					~CKeyView();
					
	virtual void	FinishCreateSelf();
	
	virtual void	CloseKeys();
	virtual void	SetKeyDBInfo(	PGPKeySetRef	keySet,
									Boolean			writable,
									Boolean			defaultRings
								);
	PGPKeySetRef	GetKeySet();
	CKeyTable		*GetKeyTable()	{	return mKeyTable;	}
	virtual void	Empty();
	void			ImportKeysFromHandle(Handle data);
	
	LCaption		*GetCaptionPane()	{	return mStatusCaption;	}
	LBevelButton	*GetLockButton()	{	return mLockButton;		}
	LBevelButton	*GetUnlockButton()	{	return mUnlockButton;	}
	
protected:
	enum	{
				kStringListID 	= 1000,
				kUserIDStringID		= 1,
				kValidityStringID,
				kTrustStringID,
				kCreationStringID,
				kSizeStringID
			};

private:
	Boolean						mIsDefaultKeyrings;
	CKeyTable					*mKeyTable;
	CKeyTableLabels				*mKeyTableLabels;
	CPGPActiveScroller			*mKeyScroller;
	LCaption					*mStatusCaption;
	LBevelButton				*mLockButton;
	LBevelButton				*mUnlockButton;
	
	enum	{	
				kKeyTableLabels			= 'lKey',
				kKeyTable				= 'tKey',
				kKeyScroller			= 'sKey',
				kStatusPlacard			= 'Plaq',
				kStatusCaption			= 'cSta',
				kUnlockButton			= 'bULk',
				kLockButton				= 'bLok'
			};
};

