/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CSearchWindow.h,v 1.26.8.1 1998/11/12 03:08:15 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LCaption.h>
#include <LSimpleThread.h>
#include <LWindow.h>
#include <LCommander.h>
#include <LListener.h>
#include <LBroadcaster.h>
#include <LPeriodical.h>

#include "pgpPubTypes.h"
#include "pgpKeyServerPrefs.h"
#include "pgpTLS.h"

class CKeyView;
class LPopupButton;
class CSearchPanel;
class LPushButton;
class LCheckBox;
class LBevelButton;
class LChasingArrows;
class LPlacard;
class LTextGroupBox;

const ResIDT	kSearchWindowID		= 133;
const MessageT	kSearchWindowClosed	= 'SWcl';
const MessageT	kSearchInProgress	= 'SIPr';
const MessageT	kSearchComplete		= 'SCom';

typedef struct SearchPanelList
{
	CSearchPanel *panel;
	SearchPanelList *next;
} SearchPanelList;

typedef struct KSCallbackInfo
{
	CommandT				command;
	LChasingArrows			*progressBar;
	LBevelButton			*lockButton;
	LBevelButton			*unlockButton;
	LCaption				*statusCaption;
	ulong					lastIncrement;
	PGPUInt32				lastState;
	PGPFilterRef			filter;
	PGPKeySetRef			actionKeys;
	PGPKeySetRef			authKeySet;
	PGPKeyServerRef			server;
	PGPKeyServerEntry		serverInfo;
	PGPtlsCipherSuiteNum	tlsCipher;
	PGPBoolean				serverChanged;
	PGPError				result;
	Boolean					done;
	Boolean					abort;
} KSCallbackInfo;


class	CSearchWindow	:	public LWindow,
							public LListener,
							public LBroadcaster,
							public LPeriodical
{
public:
	enum { class_ID = 'Swin' };
								CSearchWindow();
								CSearchWindow(LStream *inStream);
								~CSearchWindow();
	void						FinishCreateSelf();
	virtual void				ApplyForeAndBackColors(void) const;
	virtual void				AttemptClose();
	Boolean						HandleKeyPress(const EventRecord& inKeyEvent);
	virtual void				FindCommandStatus(CommandT inCommand,
									Boolean &outEnabled, Boolean &outUsesMark,
									Char16 &outMark, Str255 outName);
	Boolean						ObeyCommand(
									CommandT	inCommand,
									void		*ioParam);
	void						ListenToMessage(MessageT	inMessage,
												void *		ioParam);
	CKeyView					*GetKeyView()
									{	return mKeyView;	}
	
	void						SpendTime(
									const EventRecord		&inMacEvent);
	
	void						SearchServer(void *arg);
private:
	virtual void				AdjustSizeToSearches();
	virtual void				AddEmptySearch(Boolean	first);
	virtual void				RemoveLastSearch();
	virtual void				FillServerPopup();
	void						Search();
	void						StartServerThread(
									CommandT			inCommand,
									PGPFilterRef		inFilter,
									PGPKeySetRef		inKeys,
									PGPKeyServerEntry	*inServerInfo );
	PGPError					MakeFilterFromPanels(
									PGPFilterRef *outFilter);
	
	CKeyView					*mKeyView;
	LPushButton					*mSearchButton,
								*mClearSearchButton,
								*mMoreButton,
								*mFewerButton;
	LCaption					*mStatusCaption;
	LPlacard					*mHeaderPlacard;
	LChasingArrows				*mProgressArrows;
	LBevelButton				*mLockButton;
	LBevelButton				*mUnlockButton;
	MessageT					mLockMessage;
	LCheckBox					*mPendingCheckBox;
	LPopupButton				*mServerPopup;
	LTextGroupBox				*mSearchesBox;
	Int16						mNumSearches;
	Int16						mPanelHeight;
	SearchPanelList				*mSearchPanelList;
	PGPKeyServerEntry			*mServers;
	PGPKeyServerEntry			mLastServer;
	PGPBoolean					mLastServerValid;
	Int32						mNumServers;
	KSCallbackInfo				mActionInfo;
	Boolean						mWorking;
	LSimpleThread				*mServerThread;
	
	enum	{	
				kSearchesBox	 		= 'gPrm',
				kMoreButton		 		= 'bMor',
				kFewerButton			= 'bFew',
				kSearchButton			= 'bSea',
				kClearSearchButton		= 'bCle',
				kServerPopup			= 'pKSS',
				kBottomBar				= 'bBot',
				kPendingCheckbox		= 'xPnd',
				kProgressArrows			= 'chAr',
				kHeaderPlaque			= 'Plaq'
			};
};

