/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: GetPassphrase.cp,v 1.10.8.1 1998/11/12 03:08:20 heller Exp $
____________________________________________________________________________*/

#include <UDesktop.h>

#include "MacStrings.h"
#include "pgpUserInterface.h"
#include "pgpClientLib.h"

#include "CPGPKeys.h"
#include "GetPassphrase.h"

	PGPError
DoPassphraseDialog(
	PGPKeyRef	theKey,
	char 		*passphrase)
{
	PGPError	err;
	char		*outputPassphrase;
	
	*passphrase = 0;
	
	UDesktop::Deactivate();
	
	err = PGPKeyPassphraseDialog( gPGPContext, theKey,
				PGPOUIOutputPassphrase( gPGPContext, &outputPassphrase ),
				PGPOLastOption( gPGPContext ) );
	
	UDesktop::Activate();
	
	if( IsntPGPError( err ) )
	{
		CopyCString( outputPassphrase, passphrase );
		PGPFreeData( outputPassphrase );
	}
	
	return err;
}

	PGPError
GetPassForKey(
	PGPKeyRef		key,
	PGPBoolean		*isSplit,
	char			*passphrase,
	PGPByte			**passKey,
	PGPSize			*passKeySize )
{
	PGPError		err = kPGPError_NoErr;
	PGPBoolean		split,
					needsPass;
	
	PGPValidatePtr( isSplit );
	PGPValidatePtr( passphrase );
	PGPValidatePtr( passKey );
	PGPValidatePtr( passKeySize );
	
	*isSplit = FALSE;
	*passphrase = '\0';
	PGPGetKeyBoolean( key, kPGPKeyPropNeedsPassphrase, &needsPass );
	if( needsPass )
	{
		PGPGetKeyBoolean( key, kPGPKeyPropIsSecretShared, &split );
		if( split )
		{
			UDesktop::Deactivate();
				err = PGPReconstitutionDialog( key,
							CPGPKeys::TheApp()->GetKeySet(),
							gTLSContext,
							passKey, passKeySize );
			UDesktop::Activate();	CKERR;
			*isSplit = TRUE;
		}
		else
			err = DoPassphraseDialog( key, passphrase );
	}
done:
	return err;
}

