/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.

	$Id: CPGPtoolsTaskProgressDialog.h,v 1.3.8.1 1998/11/12 03:09:17 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "PGPtools.h"
#include "CGAProgressDialog.h"

class CPGPStDialogHandler;

class CPGPtoolsTaskProgressDialog : public CGAProgressDialog
{
public:

	enum { class_ID = 'TskP' };

	virtual				~CPGPtoolsTaskProgressDialog();
						CPGPtoolsTaskProgressDialog(LStream *inStream);

	UInt32				GetTotalCompletedBytes(void)
									{ return( mTotalCompletedBytes ); };
	void				SetTotalCompletedBytes(UInt32 totalBytes)
									{ mTotalCompletedBytes = totalBytes; };

	void				SetTaskCompletedBytes(UInt32 taskBytes)
									{ mTaskCompletedBytes = taskBytes; };

	CPGPStDialogHandler	*GetDialogHandler(void)
									{ return( mDialogHandler ); };
	void				SetDialogHandler(CPGPStDialogHandler *handler)
									{ mDialogHandler = handler; };

	void				SetProgressOperation(PGPtoolsOperation operation);

	void				SetNewProgressItem(ConstStr255Param itemName);
	virtual	void		SetCompletedOperations(UInt32 completedOps);
						
private:

	UInt32				mTaskCompletedBytes;
	// Does not include mTaskCompletedBytes:
	UInt32				mTotalCompletedBytes;
	CPGPStDialogHandler	*mDialogHandler;
	PGPtoolsOperation	mProgressOperation;
	Str255				mItemNameFormatStr;
	UInt32				mShowDelayStartTicks;
};