/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPModalGrafPortView.h,v 1.10.12.1 1998/11/12 03:18:57 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <Dialogs.h>

#include <LGrafPortView.h>
#include <LListener.h>

#include "PGPPubTypes.h"

class LPushButton;
class LArray;
struct SavedWindowBitsInfo;

class CPGPModalGrafPortView : public LGrafPortView,
								public LListener
{
public:
	enum { class_ID = 'Ppvw' };

						CPGPModalGrafPortView(LStream *inStream);
	virtual				~CPGPModalGrafPortView(void);
	
	virtual void		ApplyForeAndBackColors(void) const;
	virtual PGPError	DoDialog(void);
	virtual void		DoIdle(const EventRecord &inMacEvent);
	virtual void		Draw(RgnHandle	inSuperDrawRgnH);
	virtual void		FinishCreateSelf(void);
	DialogRef			GetDialog(void);
	virtual void		GetForeAndBackColors(RGBColor *outForeColor,
								RGBColor *outBackColor) const;
	virtual void		GlobalToPortPoint(Point &ioPoint) const;
	virtual Boolean		HandleKeyPress(const EventRecord &inKeyEvent);
	virtual void		ListenToMessage(MessageT inMessage, void *ioParam);
	virtual Boolean		ModalFilterProc(DialogPtr theDialog,
									EventRecord *theEvent, short *itemHit);
	virtual void		PortToGlobalPoint(Point &ioPoint) const;
	void				RememberInvalidWindow(WindowRef theWindow);
	virtual	void 		UpdatePort(void);
	
	MessageT			GetDismissMessage(void)
									{ return( mDismissMessage ); };
	void				SetDismissMessage(MessageT message)
									{ mDismissMessage = message; };

	static DialogRef 		CreateDialog(ResIDT dialogResID);
	static CPGPModalGrafPortView *GetWindowGrafPortView(WindowPtr theWindow);
	static pascal Boolean	ModalFilterProcHandler(DialogPtr theDialog,
										EventRecord *theEvent,
										short *itemHit);
	
protected:

	MessageT			mDismissMessage;
	LPushButton			*mOKButton;
	LPushButton			*mCancelButton;
	LArray				*mInvalidWindowList;
	Boolean				mWindowIsMoveable;
	Boolean				mWindowIsResizeable;
	Rect				mMinMaxSize;
	Boolean				mSaveRestoreWindowBits;
	SavedWindowBitsInfo	*mSavedWindowBitsList;
	SDimension16		mStandardSize;
	Rect				mUserBounds;
	Boolean				mMoveOnlyUserZoom;
	UInt32				mLastIdleTicks;
	PGPError			mDialogError;
	LArray				*mEnabledMenuItems;
	MenuHandle			mEditMenu;
	SInt16				mCutItem;
	SInt16				mCopyItem;
	SInt16				mPasteItem;
//	SInt16				mUndoItem;
	SInt16				mSelectAllItem;
	ModalFilterUPP		mModalFilterProc;
	
	virtual void		ClickMenuBar(const EventRecord &inMacEvent);
	Boolean				ClickInDrag(const EventRecord &inMacEvent);
	Boolean				ClickInGrow(const EventRecord &inMacEvent);
	Boolean				ClickInZoom(const EventRecord &inMacEvent,
								Int16 inZoomDirection);
	void				SaveAllWindowBits(void);
	void				SaveWindowBits(WindowRef theWindow);
	void				RestoreWindowBits(WindowRef theWindow);
	Boolean				CalcStandardBounds(Rect &outStdBounds) const;
	void				CalcStandardBoundsForScreen(
								const Rect &inScreenBounds,
								Rect &outStdBounds) const;
	void				DoSetZoom(Boolean inZoomToStdState);
	virtual MessageT	HandleMessage(MessageT theMessage);
	void				ResizeWindowTo(Int16 newWidth, Int16 newHeight);
	
	CommandT			FindCommand(ResIDT menuID, SInt16 item);
	void				SaveAndDisableEnabledMenus();
	void				RestoreEnabledMenus();
	void				UpdateMenus();
	
private:

	CPGPModalGrafPortView	*mNextView;
};
