/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPConfPassphraseGrafPort.cp,v 1.4.12.1 1998/11/12 03:20:28 heller Exp $
____________________________________________________________________________*/

#include <string.h>

#include <LCheckbox.h>
#include <LProgressBar.h>
#include <PP_Messages.h>

#include "MacSecureMemory.h"

#include "CPassphraseEdit.h"
#include "CPGPConfPassphraseGrafPort.h"
#include "PGPsdkUILibDialogs.h"

CPGPConfPassphraseGrafPortView::
	CPGPConfPassphraseGrafPortView(LStream *inStream)
	: CPGPPassphraseGrafPortView(inStream)
{
	mOptions 			= NULL;
	mPassphraseQualityBar	= NULL;
}

CPGPConfPassphraseGrafPortView::~CPGPConfPassphraseGrafPortView()
{
}

	void
CPGPConfPassphraseGrafPortView::FinishCreateSelf()
{
	CPGPPassphraseGrafPortView::FinishCreateSelf();
	
	mConfirmationEdit =
		(CPassphraseEdit *) FindPaneByID( kConfirmationEditFieldPaneID );
	mPassphraseQualityBar = 
		(LProgressBar *) FindPaneByID( kPassphraseQualityBarPaneID );
		
	pgpAssertAddrValid( mConfirmationEdit, VoidAlign );	
	pgpAssertAddrValid( mPassphraseQualityBar, VoidAlign );
	
	SwitchTarget( mPassphraseEdit );

	mPassphraseQualityBar->SetValue ( 0 );
}

	void
CPGPConfPassphraseGrafPortView::ListenToMessage(
	MessageT 	inMessage,
	void 		*ioParam)
{
	if( inMessage == msg_HideTyping )
	{
		mConfirmationEdit->SetHideTyping(
					mHideTypingCheckbox->GetValue() == 1 );
	}
	else if( inMessage == msg_ChangedPassphrase )
	{
		if( mPassphraseQualityBar->IsVisible() )
		{
			PGPUInt32	quality;
		
			quality = mPassphraseEdit->EstimatePassphraseQuality();
			mPassphraseQualityBar->SetValue( quality );
		}
	}
	
	CPGPPassphraseGrafPortView::ListenToMessage( inMessage, ioParam );
}

	PGPError
CPGPConfPassphraseGrafPortView::SetOptions(
	PGPContextRef	context,
	CPGPConfirmationPassphraseDialogOptions *options)
{
	PGPError	err = kPGPError_NoErr;
	
	err = CPGPPassphraseGrafPortView::SetOptions( context, options );
	if( IsntPGPError( err ) )
	{
		mOptions = options;
		
		if( ! mOptions->mShowPassphraseQuality )
		{
			LPane	*qualityCaption;
			
			qualityCaption = FindPaneByID( kPassphraseQualityCaptionPaneID );
			pgpAssertAddrValid( qualityCaption, VoidAlign );
			
			mPassphraseQualityBar->Hide();
			qualityCaption->Hide();
		}
	}
		
	return( err );
}

	void
CPGPConfPassphraseGrafPortView::ClearPassphrase(void)
{
	CPGPPassphraseGrafPortView::ClearPassphrase();
	
	mConfirmationEdit->ClearPassphrase();
	SwitchTarget( mPassphraseEdit );
}

	MessageT
CPGPConfPassphraseGrafPortView::HandleMessage(MessageT theMessage)
{
	if( theMessage == msg_OK )
	{
		CSecureCString256	testPassphrase;
		CSecureCString256	testConfirmation;
		
		mPassphraseEdit->GetPassphrase( testPassphrase );
		mConfirmationEdit->GetPassphrase( testConfirmation );
		
		if( strcmp( testPassphrase, testConfirmation ) != 0 )
		{
			SysBeep( 1 );
			
			PGPUIWarningAlert( kPGPUIGenericOKAlert,
						kPGPLibDialogsStringListResID,
						kConvEncryptionPassphraseNotConfirmedStrIndex );
			
			ClearPassphrase();
			
			theMessage = msg_Nothing;
		}
		else
		{
			theMessage = CPGPPassphraseGrafPortView::HandleMessage(theMessage);
		}
	}
	
	return( theMessage );
}