/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPOptionsGrafPort.h,v 1.7.12.1 1998/11/12 03:20:36 heller Exp $
____________________________________________________________________________*/

#pragma once

// Public includes:
#include "CComboError.h"
#include "pgpPubTypes.h"

// Private includes:
#include "CPGPUIGrafPortView.h"

class CPGPOptionView;
class CPGPOptionsListView;
class CPGPOptionsDialogOptions;

class CPGPOptionsGrafPort : public CPGPUIGrafPortView
{
public:

	enum { class_ID = 'OLGP' };
	
						CPGPOptionsGrafPort(LStream *inStream);
	virtual				~CPGPOptionsGrafPort();

	virtual void		UpdatePort();
	virtual void		FinishCreateSelf(void);
	
	PGPError			SetOptions(PGPContextRef context,
								CPGPOptionsDialogOptions *options);
	
protected:

	virtual void		DrawSelf(void);

private:

	CPGPOptionsListView	*mOptionsListView;
	
	const CPGPOptionsDialogOptions	*mOptions;
	
	void				AppendOptionView(CPGPOptionView *theView,
								Boolean inRefresh);
};

