/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPOptionsDialog.cp,v 1.6.12.1 1998/11/12 03:20:58 heller Exp $
____________________________________________________________________________*/

// Public includes:
#include <PP_Messages.h>
#include <URegistrar.h>

#include "CComboError.h"
#include "pgpPubTypes.h"
#include "pgpMem.h"
#include "pgpUserInterface.h"

// Private includes:
#include "CPGPOptionsGrafPort.h"
#include "CPGPOptionsListView.h"
#include "PGPsdkUILibDialogs.h"
#include "PGPsdkUILibUtils.h"
#include "pgpDialogs.h"

const ResIDT kPGPOptionsListDialogID	= 4752;

	PGPError
pgpOptionsDialogPlatform(
	PGPContextRef				context,
	CPGPOptionsDialogOptions 	*options)
{
	PGPsdkUILibState	state;
	PGPError			err;
	
	pgpAssertAddrValid( options, CPGPOptionsDialogOptions );

	err = EnterPGPsdkUILib( context, &state );
	if( IsntPGPError( err ) )
	{
		DialogRef	theDialog;
		
		RegisterClass_( CPGPOptionsGrafPort );
		RegisterClass_( CPGPOptionsListView );
		
		theDialog = CPGPOptionsGrafPort::CreateDialog(
								kPGPOptionsListDialogID );
		if( IsntNull( theDialog ) )
		{
			CPGPOptionsGrafPort	*optionsGrafPortView;
			
			optionsGrafPortView = (CPGPOptionsGrafPort *)
										GetWRefCon( theDialog );
			pgpAssertAddrValid( optionsGrafPortView, VoidAlign );
			
			err = optionsGrafPortView->SetOptions( context, options );
			if( IsntPGPError( err ) )
			{
				err = optionsGrafPortView->DoDialog();
			}
			
			delete optionsGrafPortView;
			DisposeDialog( theDialog );
		}
		else
		{
			err = kPGPError_OutOfMemory;
		}
	}
		
	ExitPGPsdkUILib( &state );
	
	return( err );
}
