/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CMacTCPInternetSocket.cp,v 1.7.12.1 1998/11/12 03:22:25 heller Exp $
____________________________________________________________________________*/

#include <Devices.h>
#include <stdarg.h>

#include "pgpMem.h"

#include "CMacTCPInternetSocket.h"



SInt16	CMacTCPInternetSocket::sRefNum;


CMacTCPInternetSocket::CMacTCPInternetSocket()
	: mBoundPort(0), mBoundAddress(0), mAbort(false),
	  mBound(false), mConnected(false)
{
	OSStatus		err;
	static Boolean	sRefInitialized = false;
	
	if (! sRefInitialized) {
		ParamBlockRec theParamBlock;
		
		theParamBlock.ioParam.ioNamePtr = "\p.IPP";
		theParamBlock.ioParam.ioPermssn = fsCurPerm;
		
		err = ::PBOpenSync(&theParamBlock);
		if (err != noErr) {
			ThrowPGPError_(kPGPError_SocketsNetworkDown);
		}
		sRefNum = theParamBlock.ioParam.ioRefNum;
		sRefInitialized = true;
	}
}



CMacTCPInternetSocket::~CMacTCPInternetSocket()
{
}



	void
CMacTCPInternetSocket::Close()
{
	if (mInCallback) {
		mAbort = true;
	} else {
		Cleanup();
		delete this;
	}
}



	void
CMacTCPInternetSocket::Bind(
	const PGPSocketAddressInternet *	inAddress)
{
	mBoundPort = inAddress->sin_port;
	mBoundAddress = inAddress->sin_addr.s_addr;
	mBound = true;
}



	void
CMacTCPInternetSocket::Cleanup()
{
}



	void
CMacTCPInternetSocket::GetSocketName(
	PGPSocketAddressInternet *	outName)
{
	if (mBound) {
		pgpClearMemory(outName, sizeof(PGPSocketAddressInternet));
		outName->sin_family = kPGPAddressFamilyInternet;
		outName->sin_port = mBoundPort;
		outName->sin_addr.s_addr = mBoundAddress;
	} else {
		ThrowPGPError_(kPGPError_SocketsNotBound);
	}
}



	void
CMacTCPInternetSocket::ProcessCommand(
	SInt16			inCSCode,
	IPParamBlock *	inParamBlock)
{
	OSStatus	err;
	
	inParamBlock->csCode = inCSCode;
	inParamBlock->ioCRefNum = sRefNum;
	
	err = ::PBControlAsync((ParmBlkPtr) inParamBlock);
	if (err != noErr) {
		ThrowPGPError_(err);
	}
	while ((inParamBlock->ioResult == inProgress) && (! mAbort)) {
		mInCallback = true;
		if (CallIdleEventHandler() != kPGPError_NoErr) {
			Close();
		};
		mInCallback = false;
	}
	if (mAbort) {
		Close();
		ThrowPGPError_(kPGPError_UserAbort);
	}
	if (inParamBlock->ioResult != noErr) {
		ThrowPGPError_(inParamBlock->ioResult);
	}
}
