/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: COTInternetUtilities.cp,v 1.9.10.1 1998/11/12 03:22:31 heller Exp $
____________________________________________________________________________*/

#include <string.h>

#include "pgpMem.h"

#include "COTInternetUtilities.h"



COTInternetUtilities::COTInternetUtilities()
	: mInetSvcRef(nil)
{
	OSStatus	err;

	mInetSvcRef = ::OTOpenInternetServices(	kDefaultInternetServicesPath,
											0,
											&err);
	if (err != kOTNoError) {
		ThrowPGPError_(err);
	}
	err = ::OTInstallNotifier(	mInetSvcRef,
								NotifyProc,
								this);
	if (err != kOTNoError) {
		ThrowPGPError_(err);
	}
	err = ::OTUseSyncIdleEvents(	mInetSvcRef,
									true);
	if (err != kOTNoError) {
		ThrowPGPError_(err);
	}
}



COTInternetUtilities::~COTInternetUtilities()
{
	::OTCloseProvider(mInetSvcRef);
}


	PGPHostEntry *
COTInternetUtilities::GetHostByName(
	const char * inName)
{
	SThreadContext *	theContext = CSocket::GetThreadContext();
	InetHostInfo		hInfo;
	PGPHostEntry *		result = NULL;
	OSStatus			err;
	
	// Get the info
	err = ::OTInetStringToAddress(	mInetSvcRef,
									(char *) inName,
									&hInfo);
	if (err != kOTNoError) {
		ThrowPGPError_(err);
	}
										
	// Insert the name
	strncpy(theContext->hostEntry.h_name, hInfo.name, kMaxHostNameLen);
	theContext->hostEntry.h_name[kMaxHostNameLen] = 0;
	::BlockMoveData(	hInfo.addrs,
						theContext->hAddressesBuffer,
						sizeof(theContext->hAddressesBuffer));
	pgpClearMemory(	theContext->hAddressesListBuffer,
					sizeof(theContext->hAddressesListBuffer));
	for (UInt8 i = 0; (i < kMaxHostAddrs)
	  && (theContext->hAddressesBuffer[i] != 0); i++) {
		theContext->hAddressesListBuffer[i] = &theContext->hAddressesBuffer[i];
	}
	result = &theContext->hostEntry;

	return result;
}



	PGPHostEntry *
COTInternetUtilities::GetHostByAddress(
	PGPInternetAddress	inAddress)
{
	SThreadContext *	theContext = CSocket::GetThreadContext();
	InetDomainName		domainName;
	PGPHostEntry *		result = NULL;
	OSStatus			err;

	// Get the info
	err = ::OTInetAddressToName(	mInetSvcRef,
									inAddress.s_addr,
									domainName);
	if (err != kOTNoError) {
		ThrowPGPError_(err);
	}
										
	return GetHostByName(domainName);
}



	void
COTInternetUtilities::GetHostName(
	char *	outName,
	SInt32	inNameLength)
{
	InetInterfaceInfo	info;
	PGPHostEntry *		result;
	OSStatus			err;
	
	err = ::OTInetGetInterfaceInfo(&info, kDefaultInetInterface);
	if (err != kOTNoError) {
		ThrowPGPError_(err);
	}
	
	result = GetHostByAddress(*((PGPInternetAddress *) &info.fAddress));
	strncpy(outName, result->h_name, inNameLength - 1);
	outName[inNameLength - 1] = 0;
}



	pascal void
COTInternetUtilities::NotifyProc(
	void *		contextPtr,
	OTEventCode	code, 
	OTResult	result,
	void *		cookie)
{
	(void) result;
	(void) cookie;
	
	if (code == kOTSyncIdleEvent) {
		if (CSocket::CallIdleEventHandler() != kPGPError_NoErr) {
			::OTCancelSynchronousCalls(
				((COTInternetUtilities *) contextPtr)->mInetSvcRef,
				kOTCanceledErr);
		}
	}
}
